/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal;

import com.ibm.cic.common.core.artifactrepo.impl.AtocVersionInfo;
import com.ibm.cic.common.core.internal.repository.TocVersionInfo;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.internal.ArtifactToInstallSizeAdapterFactory;
import com.ibm.cic.common.core.utils.MetaInfo;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ComIbmCicCommonCorePlugin
extends Plugin {
    private static final String DEFAULT_SYMBOLIC_NAME = "com.ibm.cic.common.core";
    private BundleContext m_context;
    private static CicCommonCorePluginTrace trace = null;
    private static ComIbmCicCommonCorePlugin m_plugin;

    public ComIbmCicCommonCorePlugin() {
        m_plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createTracer();
        if (trace != null) {
            trace.entering();
        }
        this.m_context = context;
        System.setProperty("cic.metadata.version", MetaInfo.METADATA_VERSION.toString());
        System.setProperty("cic.metadata.tolerance", MetaInfo.METADATA_TOLERANCE.toString());
        System.setProperty("cic.toc.version", TocVersionInfo.VERSION_LATEST.toString());
        System.setProperty("cic.toc.tolerance", TocVersionInfo.TOLERANCE.toString());
        System.setProperty("cic.atoc.version", AtocVersionInfo.ATOC_VERSION_LATEST.toString());
        System.setProperty("cic.atoc.tolerance", AtocVersionInfo.ATOC_TOLERANCE.toString());
        System.setProperty("cic.installPublication.version", MetaInfo.INSTALL_PUBLICATION_VERSION.toString());
        if (trace != null) {
            trace.exiting();
        }
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)new ArtifactToInstallSizeAdapterFactory(), IArtifact.class);
    }

    public void stop(BundleContext context) throws Exception {
        if (trace != null) {
            trace.entering();
        }
        super.stop(context);
        m_plugin = null;
        this.m_context = null;
        if (trace != null) {
            trace.exiting();
        }
    }

    public static ComIbmCicCommonCorePlugin getDefault() {
        return m_plugin;
    }

    public static BundleContext getBundleContext() {
        return m_plugin == null ? null : m_plugin.getContext();
    }

    public static CicCommonCorePluginTrace getTrace() {
        if (trace == null) {
            trace = new CicCommonCorePluginTrace(DEFAULT_SYMBOLIC_NAME);
        }
        return trace;
    }

    private void createTracer() {
        try {
            trace = new CicCommonCorePluginTrace(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        m_plugin.getLog().log((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 4, message, null));
    }

    public static void log(IStatus status) {
        ComIbmCicCommonCorePlugin.getDefault().getLog().log(status);
    }

    public static void logException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, message, e);
        }
        ComIbmCicCommonCorePlugin.log(status);
    }

    public static String getPluginId() {
        if (ComIbmCicCommonCorePlugin.getDefault() != null) {
            return ComIbmCicCommonCorePlugin.getDefault().getBundle().getSymbolicName();
        }
        return DEFAULT_SYMBOLIC_NAME;
    }

    public BundleContext getContext() {
        return this.m_context;
    }
}

