/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.definitions;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProfileArch {
    public static final String IA64_32 = "ia64_32";
    public static final String IA64 = "ia64";
    public static final String PA_RISC = "PA_RISC";
    public static final String PA_RISC64 = "PA_RISC64";
    public static final String PPC = "ppc";
    public static final String PPC64 = "ppc64";
    public static final String PPC64LE = "ppc64le";
    public static final String S390 = "s390";
    public static final String S390X = "s390x";
    public static final String SPARC = "sparc";
    public static final String SPARC64 = "sparc64";
    public static final String SPARCV9 = "sparcv9";
    public static final String X86 = "x86";
    public static final String X86_64 = "x86_64";
    public static final String AARCH64 = "aarch64";
    private static final Map<String, String> arch32toArch64;
    private static final Map<String, String> arch64toArch32;
    private static final Set<String> architectures;

    static {
        LinkedHashMap<String, String> a32toA64 = new LinkedHashMap<String, String>();
        a32toA64.put(IA64_32, IA64);
        a32toA64.put(PA_RISC, PA_RISC64);
        a32toA64.put(PPC, PPC64);
        a32toA64.put(S390, S390X);
        a32toA64.put(SPARC, SPARC64);
        a32toA64.put(X86, X86_64);
        arch32toArch64 = Collections.unmodifiableMap(a32toA64);
        LinkedHashMap<String, String> a64toA32 = new LinkedHashMap<String, String>();
        LinkedHashSet<String> archs = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : arch32toArch64.entrySet()) {
            String arch32 = entry.getKey();
            String arch64 = entry.getValue();
            a64toA32.put(arch64, arch32);
            archs.add(arch32);
            archs.add(arch64);
        }
        a64toA32.put(SPARCV9, SPARC);
        a64toA32.put(PPC64LE, null);
        arch64toArch32 = Collections.unmodifiableMap(a64toA32);
        archs.add(PPC64LE);
        archs.add(SPARCV9);
        archs.add(AARCH64);
        architectures = Collections.unmodifiableSet(archs);
    }

    public static Set<String> getArchitectures() {
        return architectures;
    }

    public static Set<String> get32bitArchitectures() {
        return arch32toArch64.keySet();
    }

    public static Set<String> get64bitArchitectures() {
        return arch64toArch32.keySet();
    }

    public static String get32bitArch(String arch) {
        String arch32 = arch64toArch32.get(arch);
        if (arch32 != null) {
            return arch32;
        }
        return arch;
    }

    public static String get64bitArch(String arch) {
        String arch64 = arch32toArch64.get(arch);
        if (arch64 != null) {
            return arch64;
        }
        return arch;
    }

    public static boolean is32bitArch(String arch) {
        return arch32toArch64.containsKey(arch);
    }

    public static boolean is64bitArch(String arch) {
        return arch64toArch32.containsKey(arch);
    }
}

