/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.definitions;

import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Util;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public enum LanguageCode {
    ARABIC("ar", Messages.Environment_language_arabic, true, false, true),
    PORTUGUESE_BRAZILIAN("pt_BR", Messages.Environment_language_brazilian_portuguese, true, true, true),
    CATALAN("ca", Messages.Environment_language_catalan, false, false, true),
    CROATIAN("hr", Messages.Environment_language_croatian, true, false, true),
    CZECH("cs", Messages.Environment_language_czech, true, true, true),
    DANISH("da", Messages.Environment_language_danish, true, false, true),
    DUTCH("nl", Messages.Environment_language_dutch, true, false, true),
    ENGLISH("en", Messages.Environment_language_english, true, true, true),
    FINNISH("fi", Messages.Environment_language_finnish, true, false, true),
    FRENCH("fr", Messages.Environment_language_french, true, true, true),
    GERMAN("de", Messages.Environment_language_german, true, true, true),
    GREEK("el", Messages.Environment_language_greek, true, true, true),
    HEBREW("iw", Messages.Environment_language_hebrew, true, false, true),
    HUNGARIAN("hu", Messages.Environment_language_hungarian, true, false, true),
    INDONESIAN("in", Messages.Environment_language_indonesian, false, true, false),
    ITALIAN("it", Messages.Environment_language_italian, true, true, true),
    JAPANESE("ja", Messages.Environment_language_japanese, true, true, true),
    KOREAN("ko", Messages.Environment_language_korean, true, true, true),
    LITHUANIAN("lt", Messages.Environment_language_lithuanian, false, true, false),
    NORWEGIAN("no", Messages.Environment_language_norwegian, true, false, true),
    POLISH("pl", Messages.Environment_language_polish, true, true, true),
    PORTUGUESE("pt", Messages.Environment_language_portuguese, false, false, true),
    PSEUDO_TRANSLATION("en_ZZ", Messages.Environment_language_pseudoTranslation, true, false, true, true),
    ROMANIAN("ro", Messages.Environment_language_romanian, false, false, true),
    RUSSIAN("ru", Messages.Environment_language_russian, true, true, true),
    SIMPLIFIED_CHINESE("zh", Messages.Environment_language_simpliedChinese, true, true, true),
    SLOVAK("sk", Messages.Environment_language_slovak, true, false, true),
    SLOVENIAN("sl", Messages.Environment_language_slovenian, true, true, true),
    SPANISH("es", Messages.Environment_language_spanish, true, true, true),
    SWEDISH("sv", Messages.Environment_language_swedish, true, false, true),
    TAGGED_ENGLISH("en_AA", Messages.Environment_language_taggedEnglish, true, false, true, true),
    THAI("th", Messages.Environment_language_thai, true, false, true),
    TRADITIONAL_CHINESE_1("zh_TW", Messages.Environment_language_tranditionalChinese, true, true, true),
    TRADITIONAL_CHINESE_2("zh_HK", Messages.Environment_language_tranditionalChinese, true, true, true),
    TURKISH("tr", Messages.Environment_language_turkish, true, true, true);

    private String id;
    private String label;
    private boolean isCicTranslation;
    private boolean isCicLicenseTextTranslation;
    private boolean isProfileLanguageCode;
    private boolean isInternalLanguageCode;

    private LanguageCode(String id, String label, boolean isCicTranslation, boolean isCicLicenseTextTranslation, boolean isProfileLanguageCode, boolean isInternalLanguageCode) {
        this.id = id;
        this.label = label;
        this.isCicTranslation = isCicTranslation;
        this.isCicLicenseTextTranslation = isCicLicenseTextTranslation;
        this.isProfileLanguageCode = isProfileLanguageCode;
        this.isInternalLanguageCode = isInternalLanguageCode;
    }

    private LanguageCode(String id, String label, boolean isCicTranslation, boolean isCicLicenseTextTranslation, boolean isProfileLanguageCode) {
        this(id, label, isCicTranslation, isCicLicenseTextTranslation, isProfileLanguageCode, false);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isCicTranslation() {
        return this.isCicTranslation;
    }

    public boolean isCicLicenseTextTranslation() {
        return this.isCicLicenseTextTranslation;
    }

    public boolean isProfileLanguageCode() {
        return this.isProfileLanguageCode;
    }

    public boolean isInternalLanguageCode() {
        return this.isInternalLanguageCode;
    }

    public String toString() {
        return String.valueOf(this.getLabel()) + " (" + this.getId() + ')';
    }

    public static LanguageCode value(String id) {
        if (id == null) {
            throw new NullPointerException("null language ID");
        }
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode langCode = languageCodeArray[n2];
            if (langCode.getId().equals(id)) {
                return langCode;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid language ID: " + id);
    }

    public static Set<LanguageCode> getProfileLanguagesSet(boolean includeInternalCodes) {
        LinkedHashSet<LanguageCode> result = new LinkedHashSet<LanguageCode>();
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode code = languageCodeArray[n2];
            if (code.isProfileLanguageCode() && (!code.isInternalLanguageCode() || includeInternalCodes)) {
                result.add(code);
            }
            ++n2;
        }
        return result;
    }

    public static Set<LanguageCode> getCicNlLanguagesSet() {
        LinkedHashSet<LanguageCode> result = new LinkedHashSet<LanguageCode>();
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode code = languageCodeArray[n2];
            if ((code.isCicTranslation() || code.isCicLicenseTextTranslation()) && !code.isInternalLanguageCode()) {
                result.add(code);
            }
            ++n2;
        }
        return result;
    }

    public static Set<LanguageCode> getCicLocaleLanguagesSet(boolean includeInternalCodes) {
        LinkedHashSet<LanguageCode> result = new LinkedHashSet<LanguageCode>();
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode code = languageCodeArray[n2];
            if (code.isCicTranslation() && (!code.isInternalLanguageCode() || includeInternalCodes)) {
                result.add(code);
            }
            ++n2;
        }
        return result;
    }

    public static Set<String> toIds(Set<LanguageCode> codes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(codes.size());
        for (LanguageCode code : codes) {
            result.add(code.getId());
        }
        return result;
    }

    public static String getCicLocaleLanguages(boolean includeInternalIds) {
        Set<LanguageCode> codes = LanguageCode.getCicLocaleLanguagesSet(includeInternalIds);
        return Util.toString(LanguageCode.toIds(codes), ',');
    }

    public static String toString(LanguageCode ... codes) {
        LinkedHashSet<String> locales = new LinkedHashSet<String>(codes.length);
        LanguageCode[] languageCodeArray = codes;
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode code = languageCodeArray[n2];
            locales.add(code.getId());
            ++n2;
        }
        return ProfileLanguageUtils.convertCodeSetToString(locales);
    }

    public static String main(String[] args) {
        boolean includeInternalIds = false;
        if (args.length == 1 && "-internal".equals(args[0])) {
            includeInternalIds = true;
        } else if (args.length != 0) {
            throw new IllegalArgumentException("invalid arguments: " + Arrays.asList(args));
        }
        String result = LanguageCode.getCicLocaleLanguages(includeInternalIds);
        System.out.println(result);
        return result;
    }
}

