/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdParamStr;
import com.ibm.cic.common.core.cmd.CmdParameters;
import com.ibm.cic.common.core.internal.Messages;

public class KeyringCommands {
    public static final CmdCommand CMD_KEYRING = KeyringCommands.createCmdKeyring();
    public static final CmdCommand CMD_PASSWORD = KeyringCommands.createCmdPassword();
    public static final CmdCommand CMD_SECURE_STORAGE_FILE = KeyringCommands.createCmdSecureStorageFile();
    public static final CmdCommand CMD_MASTER_PASSWORD_FILE = KeyringCommands.createCmdMasterPasswordFile();
    public static final CmdCommand CMD_ECLIPSE_PASSWORD = new CmdCommand("-eclipse.password", "");
    public static final CmdCommand CMD_ECLIPSE_KEYRING = new CmdCommand("-eclipse.keyring", "");

    public static void register(ACmdManager cm) {
        cm.registerCommand(CMD_KEYRING);
        cm.registerCommand(CMD_PASSWORD);
        cm.registerCommand(CMD_SECURE_STORAGE_FILE);
        cm.registerCommand(CMD_MASTER_PASSWORD_FILE);
        CMD_PASSWORD.setDefaultRequiredANDRule(CMD_KEYRING);
        CMD_KEYRING.setDefaultIncompatibleRule(CMD_SECURE_STORAGE_FILE);
        CMD_KEYRING.setDefaultIncompatibleRule(CMD_MASTER_PASSWORD_FILE);
        CMD_PASSWORD.setDefaultIncompatibleRule(CMD_SECURE_STORAGE_FILE);
        CMD_PASSWORD.setDefaultIncompatibleRule(CMD_MASTER_PASSWORD_FILE);
        CMD_MASTER_PASSWORD_FILE.setDefaultIncompatibleRule(CMD_KEYRING);
        CMD_MASTER_PASSWORD_FILE.setDefaultIncompatibleRule(CMD_PASSWORD);
        CMD_SECURE_STORAGE_FILE.setDefaultIncompatibleRule(CMD_KEYRING);
        CMD_SECURE_STORAGE_FILE.setDefaultIncompatibleRule(CMD_PASSWORD);
    }

    private static CmdCommand createCmdKeyring() {
        CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_keyring_Param_Id, Messages.Cmd_keyring_Param_Header));
        CmdCommand cmd = new CmdCommand("-keyring", Messages.Cmd_keyring_Header, prms);
        cmd.setUseExample(Messages.Cmd_keyring_Examples);
        cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
        cmd.setLevel(64);
        return cmd;
    }

    private static CmdCommand createCmdPassword() {
        CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_password_Param_Id, Messages.Cmd_password_Param_Header));
        CmdCommand cmd = new CmdCommand("-password", Messages.Cmd_password_Header, prms);
        cmd.setUseExample(Messages.Cmd_password_Examples);
        cmd.setLevel(64);
        cmd.setCommandRank(CmdCommand.CommandRank.REGULAR);
        return cmd;
    }

    private static CmdCommand createCmdSecureStorageFile() {
        CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_eclipse_keyring_Param_Id, Messages.Cmd_eclipse_keyring_Param_Header));
        CmdCommand cmd = new CmdCommand("-secureStorageFile", Messages.Cmd_eclipse_keyring_Header, prms);
        cmd.addDefaultAlias();
        cmd.setUseExample(Messages.Cmd_eclipse_keyring_Examples);
        cmd.setCommandRank(CmdCommand.CommandRank.BOTH);
        cmd.setLevel(1);
        return cmd;
    }

    private static CmdCommand createCmdMasterPasswordFile() {
        CmdParameters prms = new CmdParameters(new CmdParamStr(Messages.Cmd_eclipse_password_Param_Id, Messages.Cmd_eclipse_password_Param_Header));
        CmdCommand cmd = new CmdCommand("-masterPasswordFile", Messages.Cmd_eclipse_password_Header, prms);
        cmd.addDefaultAlias();
        cmd.setUseExample(Messages.Cmd_eclipse_password_Examples);
        cmd.setCommandRank(CmdCommand.CommandRank.BOTH);
        cmd.setLevel(1);
        return cmd;
    }
}

