/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

public class CmdIterator {
    private final String[] m_args;
    private int m_currentIndex = 0;

    public CmdIterator(String[] a_args) {
        this.m_args = a_args;
    }

    public boolean hasMoreArgs() {
        return this.m_currentIndex < this.m_args.length;
    }

    String getNextArg() {
        return this.hasMoreArgs() ? this.m_args[this.m_currentIndex + 1] : null;
    }

    public String getCurrentArg() {
        return this.m_args[this.m_currentIndex];
    }

    public void consumeCurrentArg() {
        ++this.m_currentIndex;
    }

    void resetIterator() {
        this.m_currentIndex = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = this.m_currentIndex;
        while (i < this.m_args.length) {
            if (i - this.m_currentIndex > 3) {
                sb.append(" ...");
                break;
            }
            if (i > this.m_currentIndex) {
                sb.append(' ');
            }
            sb.append(this.m_args[i]);
            ++i;
        }
        return sb.toString();
    }
}

