/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdBase;
import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.cmd.CmdLink;
import com.ibm.cic.common.core.cmd.CmdParameters;
import com.ibm.cic.common.core.cmd.ICmdLink;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdCommand
extends ACmdBase {
    private static final CmdParameters NO_PARAMS = new CmdParameters(null, 0, 0){

        @Override
        String getHeaderInfo() {
            return "";
        }
    };
    private List<String> aliases = new ArrayList<String>();
    private final CmdParameters m_parameters;
    private final List<ICmdLink> m_allRequiredAND = new ArrayList<ICmdLink>(0);
    private final List<ICmdLink> m_allRequiredOR = new ArrayList<ICmdLink>(0);
    private final List<ICmdLink> m_allIncompatible = new ArrayList<ICmdLink>(0);
    private CommandRank cmdRank = CommandRank.MAIN;
    private boolean m_techPreview = false;

    public CmdCommand(String commandId, String header) {
        this(commandId, header, NO_PARAMS);
    }

    public CmdCommand(String commandId, String header, CmdParameters parameters) {
        super(commandId, header);
        this.m_parameters = parameters;
    }

    CmdCommand(CmdCommand original) {
        this(original.id(), original.getHeader(), new CmdParameters(original.m_parameters));
        this.aliases = new ArrayList<String>(original.aliases);
        this.m_allRequiredAND.addAll(original.m_allRequiredAND);
        this.m_allRequiredOR.addAll(original.m_allRequiredOR);
        this.m_allIncompatible.addAll(original.m_allIncompatible);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.m_parameters.hashCode();
    }

    public void addDefaultAlias() {
        String id = this.id();
        if (id.startsWith("-")) {
            this.addAlias(id.replaceAll("([a-zA-Z])[a-z]*", "$1"));
        } else {
            this.addAlias(String.valueOf('-') + id);
        }
    }

    public void addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>(2);
        }
        this.aliases.add(alias);
    }

    List<String> getCommandIds() {
        if (this.aliases.isEmpty()) {
            return Collections.singletonList(this.id());
        }
        ArrayList<String> result = new ArrayList<String>(1 + this.aliases.size());
        result.add(this.id());
        result.addAll(this.aliases);
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_parameters.reset();
    }

    String getSummary() {
        String result = Util.toString(this.getCommandIds(), new Util.Formatter(", "));
        if (this.m_parameters != NO_PARAMS) {
            result = String.valueOf(result) + "  " + this.m_parameters.getId();
        }
        return result;
    }

    String getCommandId() {
        return super.id();
    }

    public String getParamStrVal(int i) {
        return this.m_parameters.getParamStrVal(i);
    }

    Object getParamObjVal(int i) {
        return this.m_parameters.getParamObjVal(i);
    }

    boolean setParamVal(int i, String a_val) {
        return this.m_parameters.setParamVal(i, a_val);
    }

    public String findCommand(String candidate) {
        for (String id : this.getCommandIds()) {
            if (!candidate.equalsIgnoreCase(id)) continue;
            return id;
        }
        return null;
    }

    @Override
    public IStatus loadCommandLineData(ACmdManager cm, CmdIterator cmdData) {
        String arg;
        String cmdId;
        IStatus return_value = Status.OK_STATUS;
        if (cmdData.hasMoreArgs() && (cmdId = this.findCommand(arg = cmdData.getCurrentArg())) != null) {
            this.setStrValue(cmdId);
            cmdData.consumeCurrentArg();
            return_value = this.m_parameters.loadCommandLineData(cm, cmdData);
            if (!return_value.isOK()) {
                return_value = Statuses.ST.createStatus(return_value, Messages.Cmd_Error_Command_Incorrect_Use, this.getStrVal(), return_value.getMessage());
            }
        }
        return return_value;
    }

    boolean checkToolConsistency() {
        if (!this.m_allRequiredAND.isEmpty()) {
            for (ICmdLink link : this.m_allRequiredAND) {
                if (link.getParent().id() != "-toolId") continue;
                return link.isValidLink();
            }
        }
        return true;
    }

    public void setRequiredANDRule(CmdCommand cmd) {
        this.m_allRequiredAND.addAll(cmd.m_allRequiredAND);
    }

    public void setRequiredANDRule(ICmdLink a_link) {
        this.m_allRequiredAND.add(a_link);
    }

    public void setDefaultRequiredANDRule(CmdCommand cmd) {
        if (!CmdCommand.isParent(cmd, this.m_allRequiredAND)) {
            this.m_allRequiredAND.add(new CmdLink(cmd));
        }
    }

    public void setDefaultRequiredORRule(CmdCommand cmd) {
        if (!CmdCommand.isParent(cmd, this.m_allRequiredOR)) {
            this.m_allRequiredOR.add(new CmdLink(cmd));
        }
    }

    public void setRequiredORRule(ICmdLink a_link) {
        this.m_allRequiredOR.add(a_link);
    }

    public void setIncompatibleRule(ICmdLink a_link) {
        if (this.m_allIncompatible.contains(a_link)) {
            return;
        }
        this.m_allIncompatible.add(a_link);
        a_link.getParent().setIncompatibleRule(new CmdLink(this));
    }

    public void setDefaultIncompatibleRules(CmdCommand ... commands) {
        CmdCommand[] cmdCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            CmdCommand cmd = cmdCommandArray[n2];
            this.setDefaultIncompatibleRule(cmd);
            ++n2;
        }
    }

    public void setDefaultIncompatibleRule(CmdCommand cmd) {
        if (!CmdCommand.isParent(cmd, this.m_allIncompatible)) {
            this.m_allIncompatible.add(new CmdLink(cmd));
            cmd.setIncompatibleRule(new CmdLink(this));
        }
    }

    public String toString() {
        return this.getSummary();
    }

    public List<ICmdLink> getRequiredParents() {
        return this.m_allRequiredAND;
    }

    public List<ICmdLink> getOptionalParents() {
        return this.m_allRequiredOR;
    }

    boolean requires(CmdCommand cmd) {
        return CmdCommand.isParent(cmd, this.m_allRequiredOR) || CmdCommand.isParent(cmd, this.m_allRequiredAND);
    }

    public List<ICmdLink> getIncompatibleCommands() {
        return this.m_allIncompatible;
    }

    CmdParameters getParameters() {
        return this.m_parameters;
    }

    public void setCommandRank(CommandRank newCmdRank) {
        this.cmdRank = newCmdRank;
    }

    public CommandRank getCommandRank() {
        return this.cmdRank;
    }

    public boolean isRegular() {
        return this.cmdRank.equals((Object)CommandRank.REGULAR) || this.cmdRank.equals((Object)CommandRank.BOTH);
    }

    public boolean isMain() {
        return this.cmdRank.equals((Object)CommandRank.MAIN) || this.cmdRank.equals((Object)CommandRank.BOTH);
    }

    private static boolean isParent(CmdCommand cmd, List<ICmdLink> links) {
        for (ICmdLink link : links) {
            if (link.getParent() != cmd) continue;
            return true;
        }
        return false;
    }

    public void setTechPreview(boolean techPreview) {
        this.m_techPreview = techPreview;
    }

    public boolean isTechPreview() {
        return this.m_techPreview;
    }

    public static enum CommandRank {
        MAIN,
        REGULAR,
        BOTH;

    }
}

