/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.impl.DiskSet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.IRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DiskUtil {
    private DiskUtil() {
    }

    public static IVolumeAccessByDisk.IDiskSet[] getDiskSetsWithCount(IVolumeAccessByDisk aod, IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        final HashSet disks = new HashSet();
        IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback = new IVolumeAccessByDisk.IArtifactOnDiskCallback(){

            @Override
            public void notOnAnyDisk(IArtifact artifact) {
            }

            @Override
            public void onDisk(IArtifact artifact, IVolumeAccessByDisk.IDisk disk) {
                disks.add(disk);
            }
        };
        aod.visitArtifactsOnDisk(session, null, null, aodCallback, monitor);
        HashSet<IVolumeAccessByDisk.IDiskSet> diskSets = new HashSet<IVolumeAccessByDisk.IDiskSet>(disks.size());
        for (IVolumeAccessByDisk.IDisk disk : disks) {
            diskSets.add(disk.getDiskSet());
        }
        ArrayList<DiskSet> diskSetsWithCount = new ArrayList<DiskSet>(diskSets.size());
        for (IVolumeAccessByDisk.IDiskSet diskSet : diskSets) {
            int diskNumber = 0;
            for (IVolumeAccessByDisk.IDisk disk : disks) {
                if (!disk.getDiskSet().equals(diskSet) || disk.getDiskNumber() <= diskNumber) continue;
                diskNumber = disk.getDiskNumber();
            }
            diskSetsWithCount.add(new DiskSet(diskSet.getId(), diskSet.getLabel(), diskNumber));
        }
        return diskSetsWithCount.toArray(new IVolumeAccessByDisk.IDiskSet[diskSetsWithCount.size()]);
    }

    public static IVolumeAccessByDisk.IDiskSet getDiskSet(IArtifactSession session, IVolumeAccessByDisk diskRepo, String diskSetId, IProgressMonitor monitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet[] diskSets;
        IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets = diskRepo.getDiskSets(session, monitor);
        int n = diskSets.length;
        int n2 = 0;
        while (n2 < n) {
            IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
            if (diskSet.getId().equals(diskSetId)) {
                return diskSet;
            }
            ++n2;
        }
        return null;
    }

    public static IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IArtifactSession session, IRepository diskRepo, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IVolumeAccessByDisk.IDiskSet[] diskSets;
            IVolumeAccessByDisk volRepo = RepoAs.IVolumeAccessByDisk(diskRepo);
            if (volRepo == null) {
                return null;
            }
            IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets = volRepo.getPackageDiskSets(session, pkg, (IProgressMonitor)sm.newChild(1));
            return iDiskSetArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IVolumeAccessByDisk.IDiskSetDisks[] getPackageAvailableDisks(IArtifactSession session, IRepository diskRepo, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IVolumeAccessByDisk.IDiskSet[] diskSets = DiskUtil.getPackageDiskSets(session, diskRepo, pkg, (IProgressMonitor)sm.newChild(1));
            if (diskSets == null) {
                return null;
            }
            IVolumeAccessByDisk volRepo = RepoAs.IVolumeAccessByDisk(diskRepo);
            ArrayList<IVolumeAccessByDisk.IDiskSetDisks> list = new ArrayList<IVolumeAccessByDisk.IDiskSetDisks>(diskSets.length);
            IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets;
            int n = diskSets.length;
            int n2 = 0;
            while (n2 < n) {
                IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
                IVolumeAccessByDisk.IDiskSetDisks availableDisks = DiskUtil.getAvailableDisks(session, volRepo, diskSet, (IProgressMonitor)sm.newChild(1));
                assert (availableDisks != null);
                list.add(availableDisks);
                ++n2;
            }
            IVolumeAccessByDisk.IDiskSetDisks[] iDiskSetDisksArray = list.toArray(new IVolumeAccessByDisk.IDiskSetDisks[list.size()]);
            return iDiskSetDisksArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IVolumeAccessByDisk.IDiskSetDisks getAvailableDisks(IArtifactSession session, IVolumeAccessByDisk diskRepo, IVolumeAccessByDisk.IDiskSet diskSet, IProgressMonitor monitor) throws CoreException, IOException {
        ArrayList<Integer> diskIndexes = new ArrayList<Integer>(diskSet.getDiskCount());
        int i = 0;
        while (i < diskSet.getDiskCount()) {
            IVolumeAccessByDisk.IDiskSetDisks disks = diskSet.useDisks(new int[]{i});
            if (diskRepo.disksAvailable(session, disks, monitor)) {
                diskIndexes.add(i);
            }
            ++i;
        }
        Integer[] arrDiskIndexAvailable = diskIndexes.toArray(new Integer[diskIndexes.size()]);
        IVolumeAccessByDisk.IDiskSetDisks availableDisks = diskSet.useDisks(arrDiskIndexAvailable);
        return availableDisks;
    }

    public static int indexOfPseudoDisksSets(IVolumeAccessByDisk.IDiskSet[] diskSets) {
        int i = 0;
        while (i < diskSets.length) {
            IVolumeAccessByDisk.IDiskSet diskSet = diskSets[i];
            if (MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET.equals(diskSet)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static IVolumeAccessByDisk.IDiskSet[] filterPseudoDisksSets(IVolumeAccessByDisk.IDiskSet[] diskSets) {
        int i = DiskUtil.indexOfPseudoDisksSets(diskSets);
        if (i == -1) {
            return diskSets;
        }
        IVolumeAccessByDisk.IDiskSet[] r = new IVolumeAccessByDisk.IDiskSet[diskSets.length - 1];
        int d = 0;
        int j = 0;
        while (j < diskSets.length) {
            if (j == i) {
                d = 1;
            } else {
                r[j - d] = diskSets[j];
            }
            ++j;
        }
        return r;
    }

    public static IVolumeAccessByDisk.IDiskSet[] getOtherDisksSets(IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk.IDiskSet[] diskSets) {
        HashSet<IVolumeAccessByDisk.IDiskSet> setSelected = new HashSet<IVolumeAccessByDisk.IDiskSet>(Arrays.asList(diskSets));
        LinkedHashSet<IVolumeAccessByDisk.IDiskSet> other = new LinkedHashSet<IVolumeAccessByDisk.IDiskSet>(allDiskSets.length);
        IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = allDiskSets;
        int n = allDiskSets.length;
        int n2 = 0;
        while (n2 < n) {
            IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
            if (!setSelected.contains(diskSet)) {
                other.add(diskSet);
            }
            ++n2;
        }
        return other.toArray(new IVolumeAccessByDisk.IDiskSet[other.size()]);
    }

    public static boolean canFindAvailableDisks(List<IOfferingOrFix> packages) {
        for (IOfferingOrFix pkg : packages) {
            IRepository repo = pkg.getRepository();
            IVolumeAccessByDisk diskRepo = RepoAs.IVolumeAccessByDisk(repo);
            if (diskRepo == null || !diskRepo.canFindAvailableDisks()) continue;
            return true;
        }
        return false;
    }

    public static boolean canFindAvailableDisksForRepositories(Collection<IRepository> repositories) {
        for (IRepository repo : repositories) {
            IVolumeAccessByDisk diskRepo = RepoAs.IVolumeAccessByDisk(repo);
            if (diskRepo == null || !diskRepo.canFindAvailableDisks()) continue;
            return true;
        }
        return false;
    }

    public static IVolumeAccessByDisk.IDiskSetDisks getUnavailableNeededDisks(IArtifactSession session, IVolumeAccessByDisk diskRepo, IVolumeAccessByDisk.IDiskSetDisks neededDisks, IProgressMonitor monitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet diskSet = neededDisks.getDiskSet();
        IVolumeAccessByDisk.IDiskSetDisks availableDisks = DiskUtil.getAvailableDisks(session, diskRepo, diskSet, monitor);
        ArrayList<IVolumeAccessByDisk.IDisk> unavailableUsedDisks = new ArrayList<IVolumeAccessByDisk.IDisk>(neededDisks.getDisks().size());
        for (IVolumeAccessByDisk.IDisk usedDisk : neededDisks.getDisks()) {
            if (availableDisks.getDisks().contains(usedDisk)) continue;
            unavailableUsedDisks.add(usedDisk);
        }
        return diskSet.useDisks(unavailableUsedDisks);
    }

    public static String getDiskSetLabelOrId(IVolumeAccessByDisk.IDiskSet diskSet) {
        String labelOrId = diskSet.getLabel();
        if (labelOrId == null) {
            labelOrId = diskSet.getId();
        }
        return labelOrId;
    }

    public static String formatDiskNumbers(IVolumeAccessByDisk.IDiskSetDisks dsd) {
        List<IVolumeAccessByDisk.IDisk> disks = dsd.getDisks();
        return DiskUtil.formatDiskNumbers(disks);
    }

    private static String formatDiskNumbers(List<IVolumeAccessByDisk.IDisk> disks) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (IVolumeAccessByDisk.IDisk disk : disks) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(disk.getDiskNumber());
        }
        return sb.toString();
    }

    public static class Disk
    implements IVolumeAccessByDisk.IDisk {
        private final IVolumeAccessByDisk.IDiskSet diskSet;
        private final int diskNumber;

        public Disk(IVolumeAccessByDisk.IDiskSet diskSet, int diskNumber) {
            assert (diskNumber >= 1);
            this.diskSet = diskSet;
            this.diskNumber = diskNumber;
        }

        @Override
        public IVolumeAccessByDisk.IDiskSet getDiskSet() {
            return this.diskSet;
        }

        @Override
        public int getDiskNumber() {
            return this.diskNumber;
        }

        @Override
        public int getDiskIndex() {
            return this.diskNumber - 1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IVolumeAccessByDisk.IDisk) {
                IVolumeAccessByDisk.IDisk otherDisk = (IVolumeAccessByDisk.IDisk)o;
                return otherDisk.getDiskSet().equals(this.diskSet) && otherDisk.getDiskNumber() == this.diskNumber;
            }
            return false;
        }

        public int hashCode() {
            return this.diskSet.hashCode() * 7 + this.diskNumber;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("disk ");
            sb.append(this.diskNumber);
            sb.append(" on ");
            sb.append(this.diskSet);
            return sb.toString();
        }
    }
}

