/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.downloads.SizeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactsOnDisksInfo {
    private final Map<IVolumeAccessByDisk.IDisk, ArtifactsOnDiskInfo> disksUsed = new LinkedHashMap<IVolumeAccessByDisk.IDisk, ArtifactsOnDiskInfo>();
    private Map<IVolumeAccessByDisk.IDiskSet, IVolumeAccessByDisk.IDiskSetDisks> diskSetDisksUsed = null;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("disksUsed:");
        sb.append(this.disksUsed);
        return sb.toString();
    }

    void clear() {
        this.disksUsed.clear();
        this.diskSetDisksUsed = null;
    }

    public void putArtifactsOnDisk(IVolumeAccessByDisk.IDisk disk, ArtifactsOnDiskInfo aod) {
        this.disksUsed.put(disk, aod);
        this.diskSetDisksUsed = null;
    }

    List<IVolumeAccessByDisk.IDisk> getUsedDisks() {
        return Collections.unmodifiableList(new ArrayList<IVolumeAccessByDisk.IDisk>(this.disksUsed.keySet()));
    }

    private Map<IVolumeAccessByDisk.IDiskSet, IVolumeAccessByDisk.IDiskSetDisks> getDiskSetDisksMap() {
        if (this.diskSetDisksUsed == null) {
            this.diskSetDisksUsed = new LinkedHashMap<IVolumeAccessByDisk.IDiskSet, IVolumeAccessByDisk.IDiskSetDisks>(this.disksUsed.size());
            for (IVolumeAccessByDisk.IDisk disk : this.disksUsed.keySet()) {
                IVolumeAccessByDisk.IDiskSetDisks disks = this.diskSetDisksUsed.get(disk.getDiskSet());
                if (disks == null) {
                    disks = disk.getDiskSet().useDisks();
                    this.diskSetDisksUsed.put(disk.getDiskSet(), disks);
                }
                disks.addDisk(disk);
            }
        }
        return this.diskSetDisksUsed;
    }

    public Set<IVolumeAccessByDisk.IDiskSet> getUsedDiskSets() {
        return Collections.unmodifiableSet(this.getDiskSetDisksMap().keySet());
    }

    public IVolumeAccessByDisk.IDiskSetDisks getDiskSetDisksUsed(IVolumeAccessByDisk.IDiskSet diskSet) {
        return this.getDiskSetDisksMap().get(diskSet);
    }

    ArtifactsOnDiskInfo getArtifactsOnDisk(IVolumeAccessByDisk.IDisk disk) {
        return this.disksUsed.get(disk);
    }

    private boolean isOnDisk(IVolumeAccessByDisk.IDisk disk, IArtifact artifact) {
        ArtifactsOnDiskInfo aod = this.getArtifactsOnDisk(disk);
        if (aod == null) {
            return false;
        }
        return aod.containsArtifact(artifact);
    }

    boolean isOnDiskSet(IVolumeAccessByDisk.IDiskSet diskSet, IArtifact artifact) {
        IVolumeAccessByDisk.IDiskSetDisks dsds = this.getDiskSetDisksUsed(diskSet);
        if (dsds != null) {
            for (IVolumeAccessByDisk.IDisk disk : dsds.getDisks()) {
                if (!this.isOnDisk(disk, artifact)) continue;
                return true;
            }
        }
        return false;
    }

    public SizeInfo getDiskSetArtifactsSize(IVolumeAccessByDisk.IDiskSet diskSet) {
        SizeInfo total = new SizeInfo(0L, 0L);
        IVolumeAccessByDisk.IDiskSetDisks disks = this.getDiskSetDisksUsed(diskSet);
        for (IVolumeAccessByDisk.IDisk disk : disks.getDisks()) {
            for (IArtifact artifact : this.getArtifactsOnDisk(disk).getArtifacts()) {
                total.add(artifact.getContentInfo().getSizeInfo());
            }
        }
        return total;
    }

    public static class ArtifactsOnDiskInfo {
        private final IVolumeAccessByDisk.IDisk disk;
        private final Set<IArtifact> artifacts;

        public ArtifactsOnDiskInfo(IVolumeAccessByDisk.IDisk disk, int capacity) {
            this.disk = disk;
            this.artifacts = new LinkedHashSet<IArtifact>(capacity);
        }

        public void addArtifact(IArtifact artifact) {
            this.artifacts.add(artifact);
        }

        public Set<IArtifact> getArtifacts() {
            return Collections.unmodifiableSet(this.artifacts);
        }

        private boolean containsArtifact(IArtifact artifact) {
            return this.artifacts.contains(artifact);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" disk");
            sb.append(this.disk);
            sb.append(" artifacts=");
            sb.append(this.artifacts.size());
            return sb.toString();
        }
    }
}

