/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocModel;
import com.ibm.cic.common.core.artifactrepo.impl.AtocVersionInfo;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.utils.AdvisoryLockedFile;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.ContentInfoUtil;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IMessageDigests;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class ArtifactTocWriter
implements ArtifactTableOfContents.XMLConstants,
AtocVersionInfo {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();
    private static final XMLWriter.ProcessingInstruction atocPI_Version1 = new XMLWriter.ProcessingInstruction("atoc", "version='0.0.1'");
    private static final XMLWriter.ProcessingInstruction atocPI_Version2 = new XMLWriter.ProcessingInstruction("atoc", "version='0.0.2'");
    private final boolean singleQuote;
    private final PrintWriter writer;
    private final ArtifactTableOfContents.Parameters params;

    private ArtifactTocWriter(boolean singleQuote, ArtifactTableOfContents.Parameters params, PrintWriter writer) {
        this.singleQuote = singleQuote;
        this.params = params;
        this.writer = writer;
    }

    public static void writeContainedSetFile(ArtifactTableOfContents.Parameters params, AdvisoryLockedFile lockedFile, ArtifactTocModel.ContainedSet cs) throws IOException {
        trace.entering(lockedFile.getLocation());
        OutputStream os = null;
        try {
            lockedFile.seek(0L);
            SimpleContentInfo sci = null;
            if (params.supportDigests()) {
                String algorithm = ContentInfoComputation.getPreferredAlgorithms()[0];
                sci = new SimpleContentInfo();
                os = new ContentInfoComputation.ComputeContentInfoOutputStream(Collections.singletonList(algorithm), sci, lockedFile.getOutputStream());
            } else {
                os = lockedFile.getOutputStream();
            }
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (!UserOptions.maintainAtocCompatibility()) {
                writer.print(atocPI_Version1.toString());
            }
            ArtifactTocWriter atw = new ArtifactTocWriter(false, params, writer);
            atw.printContainedSet(cs);
            writer.flush();
            lockedFile.setLength(lockedFile.getFilePointer());
            FileUtil.fdSync(lockedFile.getFD());
            if (params.supportDigests()) {
                cs.setContentInfo(sci);
            }
            trace.exiting();
        }
        finally {
            if (os != null) {
                os.close();
            }
            lockedFile.close();
        }
    }

    public static void writeTocFile_version1(ArtifactTableOfContents.Parameters params, AdvisoryLockedFile lockedFile, ArtifactTableOfContents.TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException {
        trace.entering(lockedFile.getLocation());
        try {
            lockedFile.seek(0L);
            FileOutputStream os = lockedFile.getOutputStream();
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (!UserOptions.maintainAtocCompatibility()) {
                writer.println(atocPI_Version1.toString());
            }
            ArtifactTocModel.Toc toc = tocUpdate.getTocHolder().getToc();
            writer.print("<atoc");
            if (toc.getETag() != null) {
                ArtifactTocWriter.printAttr(writer, "etag", toc.getETag());
            }
            writer.print(">");
            ArtifactTocWriter atw = new ArtifactTocWriter(false, params, writer);
            atw.printSummary(toc.getSummary());
            if (ArtifactTocWriter.trace.traceEntering) {
                trace.println(".. written toc summary count = {0}", Integer.toString(toc.getSummary().getCount()));
            }
            for (ArtifactTocModel.AbstractContainedSet element : toc.getContents()) {
                ArtifactTocModel.ContainedSet cs = (ArtifactTocModel.ContainedSet)element;
                atw.printContainedSet(cs);
            }
            writer.print("</atoc>");
            writer.flush();
            lockedFile.setLength(lockedFile.getFilePointer());
            FileUtil.fdSync(lockedFile.getFD());
            ((OutputStream)os).close();
            trace.exiting();
        }
        finally {
            lockedFile.close();
        }
    }

    public static void writeTocFile_version2(ArtifactTableOfContents.Parameters params, AdvisoryLockedFile lockedFile, ArtifactTableOfContents.TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException {
        trace.entering(lockedFile.getLocation());
        try {
            lockedFile.seek(0L);
            SimpleContentInfo digests = new SimpleContentInfo();
            String algorithm = ContentInfoComputation.getPreferredAlgorithms()[0];
            ContentInfoComputation.ComputeContentInfoOutputStream os = new ContentInfoComputation.ComputeContentInfoOutputStream(Collections.singletonList(algorithm), digests, lockedFile.getOutputStream());
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8")));
            writer.println("<?xml version='1.0' encoding='UTF-8'?>");
            writer.println(atocPI_Version2.toString());
            ArtifactTocModel.Toc toc = tocUpdate.getTocHolder().getToc();
            writer.print("<atoc");
            if (toc.getETag() != null) {
                ArtifactTocWriter.printAttrSingleQuote(writer, "etag", toc.getETag());
            }
            writer.print(">");
            ArtifactTocWriter atw = new ArtifactTocWriter(true, params, writer);
            atw.printSummary(toc.getSummary());
            if (ArtifactTocWriter.trace.traceEntering) {
                trace.println(".. written toc summary count = {0}", Integer.toString(toc.getSummary().getCount()));
            }
            for (ArtifactTocModel.AbstractContainedSet element : toc.getContents()) {
                ArtifactTocModel.ContainedSet cs = (ArtifactTocModel.ContainedSet)element;
                atw.printContainedSet(cs);
            }
            writer.print("</atoc>");
            writer.flush();
            lockedFile.setLength(lockedFile.getFilePointer());
            FileUtil.fdSync(lockedFile.getFD());
            ((OutputStream)os).close();
            tocUpdate.onSaved(digests, monitor);
            trace.exiting();
        }
        finally {
            lockedFile.close();
        }
    }

    private void printContainedSet(ArtifactTocModel.ContainedSet cs) {
        this.writer.println();
        this.writer.print("<cset");
        this.printAttr(cs.getAttrName(), cs.getAttrValue());
        if (cs.getETag() != null) {
            this.printAttr("etag", cs.getETag());
        }
        this.writer.print('>');
        this.printSummary(cs.getSummary());
        for (Object contained : cs.getContained()) {
            if (contained instanceof ArtifactTocModel.ContainedSet) {
                ArtifactTocModel.ContainedSet csContained = (ArtifactTocModel.ContainedSet)contained;
                this.printContainedSet(csContained);
                continue;
            }
            if (contained instanceof ArtifactTocModel.ContainedSetReference) {
                ArtifactTocModel.ContainedSetReference csrContained = (ArtifactTocModel.ContainedSetReference)contained;
                this.printContainedSetRef(csrContained);
                continue;
            }
            if (!(contained instanceof ArtifactTocModel.Artifact)) continue;
            ArtifactTocModel.Artifact artifact = (ArtifactTocModel.Artifact)contained;
            this.printArtifact(artifact);
        }
        this.writer.println();
        this.writer.print("</cset>");
    }

    private void printContainedSetRef(ArtifactTocModel.ContainedSetReference csr) {
        this.writer.println();
        this.writer.print("<cset");
        this.printAttr(csr.getAttrName(), csr.getAttrValue());
        if (csr.getETag() != null) {
            this.printAttr("etag", csr.getETag());
        }
        this.printAttr("href", csr.getHREF());
        if (this.params.supportDigests() && csr.getContentInfo() != null) {
            StringBuffer sb = new StringBuffer();
            IContentInfo contentInfo = csr.getContentInfo();
            long downloadSize = contentInfo.getSizeInfo().getDownloadSize();
            if (downloadSize != Long.MIN_VALUE) {
                sb.append(" size='");
                sb.append(downloadSize);
                sb.append("'");
            }
            ContentInfoUtil.appendMessageDigestsXML(sb, (IMessageDigests)csr.getContentInfo());
            this.writer.print(sb);
        }
        this.writer.print('>');
        this.printSummary(csr.getSummary());
        this.writer.println();
        this.writer.print("</cset>");
    }

    private void printSummary(IReadArtifactRepo.ISummary summary) {
        if (this.params.useSummary()) {
            this.writer.println();
            this.writer.print("<summary");
            this.writer.print(' ');
            this.printAttr("count", Integer.toString(summary.getCount()));
            if (summary.getTotalSize() > 0L) {
                this.printAttr("totalSize", Long.toString(summary.getTotalSize()));
            }
            List digests = summary.getAvailableDigests();
            this.writer.print('>');
            int i = 0;
            while (i < digests.size()) {
                String digest = (String)digests.get(i);
                this.printDigestSummary(digest, summary.getAvailableDigestsCount(digest));
                ++i;
            }
            this.writer.println();
            this.writer.print("</summary>");
        }
    }

    private void printDigestSummary(String algorithm, int count) {
        this.writer.println();
        this.writer.print("<digs");
        this.printAttr("da", algorithm.toUpperCase());
        this.printAttr("count", Integer.toString(count));
        this.writer.print("/>");
    }

    private void printArtifact(ArtifactTocModel.Artifact artifact) {
        this.writer.println();
        this.writer.print("<af");
        this.printAttr("id", artifact.getIdString());
        this.printAttr("v", artifact.getVersionString());
        this.printAttr("p", artifact.getPath().toString());
        if (!UserOptions.maintainAtocCompatibility()) {
            this.printAttr("ex", Boolean.toString(artifact.isExploded()));
        }
        this.params.printExtraArtifactAttr(this.writer, this.singleQuote, artifact);
        IContentInfo ci = artifact.getContentInfo();
        if (ci.getSizeInfo().getDownloadSize() != Long.MIN_VALUE) {
            this.printAttr("sz", Long.toString(ci.getSizeInfo().getDownloadSize()));
        }
        if (ci.getAvailableDigestsCount() == 0) {
            this.params.printExtraArtifactContent(this.writer, artifact);
            this.writer.print("/>");
        } else {
            this.writer.print(">");
            Iterator<DigestValue> iterator = ci.getDigests().iterator();
            while (iterator.hasNext()) {
                DigestValue element;
                DigestValue dv = element = iterator.next();
                this.printDigest(dv.getAlgorithm().toUpperCase(), dv.getDigestAsString());
            }
            this.writer.println();
            this.params.printExtraArtifactContent(this.writer, artifact);
            this.writer.print("</af>");
        }
    }

    private void printDigest(String algorithm, String value) {
        this.writer.println();
        this.writer.print("<dig");
        this.printAttr("da", algorithm);
        this.printAttr("dv", value);
        this.writer.println("/>");
    }

    private void printAttr(String name, String value) {
        ArtifactTocWriter.printAttr(this.writer, this.singleQuote, name, value);
    }

    static void printAttr(PrintWriter writer, boolean singleQuote, String name, String value) {
        if (singleQuote) {
            ArtifactTocWriter.printAttrSingleQuote(writer, name, value);
        } else {
            ArtifactTocWriter.printAttr(writer, name, value);
        }
    }

    private static void printAttr(PrintWriter writer, String name, String value) {
        writer.print(' ');
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.print("\" ");
    }

    private static void printAttrSingleQuote(PrintWriter writer, String name, String value) {
        writer.print(' ');
        writer.print(name);
        writer.print("='");
        writer.print(value);
        writer.print("' ");
    }

    static class ContainedSetFile
    extends AdvisoryLockedFile {
        private ContainedSetFile(File file, boolean forReadingOnly) throws IOException {
            super(file, forReadingOnly, UserOptions.CIC_REPO_LOCKING.isSet());
        }

        public static ContainedSetFile create(IPath base, String href, boolean forReadingOnly) throws IOException {
            File parent;
            File file = base.append(href).toFile();
            if (!(forReadingOnly || (parent = file.getParentFile()).exists() || parent.mkdirs())) {
                throw new IOException("Failed to mkdirs directory:" + parent.toString());
            }
            ContainedSetFile csFile = new ContainedSetFile(file, forReadingOnly);
            return (ContainedSetFile)ContainedSetFile.lockCloseIfFails(csFile);
        }
    }
}

