/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ElementHolder;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.AbstractArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.utils.IndentWriter;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class ArtifactTocModel {

    static abstract class AbstractContainedSet
    implements ElementHolder.IElementHasContainer,
    IReadArtifactRepo.ICategory {
        private String etag;
        private IContentInfo contentInfo;
        private Summary summary = Summary.access$1();
        private Object container;
        private String attrName;
        private String attrValue = "ATTR_VALUE_NULL";
        private static final String ATTR_VALUE_NULL = "ATTR_VALUE_NULL";

        AbstractContainedSet() {
        }

        public static AbstractContainedSet as(Object obj) {
            if (obj instanceof AbstractContainedSet) {
                return (AbstractContainedSet)obj;
            }
            return null;
        }

        void initContainer(Object obj) {
            this.container = obj;
        }

        @Override
        public Object releaseContainer() {
            Object obj = this.container;
            this.container = null;
            return obj;
        }

        @Override
        public Object getContainerObject() {
            return this.container;
        }

        public String getETag() {
            return this.etag;
        }

        public void setETag(String etag) {
            this.etag = etag;
        }

        public IContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public void setContentInfo(IContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Override
        public IReadArtifactRepo.ISummary getSummary() {
            return this.summary;
        }

        public Summary getMutableSummary() {
            return this.summary;
        }

        public void setSummary(Summary summary) {
            this.summary = summary;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public String getAttrValue() {
            return this.attrValue;
        }

        public void setAttr(String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        private void addAttributes(Map<String, String> attrs) {
            AbstractContainedSet c = AbstractContainedSet.as(ElementHolder.getContainer(this.container, true, true));
            if (c != null) {
                c.addAttributes(attrs);
            }
            attrs.put(this.attrName, this.attrValue);
        }

        public Map<String, String> getAttributes() {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            this.addAttributes(attrs);
            return attrs;
        }

        public abstract boolean accept(Visitor var1);

        @Override
        public String toUserString() {
            return NLS.bind((String)Messages.category_user_string, (Object)this.attrName, (Object)this.attrValue);
        }

        public abstract void dump(IndentWriter var1, boolean var2);

        private String dumpToString() {
            StringWriter sw = new StringWriter();
            IndentWriter iw = new IndentWriter(new PrintWriter(sw));
            this.dump(iw, false);
            return sw.toString();
        }

        public String toString() {
            return this.dumpToString();
        }
    }

    public static class Artifact
    extends AbstractArtifact
    implements ElementHolder.IElementHasContainer {
        private ContainedSet container;
        private String idString = "INHERIT_STRING";
        private Version version = INHERIT_VERSION;
        private IPath path = UNKNOWN_PATH;
        private Object extraInfo;
        private static final String INHERIT_STRING = "INHERIT_STRING";
        private static final Version INHERIT_VERSION = new Version("1.0");
        private static final IPath UNKNOWN_PATH = new Path("UNKNOWN_PATH");

        private IArtifactKey toArtifactKey() {
            return new ArtifactKey(this.getPath(), this.getNamespace(), this.getQualifier(), new SimpleIdentity(this.getIdString()), this.getVersion());
        }

        public boolean equalsIdVersionPath(IArtifactKey key) {
            return this.getIdString().equals(key.getId().getId()) && this.getVersion().equals((Object)key.getVersion()) && this.getPath().equals((Object)key.getPath());
        }

        private void dump(IndentWriter iw) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print("key=");
                pw.print(this.getKey().toString());
                IContentInfo ci = this.getContentInfo();
                pw.print(" sizeInfo=");
                pw.print(ci.getSizeInfo().toString());
                if (ci.getAvailableDigestsCount() > 0) {
                    List<DigestValue> digests = ci.getDigests();
                    for (DigestValue dv : digests) {
                        pw.print(" ");
                        pw.print(dv.getAlgorithm());
                        pw.print("=");
                        pw.print(dv.getDigestAsString());
                    }
                }
            }
            finally {
                iw.leave();
            }
        }

        @Override
        public Object releaseContainer() {
            ContainedSet obj = this.container;
            this.container = null;
            return obj;
        }

        @Override
        public Object getContainerObject() {
            return this.container;
        }

        public Object getExtraInfo() {
            return this.extraInfo;
        }

        public void setExtraInfo(Object extraInfo) {
            this.extraInfo = extraInfo;
        }

        public void setContentSize(long size) {
            this.getMutableContentInfo().setSize(size);
        }

        public void setContentDigest(DigestValue dv) {
            this.getMutableContentInfo().setDigestValue(dv);
        }

        public void removeContentDigest(String algorithm) {
            this.getMutableContentInfo().removeDigest(algorithm);
        }

        public static String getFixedAttributeValue(AbstractContainedSet cs, String attrName) {
            if (!cs.getAttrValue().endsWith("*") && cs.getAttrName().equals(attrName)) {
                return cs.getAttrValue();
            }
            AbstractContainedSet containedSet = AbstractContainedSet.as(ElementHolder.getContainer(cs, true, true));
            if (containedSet != null) {
                return Artifact.getFixedAttributeValue(containedSet, attrName);
            }
            return "ATTR_VALUE_NULL";
        }

        private static boolean matchWithWildCard(String s, String p) {
            if (p.endsWith("*")) {
                return s.startsWith(p.substring(0, p.length() - 1));
            }
            return s.equals(p);
        }

        public static boolean matches(String attrName, String attrValue, IArtifactKey key) {
            if (attrName.equals("n")) {
                return attrValue.equals(key.getNamespace());
            }
            if (attrName.equals("q")) {
                return attrValue.equals(key.getQualifier());
            }
            if (attrName.equals("id")) {
                return Artifact.matchWithWildCard(key.getId().toString(), attrValue);
            }
            if (attrName.equals("v")) {
                return Artifact.matchWithWildCard(key.getVersion().toString(), attrValue);
            }
            if (attrName.equals("p")) {
                return Artifact.matchWithWildCard(key.getVersion().toString(), attrValue);
            }
            return false;
        }

        void initContainer(ContainedSet cntainer) {
            this.container = cntainer;
        }

        public void setIdString(String idString) {
            this.idString = idString;
        }

        public void setPath(IPath path) {
            this.path = path;
        }

        public void setVersion(String versionString) {
            this.version = new Version(versionString);
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public String getNamespace() {
            return Artifact.getFixedAttributeValue(this.container, "n");
        }

        private String getQualifier() {
            return Artifact.getFixedAttributeValue(this.container, "q");
        }

        public String getIdString() {
            if (this.idString == INHERIT_STRING) {
                String attrValue = Artifact.getFixedAttributeValue(this.container, "id");
                return attrValue;
            }
            return this.idString;
        }

        public String getVersionString() {
            if (this.version == INHERIT_VERSION) {
                String attrValue = Artifact.getFixedAttributeValue(this.container, "v");
                return attrValue;
            }
            return this.version.toString();
        }

        private Version getVersion() {
            if (this.version == INHERIT_VERSION) {
                String versionString = this.getVersionString();
                return new Version(versionString);
            }
            return this.version;
        }

        public IPath getPath() {
            String attrValue;
            if (this.path == UNKNOWN_PATH && !(attrValue = Artifact.getFixedAttributeValue(this.container, "p")).equals("ATTR_VALUE_NULL")) {
                return new Path(attrValue);
            }
            return this.path;
        }

        @Override
        public IArtifactKey getKey() {
            return this.toArtifactKey();
        }
    }

    static class ContainedSet
    extends AbstractContainedSet {
        private Version version;
        private final List contained = new ArrayList();

        ContainedSet() {
        }

        public boolean containsOnly(Class cls) {
            if (!this.contained.isEmpty()) {
                Object last = this.contained.get(this.contained.size() - 1);
                return last.getClass().equals(cls);
            }
            return true;
        }

        public List getContained() {
            return this.contained;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        @Override
        public boolean accept(Visitor visitor) {
            boolean cont = false;
            try {
                cont = visitor.beginContainedSet(this);
                if (!cont) {
                    boolean bl = cont;
                    return bl;
                }
                for (Object obj : this.contained) {
                    if (obj instanceof Artifact) {
                        Artifact artifact = (Artifact)obj;
                        visitor.visitArtifact(artifact);
                        continue;
                    }
                    if (!(obj instanceof AbstractContainedSet)) continue;
                    AbstractContainedSet acs = (AbstractContainedSet)obj;
                    boolean accepted = acs.accept(visitor);
                    assert (accepted);
                }
            }
            finally {
                cont = visitor.endContainedSet(this);
            }
            return cont;
        }

        @Override
        public void dump(IndentWriter iw, boolean resolve) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print(this.getAttrName());
                pw.print("=");
                pw.print(this.getAttrValue());
                if (this.getContentInfo() != null) {
                    pw.print(" ");
                    pw.print(this.getContentInfo().getDigests());
                }
                for (Object obj : this.getContained()) {
                    if (obj instanceof Artifact) {
                        Artifact artifact = (Artifact)obj;
                        artifact.dump(iw);
                        continue;
                    }
                    if (obj instanceof ContainedSetReference) {
                        ContainedSetReference csr = (ContainedSetReference)obj;
                        csr.dump(iw, resolve);
                        continue;
                    }
                    if (!(obj instanceof ContainedSet)) continue;
                    ContainedSet csChild = (ContainedSet)obj;
                    csChild.dump(iw, resolve);
                }
            }
            finally {
                iw.leave();
            }
        }

        public Version getEffectiveVersion() {
            Object containerObject = this.getContainerObject();
            if (containerObject instanceof ContainedSet) {
                ContainedSet cset = (ContainedSet)containerObject;
                return cset.getEffectiveVersion();
            }
            return this.version;
        }
    }

    static class ContainedSetReference
    extends AbstractContainedSet
    implements ElementHolder.IHasHREF {
        private String href;

        ContainedSetReference() {
        }

        public void initHREF(String anHref) {
            this.href = anHref;
        }

        @Override
        public String getHREF() {
            return this.href;
        }

        @Override
        public boolean accept(Visitor visitor) {
            visitor.visitContainedSetRef(this);
            return true;
        }

        @Override
        public void dump(IndentWriter iw, boolean resolve) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print("href=");
                pw.print(this.href);
                if (this.getContentInfo() != null) {
                    pw.print(" ");
                    pw.print(this.getContentInfo());
                }
                pw.print(" ");
                ElementHolder csrHolder = ElementHolder.getHolder(this);
                if (csrHolder == null) {
                    pw.print("no holder yet");
                } else {
                    ElementHolder openHolder = csrHolder.getOpenHolder(this);
                    if (openHolder == null) {
                        pw.print("href not open");
                    } else {
                        iw.enter();
                        pw = iw.getPrintWriter();
                        pw.print("location=");
                        pw.print(openHolder.getLocation());
                        pw.print(" hashCode=");
                        pw.print("@" + Integer.toHexString(openHolder.hashCode()));
                        openHolder.dump(iw, resolve);
                    }
                }
            }
            finally {
                iw.leave();
            }
        }
    }

    static class Summary
    implements IReadArtifactRepo.ISummary {
        private static final Summary NO_SUMMARY = new Summary();
        private int count;
        private long totalSize;
        private List<String> digestAlgorithms;
        private int[] digestCount;

        public Summary(Summary summary) {
            this.count = summary.getCount();
            this.totalSize = summary.getTotalSize();
            this.digestAlgorithms = summary.digestAlgorithms;
            this.digestCount = new int[this.digestAlgorithms.size()];
            int i = 0;
            while (i < this.digestCount.length) {
                this.digestCount[i] = summary.digestCount[i];
                ++i;
            }
        }

        public Summary() {
            this.count = 0;
            this.totalSize = 0L;
            this.digestAlgorithms = Collections.EMPTY_LIST;
            this.digestCount = new int[0];
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        public List<String> getAvailableDigests() {
            return this.digestAlgorithms;
        }

        private int findDigestIndex(String algorithm) {
            int i = 0;
            while (i < this.digestAlgorithms.size()) {
                if (this.digestAlgorithms.get(i).equals(algorithm)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getAvailableDigestsCount(String algorithm) {
            int i = this.findDigestIndex(algorithm);
            if (i != -1) {
                return this.digestCount[i];
            }
            return 0;
        }

        public void setDigestCount(String algorithm, int count) {
            int i = this.findDigestIndex(algorithm);
            if (i == -1) {
                ArrayList<String> newAlgorithms = new ArrayList<String>(this.digestAlgorithms.size() + 1);
                newAlgorithms.addAll(this.digestAlgorithms);
                newAlgorithms.add(algorithm);
                int[] newDigestCounts = new int[this.digestCount.length + 1];
                System.arraycopy(this.digestCount, 0, newDigestCounts, 0, this.digestCount.length);
                newDigestCounts[this.digestCount.length] = count;
                this.digestAlgorithms = newAlgorithms;
                this.digestCount = newDigestCounts;
            } else {
                this.digestCount[i] = count;
            }
        }

        public void incrCount(int delta) {
            this.count += delta;
        }

        public void incrTotalSize(long size) {
            this.totalSize += size;
        }

        public void incrDigestCount(String algorithm, int delta) {
            int digestCnt = this.getAvailableDigestsCount(algorithm) + delta;
            this.setDigestCount(algorithm, digestCnt);
        }

        private void dump(PrintWriter pw) {
            pw.print("count=");
            pw.print(this.count);
            pw.print(" totalSize=");
            pw.print(this.totalSize);
            pw.print(" digests:");
            int i = 0;
            while (i < this.digestAlgorithms.size()) {
                String algorithm = this.digestAlgorithms.get(i);
                pw.print(algorithm);
                pw.print("=");
                pw.print(this.digestCount[i]);
                pw.print(",");
                ++i;
            }
        }

        static /* synthetic */ Summary access$1() {
            return NO_SUMMARY;
        }
    }

    static class Toc
    implements ElementHolder.IElementHasContainer {
        private Object container;
        private String etag;
        private Summary summary;
        private Version version;
        private final List<AbstractContainedSet> contents = new ArrayList<AbstractContainedSet>();

        public Toc(Object container) {
            this.container = container;
        }

        @Override
        public Object getContainerObject() {
            return this.container;
        }

        @Override
        public Object releaseContainer() {
            Object obj = this.container;
            this.container = null;
            return obj;
        }

        public List<AbstractContainedSet> getContents() {
            return this.contents;
        }

        public Summary getSummary() {
            if (this.summary == null) {
                this.summary = new Summary();
            }
            return this.summary;
        }

        public String getETag() {
            return this.etag;
        }

        public void setETag(String etag) {
            this.etag = etag;
        }

        public void setSummary(Summary summary) {
            this.summary = summary;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public void dump(IndentWriter iw, boolean resolve) {
            iw.enter();
            try {
                PrintWriter pw = iw.getPrintWriter();
                pw.print("hashCode=");
                pw.println(Integer.toHexString(this.hashCode()));
                pw.print("etag=");
                pw.print(this.etag);
                pw.print("summary:");
                if (this.summary != null) {
                    this.summary.dump(pw);
                } else {
                    pw.print("null");
                }
                for (AbstractContainedSet acs : this.getContents()) {
                    acs.dump(iw, resolve);
                }
            }
            finally {
                iw.leave();
            }
        }

        private String dumpToString() {
            StringWriter sw = new StringWriter();
            IndentWriter iw = new IndentWriter(new PrintWriter(sw));
            this.dump(iw, false);
            return sw.toString();
        }

        public String toString() {
            return this.dumpToString();
        }
    }

    private static class Visitor {
        private Visitor() {
        }

        public boolean beginContainedSet(ContainedSet cs) {
            return true;
        }

        public boolean endContainedSet(ContainedSet cs) {
            return true;
        }

        public void visitContainedSetRef(ContainedSetReference csr) {
        }

        public void visitArtifact(Artifact artifact) {
        }
    }
}

