/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

abstract class ArtifactsByDiskOperation
extends ArtifactOperationMultiple {
    protected ArtifactsByDiskOperation(boolean supportsSuspendResume) {
        super(supportsSuspendResume);
    }

    private void doExecuteGroupSourceRepo(IArtifactSession session, IRepositoryGroup group, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        IMultiArtifactOperationArguments records = artifactArgs;
        CicMultiStatus statusFailed = diskOperation.getMultiStatus();
        LinkedList<IRepository> repos = new LinkedList<IRepository>();
        for (IRepository rep : group) {
            if (!rep.isOpen() || !rep.getStatus(false, monitor).isOK()) continue;
            repos.add(rep);
        }
        boolean hadSuccess = false;
        Iterator iter = repos.iterator();
        while (iter.hasNext()) {
            IMultiArtifactOperationArguments outstandingRecords;
            IRepository repo = (IRepository)iter.next();
            this.execute(session, diskOperation.getSubContext(repo), options, records, monitor);
            IStatus statusOpFailed = records.getFailedOperationStatus();
            if (statusOpFailed.isOK()) {
                hadSuccess = true;
            }
            if (statusOpFailed.matches(8)) {
                statusFailed.merge(statusOpFailed);
                artifactArgs.setFailedOperationStatus(statusOpFailed);
                return;
            }
            if (statusOpFailed.matches(4)) {
                statusFailed.merge(statusOpFailed);
            }
            if ((outstandingRecords = MultiArtifactOperationUtil.returnOutstanding(diskOperation.getOperation(), records, iter.hasNext())).getRecords().isEmpty()) {
                return;
            }
            records = outstandingRecords;
        }
        if (!hadSuccess && !statusFailed.isOK()) {
            artifactArgs.setFailedOperationStatus(statusFailed);
        }
    }

    private void doExecuteSimpleSourceRepo(IArtifactSession session, IArtifactGet simpleSourceRepo, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        IRepository repo = simpleSourceRepo.getRepository();
        IStatus status = diskOperation.useDisk(session, repo, null, null, artifactArgs, options, monitor);
        if (status.matches(8)) {
            artifactArgs.setCanceled();
            return;
        }
        if (status.matches(4)) {
            artifactArgs.setFailedOperationStatus(status);
        }
    }

    protected void doExecuteDiskOperation(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments args, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        IRepository source = diskOperation.getSourceRepo(target);
        if (source instanceof IRepositoryGroup) {
            IRepositoryGroup sourceGroup = (IRepositoryGroup)source;
            this.doExecuteGroupSourceRepo(session, sourceGroup, diskOperation, args, options, monitor);
        } else {
            IVolumeAccessByDisk volumeGet = RepoAs.IVolumeAccessByDisk(source);
            if (volumeGet != null) {
                volumeGet.useArtifactLocatorsInOrder(session, diskOperation, args, options, monitor);
            } else {
                IArtifactGet simpleSourceRepo = RepoAs.IArtifactGet(source);
                this.doExecuteSimpleSourceRepo(session, simpleSourceRepo, diskOperation, args, options, monitor);
            }
        }
    }
}

