/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ArtifactOperationStatusSummary {
    private static final String DUMMY = "";
    private int severity = 0;
    private int severityNonCancelOrNotFound = 0;
    private IStatus mostSevereStatus = null;
    private IStatus mostSevereNonCancelOrNotFound = null;
    private final OpMultiStatus msRequestedOKStatus;
    private final OpMultiStatus msRealOKStatus;
    private final OpMultiStatus msNotFoundStatus;
    private final OpMultiStatus msCancelStatus;
    private final OpMultiStatus msErrorStatus;
    private final OpMultiStatus msWarningStatus;
    private final OpMultiStatus msInfoStatus;

    public ArtifactOperationStatusSummary(Collection statusCollection) {
        this(DUMMY, statusCollection);
    }

    public ArtifactOperationStatusSummary(String msg, Collection statusCollection) {
        this.msRequestedOKStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msRealOKStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msNotFoundStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msCancelStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msErrorStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msWarningStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        this.msInfoStatus = new OpMultiStatus(Statuses.pluginId, 0, msg, null);
        for (IStatus status : statusCollection) {
            if (status.getSeverity() > this.severity) {
                this.severity = status.getSeverity();
                this.mostSevereStatus = status;
            }
            if (status.matches(8)) {
                if (status == Status.CANCEL_STATUS) continue;
                if (status.isMultiStatus()) {
                    if (!MultiStatusUtil.hasFilteredStatusBySeverityMask(status, 4)) continue;
                    this.msCancelStatus.add(status);
                    continue;
                }
                if (status.getMessage() == null || status.getMessage().length() <= 0) continue;
                this.msCancelStatus.add(status);
                continue;
            }
            if (status == IArtifactOperation.STATUS_OK_REQUESTED) {
                this.msRequestedOKStatus.add(status);
                continue;
            }
            if (StatusCodes.isContentNotFound(status)) {
                this.msNotFoundStatus.add(status);
                continue;
            }
            if (status.getSeverity() > this.severityNonCancelOrNotFound) {
                this.severityNonCancelOrNotFound = status.getSeverity();
                this.mostSevereNonCancelOrNotFound = status;
            }
            if (status.isOK()) {
                this.msRealOKStatus.add(status);
            }
            if (status.matches(4)) {
                this.msErrorStatus.add(status);
            }
            if (status.matches(1)) {
                this.msInfoStatus.add(status);
            }
            if (!status.matches(2)) continue;
            this.msWarningStatus.add(status);
        }
    }

    public boolean matchesMostSevereNonCancelOrNotFound(int severityMask) {
        if (this.mostSevereNonCancelOrNotFound == null) {
            return false;
        }
        return this.mostSevereNonCancelOrNotFound.matches(severityMask);
    }

    public IStatus getMostSevereStatus() {
        return this.mostSevereStatus;
    }

    public boolean matchesMostSevereStatus(int severityMask) {
        if (this.mostSevereStatus == null) {
            return false;
        }
        return this.mostSevereStatus.matches(severityMask);
    }

    public OpMultiStatus getRealOKMultiStatus() {
        return this.msRealOKStatus;
    }

    public OpMultiStatus getRequestedOKMultiStatus() {
        return this.msRequestedOKStatus;
    }

    public OpMultiStatus getNotFoundMultiStatus() {
        return this.msNotFoundStatus;
    }

    public OpMultiStatus getInfoMultiStatus() {
        return this.msInfoStatus;
    }

    public OpMultiStatus getCancelMultiStatus() {
        return this.msCancelStatus;
    }

    public IStatus getCancelStatus() {
        return this.msCancelStatus.hasChildren() ? this.msCancelStatus : Status.CANCEL_STATUS;
    }

    public OpMultiStatus getErrorMultiStatus() {
        return this.msErrorStatus;
    }

    public OpMultiStatus getWarningMultiStatus() {
        return this.msWarningStatus;
    }

    public IStatus getMostSevereNonCancelOrNotFound() {
        return this.mostSevereNonCancelOrNotFound;
    }

    public static class OpMultiStatus
    extends MultiStatus {
        public OpMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
            super(pluginId, code, newChildren, message, exception);
        }

        public OpMultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        public boolean hasChildren() {
            return this.getChildren().length > 0;
        }

        public IStatus getChild(int index) {
            return this.getChildren()[index];
        }
    }
}

