/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingFile;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.TransferMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class FileContentLocator
extends AbstractContentLocator {
    private final File file;

    public FileContentLocator(File file) {
        super(new SimpleContentInfo(file.length()));
        this.file = file;
    }

    public FileContentLocator(File file, IContentInfo expectedContentInfo) {
        super(new SimpleContentInfo(file.length()), expectedContentInfo);
        this.file = file;
    }

    public static ICicStatus validateFileExists(int severity, UserNames context, IContentLocator locator, File file) {
        if (!file.exists()) {
            return FileContentLocator.makeDoesNotExistStatus(severity, context, locator, null);
        }
        return ICicStatus.OK_STATUS;
    }

    @Override
    public ICicStatus validateExists(int severity, IProgressMonitor monitor) {
        return FileContentLocator.validateFileExists(severity, null, this, this.file);
    }

    private static File createTempDipFile(File dipRoot, String simpleName) throws IOException {
        assert (dipRoot != null);
        IPath baseDir = DownloadInProgressManager.getNonValidatedFileDir(dipRoot);
        File dir = baseDir.toFile();
        FileUtil.ensureDirectory(dir);
        return TempUtil.createTempFile("cic", simpleName, dir);
    }

    public static DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(AbstractContentLocator locator, TempUtil.UniqueTempDir dipRoot, String simpleName, IPath destination) throws CoreException {
        File tempFile;
        assert (dipRoot != null);
        try {
            tempFile = FileContentLocator.createTempDipFile(dipRoot.getUniqueTempDir(), simpleName);
        }
        catch (IOException e) {
            ICicStatus status = locator.createErrorDownloadToFile(destination.toFile(), e);
            throw new CoreException((IStatus)status);
        }
        DownloadInProgressManager dipm = DownloadInProgressManager.INSTANCE;
        DownloadInProgressManager.NonValidatedDownload nrd = dipm.getNonValidatedDownload(locator, dipRoot, (IPath)new Path(tempFile.toString()), destination);
        return nrd;
    }

    @Override
    protected DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(TempUtil.UniqueTempDir dipRoot, IPath destination) throws CoreException {
        String simpleName = PathUtil.getSimpleName(this.file.toString());
        return FileContentLocator.createNonValidatedDownloadRequest(this, dipRoot, simpleName, destination);
    }

    public static IDownloadedFile downloadToFileNoValidationNoResumeRetry(AbstractContentLocator locator, IDownloadSession session, File file, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.ITransferProgress progress, long[] outReadBytes) {
        File copiedFile = destination.toFile();
        ICicStatus status = ICicStatus.OK_STATUS;
        transferPerformance.addListener(new TransferMonitor(){

            @Override
            public boolean isCanceled() {
                DownloadUI.waitUntilResumeOrRetry(DownloadUI.INSTANCE.getUI());
                return super.isCanceled();
            }
        });
        SimpleContentInfo ci = null;
        DownloadedIncompleteUsingFile downloadIncomplete = null;
        try {
            if (transferPerformance.isCanceled()) {
                return new DownloadedFile(ICicStatus.CANCEL_STATUS, null, null);
            }
            copiedFile.getParentFile().mkdirs();
            FileUtil.copyFile(file, copiedFile, UserOptions.getDownloadSyncOnClose(), transferPerformance, outReadBytes);
            ci = new SimpleContentInfo(outReadBytes[0]);
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
        }
        catch (FileNotFoundException e) {
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            status = AbstractContentLocator.makeDoesNotExistStatus(4, locator, e);
            copiedFile = null;
        }
        catch (IOException e) {
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            status = locator.createErrorDownloadToFile(copiedFile, e);
            copiedFile = null;
        }
        return new DownloadedFile(status, copiedFile, ci, downloadIncomplete);
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        return FileContentLocator.downloadToFileNoValidationNoResumeRetry(this, session, this.file, destination, transferPerformance, progress, outReadBytes);
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(null, this.file.toString());
    }

    public String toString() {
        return this.file.toString();
    }
}

