/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.iwm.internal.util;

import com.ibm.cic.common.core.iwm.internal.Messages;
import com.ibm.cic.common.core.iwm.internal.model.IwmRepository;
import com.ibm.cic.common.core.iwm.internal.util.NurtureQuestionsHelper;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.CompositeRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.DownloadContext;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.TransferManager;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.HttpClientDownloadHandler;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.NameValuePair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class IwmUtils {
    private static final Logger logger = Logger.getLogger(IwmUtils.class);
    private static final String SOURCES = "sources";
    private static final String PARAMETER_ARTIFACTS_SIZE = "artifactsSize";
    private static final String PARAMETER_DOWNLOADED_SIZE = "downloadedSize";
    private static final String PARAMETER_OFFERING_NAME = "offeringName";
    private static final String PARAMETER_OFFERING_VERSION = "offeringVersion";
    private static final String PARAMETER_OPERATION = "operation";
    private static final String PARAMETER_STATUS = "status";
    private static final String PARAMETER_UPDATED_OFFERING_NAME = "updatedOfferingName";
    private static final String PARAMETER_UPDATED_OFFERING_VERSION = "updatedOfferingVersion";
    private static final String OPERATION_INSTALL = "install";
    private static final String ACTION = "/action/";
    private static HttpClientDownloadHandler httpHandler = null;
    private static HttpClientDownloadHandler httpsHandler = null;

    static {
        httpHandler = (HttpClientDownloadHandler)TransferManager.INSTANCE.getHandler("http");
        httpsHandler = (HttpClientDownloadHandler)TransferManager.INSTANCE.getHandler("https");
    }

    public static HttpClientDownloadHandler getDownloadHandler(String url) {
        if (url.startsWith("https")) {
            return httpsHandler;
        }
        if (url.startsWith("http")) {
            return httpHandler;
        }
        return null;
    }

    public static boolean isIwmRepository(IRepository repository) {
        if (repository == null) {
            return false;
        }
        IRepositoryInfo repositoryInfo = repository.getRepositoryInfo();
        return repository.getSiteProperties().getProperty("LayoutPolicy").equals(repositoryInfo.getType());
    }

    public static void notifyNurturingAnswers(String url, NameValuePair[] pairs) {
        FileUtil.delete((File)IwmUtils.sendMessage(url, pairs));
    }

    private static NameValuePair[] createInstallNotifyMessage(IOffering offering, IOffering updatedOffering, IStatus status, Properties properties) {
        int length = 4;
        if (updatedOffering != null) {
            length += 2;
        }
        NameValuePair[] pairs = new NameValuePair[length + properties.size()];
        int i = 0;
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_NAME, offering.getIdentity().getId());
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_VERSION, offering.getVersion().toString());
        pairs[i++] = new NameValuePair(PARAMETER_OPERATION, OPERATION_INSTALL);
        pairs[i++] = new NameValuePair(PARAMETER_STATUS, status.toString());
        if (updatedOffering != null) {
            pairs[i++] = new NameValuePair(PARAMETER_UPDATED_OFFERING_NAME, updatedOffering.getIdentity().getId());
            pairs[i++] = new NameValuePair(PARAMETER_UPDATED_OFFERING_VERSION, updatedOffering.getVersion().toString());
        }
        for (String string : properties.keySet()) {
            pairs[i] = new NameValuePair(string, properties.getProperty(string));
            ++i;
        }
        if (logger.isDebugLoggable()) {
            logger.info(Messages.IwmUtils_install_complete_notification_message);
            IwmUtils.logNotificationMessage(pairs);
        }
        return pairs;
    }

    private static void logNotificationMessage(NameValuePair[] pairs) {
        NameValuePair[] nameValuePairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair pair = nameValuePairArray[n2];
            logger.debug(String.valueOf(pair.getName()) + ":" + pair.getValue());
            ++n2;
        }
    }

    public static void notifyOfferingInstallComplete(String url, IOffering offering, IOffering updatedOffering, IStatus status, Properties properties) {
        NameValuePair[] pairs = IwmUtils.createInstallNotifyMessage(offering, updatedOffering, status, properties);
        FileUtil.delete((File)IwmUtils.sendMessage(url, pairs));
    }

    public static String[] parseUrlEncodedToken(String token) throws UnsupportedEncodingException, IllegalArgumentException {
        String[] tagAndValue = new String[2];
        int index = token.indexOf(61);
        if (index > 0) {
            tagAndValue[0] = token.substring(0, index);
            if (index < token.length() - 1) {
                tagAndValue[1] = URLDecoder.decode(token.substring(index + 1), "UTF-8");
            }
        }
        return tagAndValue;
    }

    public static File sendMessage(String url) {
        return IwmUtils.sendMessage(url, new NameValuePair[0]);
    }

    public static File sendMessage(String url, NameValuePair[] pairs) {
        assert (url != null);
        HttpClientDownloadHandler handler = IwmUtils.getDownloadHandler(url);
        if (handler == null) {
            return null;
        }
        try {
            url = IwmUtils.transformUrlForNonProdEnvironments(url);
            DownloadContext ctxt = new DownloadContext();
            return handler.sendPostMessage((IDownloadContext)ctxt, url, pairs);
        }
        catch (Exception e) {
            logger.error("Unable complete http conversation: {0}", new Object[]{url});
            logger.error("Reason: {0}", new Object[]{e.getMessage()});
            return null;
        }
    }

    private static String transformUrlForNonProdEnvironments(String url) {
        int index;
        String prefix = System.getProperty("actionUrlPrefix");
        if (prefix != null && (index = url.indexOf(ACTION)) > -1) {
            return String.valueOf(prefix) + url.substring(index);
        }
        return url;
    }

    public static IwmRepository getIwmRepository(IRepository group, IOffering offering) {
        IOffering baseOffering = IwmUtils.getBaseOffering(group, offering);
        IwmRepository iwmRepo = IwmUtils.getIwmRepositoryInternal(baseOffering.getRepository(), baseOffering);
        return iwmRepo;
    }

    private static IOffering getBaseOffering(IRepository group, IOffering offering) {
        IOffering baseOfferingIterator = offering;
        IOffering baseOffering = null;
        while (baseOfferingIterator != null && baseOffering != baseOfferingIterator) {
            baseOffering = baseOfferingIterator;
            baseOfferingIterator = UpdateOfferingUtils.getBaseOffering((IOffering)baseOfferingIterator, (IRepository)group, (IProgressMonitor)new NullProgressMonitor());
        }
        return baseOffering;
    }

    private static IwmRepository getIwmRepositoryInternal(IRepository repository, IOffering offering) {
        CompositeRepository composite;
        if (repository == null) {
            return null;
        }
        if (repository instanceof IwmRepository) {
            return (IwmRepository)repository;
        }
        IRepository actualRepository = RepositoryUtils.getRawRepository((IRepository)repository);
        if (actualRepository instanceof IwmRepository) {
            return (IwmRepository)actualRepository;
        }
        if (actualRepository instanceof CompositeRepository && (actualRepository = RepositoryUtils.getRawRepository((IRepository)(composite = (CompositeRepository)actualRepository).getProviderRepository(offering))) instanceof IwmRepository) {
            return (IwmRepository)actualRepository;
        }
        return null;
    }

    private IwmUtils() {
    }

    public static Map fetchNurtureQuestions(String url, List sources) {
        NameValuePair[] nameValuePairs = IwmUtils.createFetchNurtureQuestionsMessage(sources);
        File responseFile = IwmUtils.sendMessage(url, nameValuePairs);
        try {
            if (responseFile != null) {
                Map map = NurtureQuestionsHelper.getInstance().populateNurtureQuestions(responseFile);
                return map;
            }
        }
        catch (Exception e) {
            logger.error(Messages.IwmUtils_unable_to_populate_nurture_questions);
            logger.error((Throwable)e);
        }
        finally {
            FileUtil.delete((File)responseFile);
        }
        return Collections.EMPTY_MAP;
    }

    private static NameValuePair[] createFetchNurtureQuestionsMessage(List sources) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < sources.size()) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(sources.get(i));
            ++i;
        }
        return new NameValuePair[]{new NameValuePair(SOURCES, buf.toString())};
    }

    public static void notifyBeginFetch(String url, IOffering offering, String phaseName, Properties properties) {
        NameValuePair[] pairs = IwmUtils.createBeginFetchMessage(offering, phaseName, properties);
        FileUtil.delete((File)IwmUtils.sendMessage(url, pairs));
    }

    private static NameValuePair[] createBeginFetchMessage(IOffering offering, String phaseName, Properties properties) {
        NameValuePair[] pairs = new NameValuePair[3 + properties.size()];
        int i = 0;
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_NAME, offering.getIdentity().getId());
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_VERSION, offering.getVersion().toString());
        pairs[i++] = new NameValuePair(PARAMETER_OPERATION, phaseName);
        for (String string : properties.keySet()) {
            pairs[i] = new NameValuePair(string, properties.getProperty(string));
            ++i;
        }
        if (logger.isDebugLoggable()) {
            logger.info(Messages.IwmUtils_begin_fetch_notification_message);
            IwmUtils.logNotificationMessage(pairs);
        }
        return pairs;
    }

    public static void notifyFetchComplete(String url, IOffering offering, String phaseName, String status, long artifactsSize, long downloadedArtifactsSize, Properties properties) {
        NameValuePair[] pairs = IwmUtils.createFetchCompleteMessage(offering, phaseName, status, artifactsSize, downloadedArtifactsSize, properties);
        FileUtil.delete((File)IwmUtils.sendMessage(url, pairs));
    }

    private static NameValuePair[] createFetchCompleteMessage(IOffering offering, String phaseName, String status, long artifactsSize, long downloadedArtifactsSize, Properties properties) {
        NameValuePair[] pairs = new NameValuePair[6 + properties.size()];
        int i = 0;
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_NAME, offering.getIdentity().getId());
        pairs[i++] = new NameValuePair(PARAMETER_OFFERING_VERSION, offering.getVersion().toString());
        pairs[i++] = new NameValuePair(PARAMETER_OPERATION, phaseName);
        pairs[i++] = new NameValuePair(PARAMETER_STATUS, status);
        pairs[i++] = new NameValuePair(PARAMETER_ARTIFACTS_SIZE, String.valueOf(artifactsSize));
        pairs[i++] = new NameValuePair(PARAMETER_DOWNLOADED_SIZE, String.valueOf(downloadedArtifactsSize));
        for (String string : properties.keySet()) {
            pairs[i] = new NameValuePair(string, properties.getProperty(string));
            ++i;
        }
        if (logger.isDebugLoggable()) {
            logger.info(Messages.IwmUtils_fetch_complete_notification_message);
            IwmUtils.logNotificationMessage(pairs);
        }
        return pairs;
    }

    public static File sendMessage(String url, String response) {
        assert (url != null);
        HttpClientDownloadHandler handler = IwmUtils.getDownloadHandler(url);
        if (handler == null) {
            return null;
        }
        try {
            url = IwmUtils.transformUrlForNonProdEnvironments(url);
            DownloadContext ctxt = new DownloadContext();
            return handler.sendPostMessage((IDownloadContext)ctxt, url, Encodings.UTF8.toInputStream(response));
        }
        catch (Exception e) {
            logger.error("Unable complete http conversation: " + url);
            logger.error("Reason: ", new Object[]{e.getMessage()});
            return null;
        }
    }
}

