/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.FF;
import com.certicom.ecc.FFFactory;
import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ECDSA
extends ECTransform {
    private ECKey F;
    private FFFactory E;
    private CryptoTransform C;
    private ECA A;
    private ECA D;
    private int H = SystemConfig.getConfig().getHashType();
    private byte[] G;
    private CryptoCodec B;

    public ECDSA() {
        super("ECDSA");
        this.C = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "SHA-1");
        this.B = CryptoCodec.getInstance("ECDSA", this.k);
    }

    private static int if(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        if (n == byArray.length) {
            return 0;
        }
        int n2 = (byArray.length - n - 1) * 8;
        int n3 = 7;
        do {
            if ((byArray[n] >>> n3 & 1) != 1) continue;
            n2 += n3 + 1;
            break;
        } while (--n3 >= 0);
        return n2;
    }

    private byte[] do() {
        int n;
        if (this.H == 17) {
            this.G = this.C.transform(null, 0, 0, true);
        }
        if (this.i == 16 && (n = 160 - ECDSA.if(this.F.getECParams().getPointOrder()) + 1) >= 1) {
            int n2 = 0;
            while (n2 < n / 8) {
                this.G[n2] = 0;
                ++n2;
            }
            if (n % 8 != 0) {
                int n3 = n2;
                this.G[n3] = (byte)(this.G[n3] & (1 << 8 - n % 8) - 1);
            }
        }
        return this.G;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n, objectArray, random);
        if (objectArray != null && (n == 1 && random != null || n == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        this.C.init(5, null, random);
        this.F = (ECKey)objectArray[0];
        try {
            ECFactory eCFactory = ECFactory.a(this.F.getECParams());
            this.E = FFFactory.a("FP");
            this.E.a(this.F.getECParams().getPointOrder(), null);
            this.A = eCFactory.int();
            if (n == 2) {
                ECPublicKey eCPublicKey = (ECPublicKey)this.F;
                this.D = eCFactory.a(eCPublicKey.getX(), eCPublicKey.getY());
            }
        }
        catch (ECException eCException) {
            this.reset();
            throw new IllegalStateException("cannot do ec operations.");
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        int n2 = (ECDSA.if(this.F.getECParams().getPointOrder()) + 7) / 8 * 2;
        if (this.k == 10) {
            return n2;
        }
        if (this.k == 11) {
            return n2 + 9;
        }
        return 0;
    }

    public void reset() {
        super.reset();
        this.F = null;
        this.E = null;
        this.C.reset();
        this.A = null;
        this.D = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ECA eCA = null;
        FF fF = null;
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.H == 18) {
                this.G = new byte[n2];
                System.arraycopy(byArray, n, this.G, 0, n2);
            } else {
                this.C.transform(byArray, n, n2, false);
            }
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        FF fF2 = this.E.for(this.do());
        try {
            object4 = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYGEN");
            ((CryptoTransform)object4).init(5, new Object[]{this.F.getECParams()}, this.rnd);
            object3 = (Object[])((CryptoTransform)object4).transformToObject(null, 0, 0, true);
            object2 = FFFactory.a("FP");
            ((FFFactory)object2).a(this.F.getECParams().getPointOrder(), null);
            fF = ((FFFactory)object2).for(((ECPrivateKey)object3[0]).getExp());
            object = ECFactory.a(this.F.getECParams());
            eCA = ((ECFactory)object).a(((ECPublicKey)object3[1]).getX(), ((ECPublicKey)object3[1]).getY());
        }
        catch (ECException eCException) {
            this.reset();
            throw new IllegalStateException("cannot do ec operations.");
        }
        object4 = this.E.for(eCA.a().int());
        object3 = this.E.for(((ECPrivateKey)this.F).getExp());
        object2 = fF.if().do(((FF)object3).do((FF)object4).if(fF2));
        object = ((FF)object4).int();
        byte[] byArray3 = ((FF)object2).int();
        this.B.init(1, null);
        this.B.codecToObject((byte[])object, 0, ((Object)object).length, false);
        Object[] objectArray = this.B.codecToObject(byArray3, 0, byArray3.length, true);
        byte[] byArray4 = (byte[])objectArray[1];
        if (byArray2.length - n3 < byArray4.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
        return byArray4.length;
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        if (this.mode != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        this.B.init(2, null);
        Object[] objectArray = this.B.codecToObject(byArray, n, byArray.length, true);
        byte[] byArray2 = (byte[])objectArray[1];
        byte[] byArray3 = (byte[])objectArray[2];
        FF fF = this.E.for(this.do());
        FF fF2 = this.E.for(byArray2);
        FF fF3 = this.E.for(byArray3);
        FF fF4 = fF3.if();
        FF fF5 = fF.do(fF4);
        FF fF6 = fF2.do(fF4);
        ECA eCA = this.A.a(fF5.do(), this.D, fF6.do());
        FF fF7 = this.E.for(eCA.a().int());
        return fF7.equals(fF2);
    }
}

