/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import java.math.BigInteger;
import java.util.Random;

public final class DH
extends CryptoTransform {
    private byte[] ax;

    public DH() {
        super("DH");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n != 6 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        super.init(n, objectArray, random);
        try {
            BigInteger bigInteger = new BigInteger(1, (byte[])objectArray[0]);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[1]);
            BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[2]);
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
            byte[] byArray = bigInteger4.toByteArray();
            int n2 = ((byte[])objectArray[0]).length;
            this.ax = new byte[n2];
            if (n2 + 1 == byArray.length) {
                System.arraycopy(byArray, 1, this.ax, 0, n2);
            } else if (n2 > byArray.length) {
                System.arraycopy(byArray, 0, this.ax, n2 - byArray.length, byArray.length);
            } else if (n2 == byArray.length) {
                this.ax = byArray;
            }
        }
        catch (Exception exception) {
            this.reset();
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode == 6) {
            return this.ax.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public void reset() {
        super.reset();
        if (this.ax != null) {
            int n = 0;
            while (n < this.ax.length) {
                this.ax[n++] = 0;
            }
        }
        this.ax = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 6) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray2 == null || byArray2.length - n3 < this.ax.length) {
            throw new IllegalArgumentException("out buf error");
        }
        System.arraycopy(this.ax, 0, byArray2, n3, this.ax.length);
        return this.ax.length;
    }
}

