/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RSAPrivateKey
implements RSAKey {
    private BigInteger new;
    private BigInteger byte;
    private BigInteger a;
    protected BigInteger int;
    protected BigInteger for;
    protected BigInteger do;
    protected BigInteger if;
    protected BigInteger try;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.new = bigInteger;
        this.byte = bigInteger2;
        this.a = bigInteger3;
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1 || bigInteger4.signum() == -1 || bigInteger5.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.int = bigInteger;
        this.for = bigInteger2;
        this.do = bigInteger3;
        this.if = bigInteger4;
        this.try = bigInteger5;
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this(bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.new = bigInteger;
        this.byte = bigInteger2;
        this.a = bigInteger3;
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.new = Conversion.OS2IP(byArray);
        this.byte = Conversion.OS2IP(byArray2);
        this.a = Conversion.OS2IP(byArray3);
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.int = Conversion.OS2IP(byArray);
        this.for = Conversion.OS2IP(byArray2);
        this.do = Conversion.OS2IP(byArray3);
        this.if = Conversion.OS2IP(byArray4);
        this.try = Conversion.OS2IP(byArray5);
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7, byte[] byArray8) {
        this(byArray4, byArray5, byArray6, byArray7, byArray8);
        this.new = Conversion.OS2IP(byArray);
        this.byte = Conversion.OS2IP(byArray2);
        this.a = Conversion.OS2IP(byArray3);
    }

    public BigInteger d() {
        return this.a;
    }

    public BigInteger dP() {
        return this.do;
    }

    public BigInteger dQ() {
        return this.if;
    }

    public BigInteger e() {
        return this.byte;
    }

    public boolean hasCRT() {
        return this.int != null;
    }

    public boolean hasExponents() {
        return this.new != null;
    }

    public BigInteger n() {
        return this.new;
    }

    public BigInteger p() {
        return this.int;
    }

    public BigInteger q() {
        return this.for;
    }

    public BigInteger qInv() {
        return this.try;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        if (this.hasExponents()) {
            stringBuffer.append(" n = ").append(this.new.toString(16));
            stringBuffer.append(" e = ").append(this.byte.toString(16));
            stringBuffer.append(" d = ").append(this.a.toString(16));
        }
        if (this.hasCRT()) {
            stringBuffer.append(" p = ").append(this.int.toString(16));
            stringBuffer.append(" q = ").append(this.for.toString(16));
            stringBuffer.append(" dP = ").append(this.do.toString(16));
            stringBuffer.append(" dQ = ").append(this.if.toString(16));
            stringBuffer.append(" qInv = ").append(this.try.toString(16));
        }
        return stringBuffer.append(" ]").toString();
    }
}

