/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.codec;

import com.certicom.ecc.system.CryptoManager;

public abstract class CryptoCodec {
    public static final int UNINIT = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 2;
    public static final Class TYPE;
    protected int mode = 0;
    protected String format = null;
    protected String type = null;
    protected byte[] data;
    protected int doff;
    protected Object dataObj;
    protected Object[] result;

    static {
        try {
            TYPE = Class.forName("com.certicom.ecc.codec.CryptoCodec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }

    protected CryptoCodec(String string) {
        this.format = string;
    }

    public Object[] codecToObject(Object object, boolean bl) {
        if (object instanceof byte[]) {
            throw new IllegalArgumentException("use codecToObject(byte[], int, int, boolean)");
        }
        this.dataObj = object;
        if (bl || this.hasInterData()) {
            this.dataOK(true);
            if (this.mode == 1) {
                this.encode();
            } else {
                this.decode();
            }
            this.a();
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    public Object[] codecToObject(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        this.storeData(byArray, n, n2);
        if (bl || this.hasInterData()) {
            this.dataOK(false);
            if (this.mode == 1) {
                this.encode();
            } else {
                this.decode();
            }
            this.a();
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    protected void dataOK(boolean bl) {
        if (bl ? this.dataObj == null : this.data == null || this.doff == 0) {
            throw new IllegalStateException("no data to codec");
        }
    }

    protected abstract void decode();

    protected abstract void encode();

    public String getFormat() {
        return this.format;
    }

    public static CryptoCodec getInstance(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string).append("/");
        if (n == 10) {
            stringBuffer.append("Raw");
        } else {
            stringBuffer.append("Asn1");
        }
        try {
            CryptoCodec cryptoCodec = (CryptoCodec)CryptoManager.getInstance(TYPE, stringBuffer.toString());
            cryptoCodec.type = string;
            return cryptoCodec;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(" not found. Error as follows:").append(illegalArgumentException.getMessage());
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    public int getMode() {
        return this.mode;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasInterData() {
        return false;
    }

    public void init(int n, Object[] objectArray) throws IllegalArgumentException {
        this.mode = n;
    }

    public int inputSize() {
        return 0;
    }

    public boolean isIncremental() {
        return true;
    }

    public int outputSize() {
        return 0;
    }

    public void reset() {
        this.mode = 0;
        this.data = null;
        this.doff = 0;
        this.dataObj = null;
        this.result = null;
    }

    private void a() {
        this.dataObj = null;
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                this.data[n++] = 0;
            }
        }
        this.doff = 0;
    }

    protected void storeData(byte[] byArray, int n, int n2) {
        if (this.mode == 1 || this.mode == 2) {
            int n3;
            if (byArray == null) {
                return;
            }
            if (this.data == null) {
                this.data = new byte[n2 < 256 ? 256 : n2];
                this.doff = 0;
            }
            if ((n3 = this.data.length - this.doff) < n2) {
                int n4 = n2 - n3 > 256 ? n2 - n3 : 256;
                byte[] byArray2 = new byte[this.data.length + n4];
                System.arraycopy(this.data, 0, byArray2, 0, this.doff);
                this.data = byArray2;
            }
            System.arraycopy(byArray, n, this.data, this.doff, n2);
            this.doff += n2;
            return;
        }
        throw new IllegalStateException("wrong mode");
    }
}

