/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConViewXML
extends AConView {
    private final String m_xml;

    public ConViewXML(String text) {
        this.m_xml = text;
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        return null;
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        return null;
    }

    @Override
    public void present(OutputFormatter a_output) {
        XMLToConsoleParser xmlToConsole = new XMLToConsoleParser();
        xmlToConsole.format(this.m_xml, a_output);
    }

    private static class XMLToConsoleParser
    extends XMLParser {
        private static final String HREF = "href";
        private static final Logger log = Logger.getLogger(XMLToConsoleParser.class);
        private OutputFormatter m_formatter;
        private Attributes m_attributes;

        public void format(String in, OutputFormatter f) {
            this.m_formatter = f;
            this.m_formatter.decTab(true);
            InputSource source = new InputSource(new StringReader(in));
            try {
                this.getParser().parse(source, (DefaultHandler)((Object)this));
            }
            catch (SAXException e) {
                log.error((Throwable)e);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                log.error((Throwable)e);
            }
        }

        public void startElement(String uri, String name, String qName, Attributes attr) {
            String data = this.finishCharacters();
            if (data != null) {
                this.m_formatter.appendTnl(new String[]{data});
            }
            this.m_attributes = attr;
            this.m_formatter.incTab();
        }

        public void processingInstruction(String target, String data) {
        }

        public void endElement(String uri, String name, String qName) {
            String href;
            String data = this.finishCharacters();
            String string = href = this.m_attributes != null ? this.parseOptionalAttribute(name, this.m_attributes, HREF) : null;
            if (data != null) {
                this.m_formatter.appendTnl(new String[]{data});
                if (href != null) {
                    this.m_formatter.incTab();
                    this.m_formatter.appendTnl(new String[]{href});
                    this.m_formatter.decTab();
                }
            } else if (href != null) {
                this.m_formatter.appendTnl(new String[]{href});
            }
            this.m_formatter.decTab();
            this.m_attributes = null;
        }

        public XMLToConsoleParser() {
            this(ComIbmCicCommonCorePlugin.getBundleContext());
        }

        protected XMLToConsoleParser(BundleContext context) {
            super(context, ComIbmCicCommonCorePlugin.getPluginId());
            this.context = context;
        }

        protected String getErrorMessage() {
            return Messages.ViewXML_ErrorParsing;
        }

        protected Logger getLogger() {
            return Logger.getLogger(XMLToConsoleParser.class);
        }

        protected Object getRootObject() {
            return null;
        }

        protected String processCharacters(String trimmedChars) {
            return trimmedChars;
        }
    }
}

