/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConViewStatus
extends ConViewText {
    IStatus m_status;
    int m_severityFilter = 0;

    public ConViewStatus(String a_header) {
        this(a_header, true, null, 4);
    }

    public ConViewStatus(String a_header, boolean a_addNewLine, IStatus a_status, int a_severityFilter) {
        super(a_header, a_addNewLine);
        this.m_status = a_status;
        this.m_severityFilter = a_severityFilter;
    }

    public ConViewStatus(IStatus a_status) {
        this(null, true, a_status, 14);
    }

    public ConViewStatus() {
        this(null, true, Status.OK_STATUS, 14);
    }

    @Override
    public void present(OutputFormatter output) {
        super.present(output);
        if (this.m_status != null && this.m_status.matches(this.m_severityFilter)) {
            IStatus displayStatus = ConViewStatus.fixStatusToDisplay(this.m_status);
            this.formatOutput(output, displayStatus, true);
            output.nl(this.getTrailingNewLineNr());
            if (!displayStatus.isOK() && CommonSharedUIUtils.shouldShowViewDetails((IStatus)displayStatus)) {
                output.appendNT(String.format("%6s. ", "V"));
                output.appendTnl(new String[]{Messages.ConViewStatus_ViewDetais});
                output.nl(this.getTrailingNewLineNr());
            }
        }
    }

    public static IStatus fixStatusToDisplay(IStatus status) {
        return StatusUtil.fixMultiStatusNoMsgProblem((IStatus)status);
    }

    public void setStatus(IStatus a_status) {
        this.m_status = a_status;
    }

    public IStatus getStatus() {
        return this.m_status;
    }

    public static String getSeverityLabel(IStatus a_status) {
        switch (a_status.getSeverity()) {
            case 4: {
                return Messages.General_Error.trim();
            }
            case 2: {
                return Messages.General_Warning.trim();
            }
            case 1: {
                return Messages.General_Info.trim();
            }
            case 8: {
                return Messages.General_Cancel;
            }
            case 0: {
                return Messages.General_Ok.trim();
            }
        }
        return "";
    }

    private String getSeverityDialogTitle(IStatus a_status) {
        switch (a_status.getSeverity()) {
            case 4: {
                return com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error;
            }
            case 2: {
                return com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Warning;
            }
            case 1: {
                return com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Info;
            }
            case 8: {
                return com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Cancel;
            }
            case 0: {
                return com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_OK;
            }
        }
        return "";
    }

    private void formatStatusKind(OutputFormatter output, IStatus a_status) {
        output.appendT(new String[]{ConViewStatus.getSeverityLabel(a_status)});
        output.addSpace(1);
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        String input = a_input.getString();
        if (input.equalsIgnoreCase("V")) {
            final IStatus displayStatus = ConViewStatus.fixStatusToDisplay(this.m_status);
            final String title = this.getSeverityDialogTitle(displayStatus);
            return new AConActionEntry(){

                @Override
                public void run(IConManager conManager) {
                    ConStatusMessageDialog.open(conManager, title, null, displayStatus, 15, true);
                }
            };
        }
        return null;
    }

    private void formatOutput(OutputFormatter output, IStatus a_status, boolean includeKind) {
        if (includeKind) {
            this.formatStatusKind(output, a_status);
        }
        String msg = StatusUtil.combineAnchors((String)a_status.getMessage());
        if (includeKind) {
            output.appendNTnl(String.valueOf(msg));
        } else {
            output.appendTnl(new String[]{String.valueOf(msg)});
        }
    }
}

