/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.List;

public class ConViewGroup
extends AConView {
    private final List<IConView> m_views = new ArrayList<IConView>();
    private int m_indent = 0;

    public ConViewGroup() {
    }

    public ConViewGroup(int indent) {
        this.m_indent = indent;
    }

    public void addView(IConView v) {
        this.m_views.add(v);
        v.setParent(this);
    }

    public void removeView(IConView v) {
        this.m_views.remove(v);
        v.setParent(null);
    }

    @Override
    public void present(OutputFormatter a_output) {
        int i = 0;
        while (i < this.m_indent) {
            a_output.incTab();
            ++i;
        }
        for (IConView v : this.m_views) {
            v.present(a_output);
        }
        i = 0;
        while (i < this.m_indent) {
            a_output.decTab();
            ++i;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        for (IConView v : this.m_views) {
            v.initialize();
        }
    }

    public void clear() {
        this.m_views.clear();
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        IConAction return_value = null;
        for (IConView v : this.m_views) {
            return_value = v.getAction(a_input);
            if (return_value != null) break;
        }
        return return_value;
    }

    public int size() {
        return this.m_views.size();
    }

    public IConView get(int index) {
        return this.m_views.get(index);
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        for (IConView v : this.m_views) {
            String key = v.findKey(a_matcher);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

