/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class WindowsJNILibrary {
    private static final byte[] HEADER_SIG_BYTES;
    private static final byte[] UNKNOWN_MACHINE_ID_BYTES;
    private static final byte[] X86_MACHINE_ID_BYTES;
    private static final byte[] IA64_MACHINE_ID_BYTES;
    private static final byte[] X86_64_MACHINE_ID_BYTES;
    public static final int UNKNOWN_MACHINE = 0;
    public static final int X86_MACHINE = 1;
    public static final int X86_64_MACHINE = 2;
    public static final int IA64_MACHINE = 3;
    private static int JVM_MACHINE_ARCH;
    private static boolean emitSearch;
    private File jniLibraryFile = null;
    private int libraryArch = 0;

    public WindowsJNILibrary(File file) throws NullPointerException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("jniLibrary cannot be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Could not locate JNI Library: [" + file.getAbsolutePath() + "].  Therefore cannot identify compatibility.");
        }
        this.jniLibraryFile = file;
        byte[] byArray = WindowsJNILibrary.findMachineID(this.jniLibraryFile);
        if (WindowsJNILibrary.equalArrays(byArray, X86_MACHINE_ID_BYTES)) {
            if (emitSearch) {
                System.out.println("LOGGING: NativeFile determined library: [" + file.getAbsolutePath() + "] is a [x86] DLL.");
            }
            this.libraryArch = 1;
        } else if (WindowsJNILibrary.equalArrays(byArray, IA64_MACHINE_ID_BYTES)) {
            if (emitSearch) {
                System.out.println("LOGGING: NativeFile determined library: [" + file.getAbsolutePath() + "] is a [IA64] DLL.");
            }
            this.libraryArch = 3;
        } else if (WindowsJNILibrary.equalArrays(byArray, X86_64_MACHINE_ID_BYTES)) {
            if (emitSearch) {
                System.out.println("LOGGING: NativeFile determined library: [" + file.getAbsolutePath() + "] is a [x86_64] DLL.");
            }
            this.libraryArch = 2;
        } else {
            if (emitSearch) {
                System.out.println("LOGGING: NativeFile determined library: [" + file.getAbsolutePath() + "] is a [unknown architecture] DLL.");
            }
            this.libraryArch = 0;
        }
    }

    public File getJNILibraryFile() {
        return this.jniLibraryFile;
    }

    public int getLibraryArchitecture() {
        return this.libraryArch;
    }

    public boolean isCompatible() {
        boolean bl;
        block3: {
            block2: {
                bl = false;
                if (JVM_MACHINE_ARCH == this.getLibraryArchitecture() || this.getLibraryArchitecture() == 0) break block2;
                if (JVM_MACHINE_ARCH != 0) break block3;
            }
            bl = true;
        }
        return bl;
    }

    private static byte[] findMachineID(File file) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        BufferedInputStream bufferedInputStream = null;
        boolean bl = false;
        byte[] byArray2 = new byte[]{0, 0};
        if (file.length() > 4L) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            n = ((InputStream)bufferedInputStream).read(byArray, 0, 4);
            if (n != 4) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile could not read the first four bytes of the DLL: [" + file.getAbsolutePath() + "].  I/O problem.  Exception will be thrown.");
                }
                ((InputStream)bufferedInputStream).close();
                throw new IOException("Could not read first 4 bytes of stream.  Cannot determine machine ID.");
            }
            while (!bl) {
                bl = WindowsJNILibrary.equalArrays(byArray, HEADER_SIG_BYTES);
                if (!bl) {
                    byArray[3] = byArray[2];
                    byArray[2] = byArray[1];
                    byArray[1] = byArray[0];
                    n = ((InputStream)bufferedInputStream).read(byArray, 0, 1);
                    if (n != -1) continue;
                    break;
                }
                if (!emitSearch) continue;
                System.out.println("LOGGING: NativeFile located the library header start, DLL architecture analysis can be done.");
            }
            if (bl && (n = ((InputStream)bufferedInputStream).read(byArray2, 0, 2)) != 2) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile could not read the two byte architecture signature of the DLL: [" + file.getAbsolutePath() + "].  I/O problem.  Exception will be thrown.");
                }
                ((InputStream)bufferedInputStream).close();
                throw new IOException("Unable to read the two byte machine architecture signature from the library: [" + file.getAbsolutePath() + "].");
            }
        } else {
            if (emitSearch) {
                System.out.println("LOGGING: NativeFile determined library: [" + file.getAbsolutePath() + "] was too small to be a complete DLL.  Exception will be thrown.");
            }
            throw new IOException("The file specified by: [" + file.getAbsolutePath() + "] was smaller than 4 bytes.  It is not a complete DLL.");
        }
        if (bufferedInputStream != null) {
            ((InputStream)bufferedInputStream).close();
        }
        return byArray2;
    }

    private static boolean equalArrays(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        if (byArray.length != byArray2.length) {
            bl = false;
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        File file = null;
        WindowsJNILibrary windowsJNILibrary = null;
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if (stringArray != null && stringArray.length == 1 && !(file = new File(stringArray[0])).exists()) {
            file = null;
        }
        if (string != null && string.toLowerCase().startsWith("window")) {
            System.out.println("");
            System.out.println("JVM and JNI library architecture detection test.");
            System.out.println("JVM reports for OS name: [" + string + "]");
            System.out.println("JVM reports for OS architecture: [" + string2 + "]");
            if (JVM_MACHINE_ARCH == 1) {
                System.out.println("JVM was determined to be [x86 32 bit] application.");
            } else if (JVM_MACHINE_ARCH == 2) {
                System.out.println("JVM was determined to be [x86_64 (Opteron/EM64T) 64 bit] application.");
            } else if (JVM_MACHINE_ARCH == 3) {
                System.out.println("JVM was determined to be [IA64 64 bit] application.");
            } else {
                System.out.println("JVM was determined to be [unknown architecture] application.");
            }
            System.out.println("");
            if (file != null) {
                try {
                    windowsJNILibrary = new WindowsJNILibrary(file);
                    if (windowsJNILibrary.getLibraryArchitecture() == 1) {
                        System.out.println("Library: [" + file.getAbsolutePath() + "] was determined to be a [x86 32 bit] DLL.");
                    } else if (windowsJNILibrary.getLibraryArchitecture() == 2) {
                        System.out.println("Library: [" + file.getAbsolutePath() + "] was determined to be a [x86_64 (Opteron/EM64T) 64 bit] DLL.");
                    } else if (windowsJNILibrary.getLibraryArchitecture() == 3) {
                        System.out.println("Library: [" + file.getAbsolutePath() + "] was determined to be a [IA64 64 bit] DLL.");
                    } else {
                        System.out.println("Library: [" + file.getAbsolutePath() + "] was determined to be a [unknown architecture] DLL.");
                    }
                    System.out.println("Library: [" + file.getAbsolutePath() + "] is compatible with current JVM? [" + windowsJNILibrary.isCompatible() + "]");
                }
                catch (Exception exception) {
                    System.out.println("There was a problem in examining the passed in library.  The exception was: " + exception.toString());
                    exception.printStackTrace();
                }
                System.out.println("");
            }
        } else {
            System.out.println("");
            System.out.println("JVM and JNI library architecture detection test.");
            System.out.println("JVM reports for OS name: [" + string + "]");
            System.out.println("This was not detected as a Windows compatible OS, therefore not executing analysis.");
        }
    }

    static {
        String string;
        HEADER_SIG_BYTES = new byte[]{0, 0, 69, 80};
        UNKNOWN_MACHINE_ID_BYTES = new byte[]{0, 0};
        X86_MACHINE_ID_BYTES = new byte[]{76, 1};
        IA64_MACHINE_ID_BYTES = new byte[]{0, 2};
        X86_64_MACHINE_ID_BYTES = new byte[]{100, -122};
        JVM_MACHINE_ARCH = 0;
        emitSearch = false;
        String string2 = System.getProperty("com.ibm.io.file.nativefile.emitlibrarysearch");
        if (string2 != null && "true".equalsIgnoreCase(string2)) {
            emitSearch = true;
        }
        if ((string = System.getProperty("os.arch")) != null) {
            if ((string = string.toLowerCase()).equals("x86") || string.equals("i386") || string.equals("ia32") || string.equals("x86-32") || string.equals("x86_32") || string.equals("x32")) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile determined JVM running on architecture: [x86]");
                }
                JVM_MACHINE_ARCH = 1;
            } else if (string.equals("x86_64") || string.equals("amd64") || string.equals("x86-64") || string.equals("opteron") || string.equals("em64t") || string.equals("x64")) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile determined JVM running on architecture: [x86_64]");
                }
                JVM_MACHINE_ARCH = 2;
            } else if (string.equals("ia64")) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile determined JVM running on architecture: [IA64]");
                }
                JVM_MACHINE_ARCH = 3;
            }
        } else {
            JVM_MACHINE_ARCH = 0;
        }
    }
}

