/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter.fileUtils;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.PerformChildInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.fileUtils.FileUtils;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.MoveCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MoveInstallOperation
extends PerformChildInstallOperation {
    private static final Logger log = Logger.getLogger(FileUtil.class);
    private final MoveCommonNativeData data;

    public MoveInstallOperation(int phase, IInstallableUnit unit, InstallContext context, MoveCommonNativeData data, PerformCommonNativeData performData) {
        super(phase, unit, context, performData);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        String src = this.performVariableSubstitutions(this.data.getSrc());
        String target = this.performVariableSubstitutions(this.data.getTarget());
        if (FileUtils.containsPattern(target)) {
            throw Util.coreException(Messages.fileutils_pattern_not_allowed, target);
        }
        if (this.data.isRename()) {
            this.handleMoveWithRename(src, target, monitor);
        } else {
            this.handleMoveWithoutRename(src, target, monitor);
        }
        return Status.OK_STATUS;
    }

    private void handleMoveWithRename(String src, String target, IProgressMonitor monitor) throws CoreException {
        File resolvedSrc = this.resolvePath(src);
        File resolvedTarget = this.resolvePath(target);
        if (FileUtils.containsPattern(src)) {
            throw Util.coreException(Messages.fileutils_pattern_not_allowed, src);
        }
        if (!resolvedSrc.exists()) {
            throw Util.coreException(Messages.fileutils_file_not_found, resolvedSrc);
        }
        if (resolvedTarget.exists()) {
            throw Util.coreException(Messages.fileutils_file_exists, resolvedTarget);
        }
        try {
            String perm = CicCommonSettings.isWindows() ? null : this.data.getPerm();
            log.debug("Moving '{0}' to '{1}'", new Object[]{resolvedSrc, resolvedTarget});
            FileUtils.move(resolvedSrc, resolvedTarget, perm, monitor);
        }
        catch (FileNotFoundException e) {
            throw Util.coreException(e, Messages.fileutils_file_not_found_general, new Object[0]);
        }
        catch (IOException e) {
            throw Util.coreException(e, Messages.fileutils_io_error_general, new Object[0]);
        }
    }

    private void handleMoveWithoutRename(String src, String target, IProgressMonitor monitor) throws CoreException {
        String permForMove;
        File resolvedSrc = this.resolvePath(src);
        File resolvedTarget = this.resolvePath(target);
        File[] srcFileList = FileUtils.getFileList(resolvedSrc.toString());
        String perm = CicCommonSettings.isWindows() ? null : this.data.getPerm();
        File dirToChmod = perm != null ? FileUtils.getTopNonExistingDir(resolvedTarget) : null;
        String string = permForMove = dirToChmod == null ? perm : null;
        if (srcFileList.length != 0 && !resolvedTarget.exists()) {
            resolvedTarget.mkdirs();
        }
        try {
            try {
                File[] fileArray = srcFileList;
                int n = srcFileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File currFile = fileArray[n2];
                    String currName = currFile.getName();
                    File targetFile = new File(resolvedTarget, currName);
                    FileUtils.move(currFile, targetFile, permForMove, monitor);
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                throw Util.coreException(e, Messages.fileutils_file_not_found_general, new Object[0]);
            }
            catch (IOException e) {
                throw Util.coreException(e, Messages.fileutils_io_error_general, new Object[0]);
            }
        }
        finally {
            if (dirToChmod != null && dirToChmod.exists()) {
                FileUtils.chmod(perm, true, false, dirToChmod);
            }
        }
    }
}

