/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IInvokeContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.AbstractExecInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Invoke;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.commonNativeAdapterData.AbstractExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.InvokeCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.utils.FileReplicator;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InvokeInstallOperation
extends AbstractExecInstallOperation {
    static final String CLASSPATH_SEPARATOR = ";";
    private static final Logger log = Logger.getLogger(InvokeInstallOperation.class);

    public InvokeInstallOperation(int phase, IInstallableUnit unit, InstallContext context, InvokeCommonNativeData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, (AbstractExecCommonNativeData)data, performData, writer);
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(this.writer), true);
        try {
            Invoke invoke = new Invoke(this.getInvokeData(), this.getClasspath());
            InvokeContext invokeContext = new InvokeContext();
            String description = this.performVariableSubstitutions(this.getInvokeData().getDescription());
            invoke.perform(invokeContext, this.getArguments(), description, printWriter, monitor);
        }
        finally {
            printWriter.flush();
            this.performLogOperations(monitor);
            this.logCompletion();
        }
        return Status.OK_STATUS;
    }

    private InvokeCommonNativeData getInvokeData() {
        return (InvokeCommonNativeData)this.getData();
    }

    private File[] getClasspath() throws CoreException {
        ArrayList<File> result = new ArrayList<File>();
        String classpath = this.performVariableSubstitutions(this.getInvokeData().getClasspath());
        String[] paths = classpath.split(CLASSPATH_SEPARATOR);
        FileReplicator javaFileReplicator = Agent.getInstance().getJavaFileReplicator();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(this.getInstallContext().getInstallLocation(), file.getPath());
            }
            if (!file.exists()) {
                log.warning(Messages.missing_classpath, new Object[]{file});
            } else {
                try {
                    File replica = javaFileReplicator.getReplica(file);
                    if (replica != null) {
                        file = replica;
                    }
                }
                catch (IOException e) {
                    throw Util.coreException(e, e.getLocalizedMessage(), new Object[0]);
                }
                result.add(file);
            }
            ++n2;
        }
        return result.toArray(new File[result.size()]);
    }

    private class InvokeContext
    implements IInvokeContext {
        private InvokeContext() {
        }

        public IAgent getAgent() {
            return Agent.getInstance();
        }

        public IProfile getProfile() {
            return InvokeInstallOperation.this.getProfile();
        }

        public IInstallableUnit getUnit() {
            return InvokeInstallOperation.this.getUnit();
        }

        public String substituteVariables(String s) throws CoreException {
            return InvokeInstallOperation.this.performVariableSubstitutions(s, true, false, AbstractVariableSubstitution.AllowAbsolutePath.FALSE);
        }
    }
}

