/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.PerformChildInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.ChmodCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.FileCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ChmodInstallOperation
extends PerformChildInstallOperation {
    private final ChmodCommonNativeData data;
    private final ICommonNativeInstallAdapter.SupplementaryLogWriter writer;

    public ChmodInstallOperation(int phase, IInstallableUnit unit, InstallContext context, ChmodCommonNativeData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, performData);
        this.data = data;
        this.writer = writer;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws AbstractVariableSubstitution.VariableSubstitutionException {
        monitor.beginTask("", 1);
        int status = PlatformUtils.chmod((String[])this.getFileList(), (String)this.data.getPerm(), (boolean)this.data.isRecursive(), (Writer)this.writer, (Writer)this.writer);
        monitor.worked(1);
        monitor.done();
        if (status != 0) {
            String exText = NLS.bind((String)Messages.error_running_chmod, (Object)status, (Object)this.getSupplementaryLogWriterFileName());
            return Statuses.ERROR.get(exText, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    protected String[] getFileList() throws AbstractVariableSubstitution.VariableSubstitutionException {
        FileCommonNativeData[] filesData = this.data.getFiles();
        String installDir = this.getInstallContext().getInstallLocation();
        String[] result = new String[filesData.length];
        int i = 0;
        while (i < filesData.length) {
            result[i] = this.performVariableSubstitutions(filesData[i].getFileText());
            Path path = new Path(result[i]);
            if (!result[i].startsWith("~") && !path.isAbsolute()) {
                result[i] = new Path(installDir).append((IPath)path).toOSString();
            }
            ++i;
        }
        return result;
    }

    private String getSupplementaryLogWriterFileName() {
        File logFile;
        if (this.writer != null && (logFile = this.writer.getFile()) != null) {
            return logFile.getAbsolutePath();
        }
        return Messages.fileutils_file_not_found_general;
    }
}

