/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASDirectoryException;
import com.ibm.websphere.product.WASProductFile;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadata;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASPlatformConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class WASDirectory {
    public static final String ID_BASE = "BASE";
    public static final String ID_EXPRESS = "EXPRESS";
    public static final String ID_ND = "ND";
    public static final String ID_NDDMZ = "NDDMZ";
    public static final String ID_PME = "PME";
    public static final String ID_WBI = "WBI";
    public static final String ID_JDK = "JDK";
    public static final String ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String ID_XD = "XD";
    public static final String ID_CLIENT = "CLIENT";
    public static final String ID_PLUGIN = "PLG";
    public static final String ID_IHS = "IHS";
    public static final String ID_WXD = "WXD";
    private String m_sWasLocation = "";
    private WASProductInfo[] m_wpiWASProductInstances = null;
    private WASMetadata wasMetadataInstance = null;
    private WASDirectoryLogger logger = null;
    private static String PRODUCT_FILE_EXTENSION = ".product";
    private static final String S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS = "libWs60ProcessManagement";
    private static final String S_URI_PATH_SEPARATOR = "/";
    private static final String S_BIN_DIR_NAME = "bin";
    private static final String S_MODULES_DIR_NAME = "modules";

    public WASDirectory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, WASDirectoryException {
        this.init(WASDirectoryHelper.getInstallRootPath());
    }

    public WASDirectory(String string) {
        this.init(string);
    }

    public WASProductInfo[] getWASProductInfoInstances() {
        return this.m_wpiWASProductInstances;
    }

    public WASProductInfo getWASProductInfo(String string) {
        if (string == null) {
            return null;
        }
        if ((string = WASDirectoryHelper.normalizedProductID(string)).equalsIgnoreCase(ID_PME)) {
            for (int i = 0; this.m_wpiWASProductInstances != null && i < this.m_wpiWASProductInstances.length; ++i) {
                String string2 = this.m_wpiWASProductInstances[i].getId();
                if (!string2.equalsIgnoreCase(ID_ND) && !string2.equalsIgnoreCase(ID_BASE) && !string2.equalsIgnoreCase(ID_EXPRESS)) continue;
                return this.m_wpiWASProductInstances[i];
            }
        } else {
            for (int i = 0; this.m_wpiWASProductInstances != null && i < this.m_wpiWASProductInstances.length; ++i) {
                if (!this.m_wpiWASProductInstances[i].getId().equalsIgnoreCase(string)) continue;
                return this.m_wpiWASProductInstances[i];
            }
        }
        return null;
    }

    public boolean isThisProductInstalled(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        return wASProductInfo != null;
    }

    public String getName(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getName();
        }
        return null;
    }

    public String getVersion(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getVersion();
        }
        return null;
    }

    public String getBuildDate(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getBuildDate();
        }
        return null;
    }

    public String getBuildLevel(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getBuildLevel();
        }
        return null;
    }

    public String getWasLocation() {
        return this.m_sWasLocation;
    }

    public static boolean refreshProductInfoCache() {
        return WASProductFile.refreshCache();
    }

    public String getOfficialArchNameFromNativeFile() {
        String string = WASPlatformConstants.getCurrentPlatformCode();
        String string2 = null;
        try {
            string2 = this.getArchFromNativeFile();
            if (string2 == null) {
                return string2;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        String string3 = WASPlatformConstants.getOfficialArchNameByOSArchKeyword(string, string2);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getArchFromNativeFile() throws IOException {
        String string = this.getWasLocation();
        String string2 = WASPlatformConstants.getCurrentPlatformCode();
        String string3 = WASDirectoryHelper.normalizeLocationNoEndingSlash(string);
        String string4 = this.getLibraryFilePathByPlatform(string2, string3);
        if (string2.equals("windows")) {
            if (string4 == null || !new File(string4).exists()) return null;
            return WASPlatformConstants.getArchByDllDecoder(string4);
        }
        if (string2.equals("aix")) {
            if (string4 == null || !new File(string4).exists()) return null;
            return WASPlatformConstants.getArchByXcoffDecoder(string4);
        }
        if (string2.equals("solaris") || string2.equals("linux")) {
            if (string4 == null || !new File(string4).exists()) return null;
            return WASPlatformConstants.getArchByElfDecoder(string4);
        }
        if (string2.equals("hpux")) {
            if (this.isThisProductInstalled(ID_IHS)) {
                if (string4 == null || !new File(string4).exists()) return null;
                String string5 = WASPlatformConstants.getArchByElfDecoder(string4);
                if (string5 == null) return "pa-risc";
                return string5;
            }
            if (string4 == null || !new File(string4).exists()) return "ia64";
            return "pa-risc";
        }
        if (string2.equals("os400")) {
            return "ppc64";
        }
        if (!string2.equals("zos")) return null;
        return "s390";
    }

    public WASComponent getInstalledComponentByName(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledComponentByName(string);
        }
        return null;
    }

    public WASComponent[] getInstalledComponentList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledComponentList();
        }
        return new WASComponent[0];
    }

    public WASMaintenancePackage[] getHistoryMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getHistoryMaintenancePackageList();
        }
        return new WASMaintenancePackage[0];
    }

    public WASMaintenancePackage getInstalledMaintenancePackageByID(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledMaintenancePackageByID(string);
        }
        return null;
    }

    public WASMaintenancePackage[] getInstalledMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledMaintenancePackageList();
        }
        return new WASMaintenancePackage[0];
    }

    public boolean isComponentInstalled(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.getInstalledComponentByName(string) != null;
    }

    public boolean isMaintenancePackageInstalled(String string) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.getInstalledMaintenancePackageByID(string) != null;
    }

    protected String getLibraryFilePathByPlatform(String string, String string2) {
        File file = null;
        String string3 = null;
        string3 = this.isThisProductInstalled(ID_IHS) ? string2 + S_URI_PATH_SEPARATOR + S_MODULES_DIR_NAME + S_URI_PATH_SEPARATOR : string2 + S_URI_PATH_SEPARATOR + S_BIN_DIR_NAME;
        file = new File(string3);
        File[] fileArray = null;
        if (string.equals("windows")) {
            if (this.isWASOrNDDMZInstalled()) {
                return string3 + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".dll";
            }
            fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".dll");
                }
            });
        } else if (string.equals("aix") || string.equals("solaris") || string.equals("linux")) {
            if (this.isWASOrNDDMZInstalled()) {
                return string3 + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".so";
            }
            fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".so");
                }
            });
        } else if (string.equals("hpux")) {
            if (this.isWASOrNDDMZInstalled()) {
                return string3 + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".sl";
            }
            fileArray = this.isThisProductInstalled(ID_IHS) ? file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".so");
                }
            }) : file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".sl");
                }
            });
        }
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0].getAbsolutePath();
        }
        return null;
    }

    protected void init(String string) {
        this.setWasLocation(new File(string).getAbsolutePath());
        this.setLogger(WASDirectoryLogger.getWASDirectoryLogger(this.m_sWasLocation));
        this.m_wpiWASProductInstances = this.parse();
    }

    protected boolean initMetadataInstance() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.wasMetadataInstance == null) {
            this.wasMetadataInstance = WASMetadata.getWASMetadataInstance(this.m_sWasLocation);
            if (this.wasMetadataInstance == null) {
                return false;
            }
        }
        return true;
    }

    protected void setLogger(WASDirectoryLogger wASDirectoryLogger) {
        this.logger = wASDirectoryLogger;
    }

    private boolean isWASOrNDDMZInstalled() {
        WASProductInfo wASProductInfo = this.getWASProductInfo(ID_ND);
        return wASProductInfo != null || (wASProductInfo = this.getWASProductInfo(ID_BASE)) != null || (wASProductInfo = this.getWASProductInfo(ID_EXPRESS)) != null || (wASProductInfo = this.getWASProductInfo(ID_NDDMZ)) != null;
    }

    private void setWasLocation(String string) {
        this.m_sWasLocation = string;
    }

    private String[] getAllProductFilesDirectlyUnderDir(String string) {
        int n;
        String[] stringArray = null;
        String[] stringArray2 = new File(string).list();
        if (stringArray2 == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(3);
        for (n = 0; n < stringArray2.length; ++n) {
            File file;
            if (!stringArray2[n].endsWith(PRODUCT_FILE_EXTENSION) || (file = new File(stringArray2[n])) == null || file.isDirectory()) continue;
            vector.add(stringArray2[n]);
        }
        if (vector.size() >= 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        return stringArray;
    }

    private WASProductInfo[] parse() {
        String string = WASDirectoryHelper.getVersionDirPath(this.getWasLocation());
        String string2 = WASDirectoryHelper.getDTDDirPath(this.getWasLocation());
        String[] stringArray = this.getAllProductFilesDirectlyUnderDir(string);
        WASProductInfo[] wASProductInfoArray = null;
        if (stringArray != null) {
            int n;
            Vector<WASProductInfo> vector = new Vector<WASProductInfo>();
            for (n = 0; n < stringArray.length; ++n) {
                WASProductFile wASProductFile = WASProductFile.getWASProductFileInstance(string2, string, stringArray[n]);
                if (wASProductFile == null) continue;
                WASProductInfo[] wASProductInfoArray2 = wASProductFile.getWASProductInfoArray();
                for (int i = 0; i < wASProductInfoArray2.length; ++i) {
                    vector.add(wASProductInfoArray2[i]);
                }
            }
            if (vector.size() >= 0) {
                wASProductInfoArray = new WASProductInfo[vector.size()];
                for (n = 0; n < wASProductInfoArray.length; ++n) {
                    wASProductInfoArray[n] = (WASProductInfo)vector.elementAt(n);
                }
            }
        }
        return wASProductInfoArray;
    }
}

