/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class UninstallCommonPakMacroResolver
extends MacroResolver {
    private static final String COMMA_VERSION = ",version";
    private static final String COMMA = ",";
    private static final String S_BOOLEAN_ATTRIBUTE_MACRO_ID = "UNINSTALLCOMMONPAK";
    private static final String className = "UninstallCommonPakMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_BOOLEAN_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String[] arg = sMacroText.split(COMMA_VERSION);
        String sPayloadid = null;
        String sProductID = null;
        String sVersionParam = null;
        if (arg.length > 0) {
            String[] arg_ = arg[0].split(COMMA);
            sPayloadid = arg_[0];
            if (arg_.length > 1) {
                sProductID = arg_[1];
            }
        }
        if (arg.length > 1) {
            sVersionParam = arg[1];
        }
        Boolean ret = Boolean.FALSE;
        try {
            ret = this.uninstallThisCommonPak(sPayloadid, sProductID, sVersionParam);
        }
        catch (IOException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
        }
        catch (SAXException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
        }
        Logr.methodReturn(className, "resolveMacro", ret.toString());
        return ret.toString();
    }

    private Boolean uninstallThisCommonPak(String sPayloadid, String sProductID, String sVersionParam) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        if (!NIFStack.isOpen()) {
            FileSystemEntry fseBackupPath = new FileSystemEntry(URIUtils.convertPathToURI(ProductPlugin.getCurrentBackupPath(), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
            NIFStack.open(fseBackupPath, this.getInstallToolkitBridge());
        }
        String sCurrentOffering = ProductPlugin.getCurrentProductOffering();
        String sCurrentOfferingVersion = ProductPlugin.getCurrentProductVersion();
        Vector vNIFStackElements = NIFStack.getAllNIFStackElements();
        int i = vNIFStackElements.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)vNIFStackElements.elementAt(i);
            String autouninstallable = nifpeThis.getParamValue("autouninstallable");
            String wasinstalledasprimary = nifpeThis.getParamValue("wasinstalledasprimary");
            String pakversion = nifpeThis.getParamValue("pakversion");
            if (wasinstalledasprimary != null && wasinstalledasprimary.equalsIgnoreCase(Boolean.TRUE.toString()) && pakversion != null && !new Boolean(autouninstallable).booleanValue()) {
                boolean isEntryUninstallingProduct;
                boolean isEntryCurrentProduct = StringUtils.isThisStringContainingThisToken(nifpeThis.getParamValue("targetproductids"), sCurrentOffering, ";");
                boolean bl = isEntryUninstallingProduct = sProductID != null && StringUtils.isThisStringContainingThisToken(nifpeThis.getParamValue("targetproductids"), sProductID, ";");
                if ((!isEntryCurrentProduct && !isEntryUninstallingProduct || sVersionParam != null && VersionUtils.compareVersions(pakversion, sCurrentOfferingVersion) != 0) && StringUtils.isThisStringContainingThisToken(nifpeThis.getParamValue("targetsubproductids"), sPayloadid, ";") && (sVersionParam == null || VersionUtils.isVersionAcceptableToTheseVersionParams(pakversion, sVersionParam))) {
                    return Boolean.FALSE;
                }
            }
            --i;
        }
        if (sVersionParam != null) {
            TreeSet<String> tsCCVersions = new TreeSet<String>();
            TreeSet<String> tsPPVersions = new TreeSet<String>();
            int i2 = vNIFStackElements.size() - 1;
            while (i2 >= 0) {
                NIFPackageEntry nifpeThis = (NIFPackageEntry)vNIFStackElements.elementAt(i2);
                String targetProductId = nifpeThis.getParamValue("targetsubproductids");
                String thisPakVersion = nifpeThis.getParamValue("pakversion");
                String thisPayloadid = nifpeThis.getParamValue("payloadid");
                if (thisPakVersion != null && thisPayloadid != null) {
                    if (nifpeThis.getParamValue("wasinstalledasprimary").equalsIgnoreCase(Boolean.TRUE.toString()) && this.fIsPrimaryPakRequireCC(targetProductId, sPayloadid) && VersionUtils.compareVersions(thisPakVersion, sCurrentOfferingVersion) < 0) {
                        tsPPVersions.add(thisPakVersion);
                    }
                    if (thisPayloadid.equals(sPayloadid) && VersionUtils.compareVersions(thisPakVersion, sCurrentOfferingVersion) < 0) {
                        tsCCVersions.add(thisPakVersion);
                    }
                }
                --i2;
            }
            if (tsCCVersions.isEmpty() && !tsPPVersions.isEmpty()) {
                return Boolean.FALSE;
            }
            if (!tsCCVersions.isEmpty() && !tsPPVersions.isEmpty() && VersionUtils.compareVersions((String)tsCCVersions.last(), (String)tsPPVersions.last()) < 0) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private boolean fIsPrimaryPakRequireCC(String targetproductid, String sPayloadid) {
        return StringUtils.isThisStringContainingThisToken(targetproductid, sPayloadid, ";");
    }
}

