/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.net.URISyntaxException;
import org.w3c.dom.Document;

public class PathToBaseNameMacroResolver
extends MacroResolver {
    private static final String S_TO_BASENAME_MACRO_ID = "NIFBASENAME";
    private static final String[] AS_REQUIRED_PARAMS = new String[0];
    private static final String className = "PathToBaseNameMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_TO_BASENAME_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        try {
            String s = this.resolveMacroRaw(sMacroID, sMacroText, documentPluginDefinitions);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        catch (IOException e) {
            String s = MacroResolver.getUnresolvedMacro(sMacroID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        catch (URISyntaxException e) {
            String s = MacroResolver.getUnresolvedMacro(sMacroID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
    }

    protected String resolveMacroRaw(String sMacroID, String sMacroText, Document documentPluginDefinitions) throws IOException, URISyntaxException {
        FileSystemEntry fseFullPath = URIUtils.convertPathToFSE(sMacroText, this.getInstallToolkitBridge());
        return fseFullPath.getEntryName();
    }
}

