/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.installtoolkitbridge;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeImpl;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class UnifiedFileIO {
    private InstallToolkitBridgeImpl m_itbi = null;
    private static UnifiedFileIO m_ufioSingleton = null;
    private static final String S_TEMP_FILE_PREFIX = ".~$";
    private static final String className = "UnifiedFileIO";

    public static UnifiedFileIO getSingleton(InstallToolkitBridgeImpl itbi) {
        if (m_ufioSingleton == null) {
            m_ufioSingleton = new UnifiedFileIO(itbi);
        }
        return m_ufioSingleton;
    }

    @Deprecated
    public OutputStream writeFile(String sFilePath, boolean fAppend) throws IOException {
        if (PlatformConstants.isCurrentPlatformOS400()) {
            throw new IOException(PakCoreMessages.PAK_CORE_S_OS400_IS_NOT_SUPPORTED);
        }
        return new FileOutputStream(new File(sFilePath), fAppend);
    }

    public File createTempDir() throws IOException {
        File fileTmpDir = File.createTempFile(S_TEMP_FILE_PREFIX, null);
        fileTmpDir.delete();
        fileTmpDir.mkdir();
        return fileTmpDir;
    }

    public Vector getFilesInDirectoryRecursive(File fileDir) {
        File[] afiles = fileDir.listFiles();
        Vector<File> vfilesReturn = new Vector<File>();
        File[] fileArray = afiles;
        int n = afiles.length;
        int n2 = 0;
        while (n2 < n) {
            File afile = fileArray[n2];
            if (afile.isDirectory()) {
                vfilesReturn.add(afile);
                vfilesReturn.addAll(this.getFilesInDirectoryRecursive(afile));
            } else {
                vfilesReturn.add(afile);
            }
            ++n2;
        }
        return vfilesReturn;
    }

    public String[] getPartitionNames() throws InstallToolkitBridgeException {
        return this.m_itbi.getPartitionNames();
    }

    public String getPartitionName(String sPath, String[] asPartitionNames) throws InstallToolkitBridgeException {
        try {
            String sPathToUseForQuery = new File(sPath).getCanonicalPath();
            return this.m_itbi.getPartitionName(sPathToUseForQuery, asPartitionNames);
        }
        catch (IOException e) {
            Logr.warn(className, "getPartitionName", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    public long getPartitionFreeSpace(String sPartitionName) throws InstallToolkitBridgeException {
        return this.m_itbi.getPartitionFreeSpace(sPartitionName);
    }

    public void setPermissions(String sFilePath, int nPermissions) throws InstallToolkitBridgeException {
        this.m_itbi.setPermissions(sFilePath, nPermissions);
    }

    public int getPermissions(String sFilePath) throws InstallToolkitBridgeException {
        return this.m_itbi.getPermissions(sFilePath);
    }

    private UnifiedFileIO(InstallToolkitBridgeImpl itbi) {
        this.m_itbi = itbi;
    }
}

