/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProcessEnvironment {
    private static Hashtable m_hashtableEnvironment = null;
    private static final String S_EQUALS = "=";
    private static final String S_EOLN = "\n";

    public static String getEnvironmentVariableValue(String sName) {
        ProcessEnvironment.loadEnvironmentMap();
        String sPlatformSpecificEnvironmentVariableName = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(sName);
        Object oValue = m_hashtableEnvironment.get(sPlatformSpecificEnvironmentVariableName);
        if (oValue != null) {
            return oValue.toString();
        }
        return null;
    }

    private static void loadEnvironmentMap() {
        if (m_hashtableEnvironment == null) {
            Map<String, String> envMap = System.getenv();
            m_hashtableEnvironment = new Hashtable();
            Set<String> keys = envMap.keySet();
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                String val = envMap.get(key).toString();
                key = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(key);
                m_hashtableEnvironment.put(key, val);
            }
        }
    }

    public static String dumpEnvironment() {
        ProcessEnvironment.loadEnvironmentMap();
        Enumeration enumerationAllVariables = m_hashtableEnvironment.keys();
        String sReturn = new String();
        while (enumerationAllVariables.hasMoreElements()) {
            String sKeyThis = enumerationAllVariables.nextElement().toString();
            sReturn = String.valueOf(sReturn) + sKeyThis + S_EQUALS + m_hashtableEnvironment.get(sKeyThis).toString() + S_EOLN;
        }
        return sReturn;
    }

    private static String convertThisEnvironmentVariableNameToUpperCaseIfWindows(String sEnvironmentVariableName) {
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return sEnvironmentVariableName.toUpperCase();
        }
        return sEnvironmentVariableName;
    }
}

