/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.ArrayUtils;
import com.ibm.ws.pak.internal.utils.filesystems.ProcessEnvironment;
import java.io.IOException;
import java.util.regex.Pattern;

public class PlatformConstants {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    public static final int N_OS400_REMOTE = 8;
    private static final int N_UNDEFINED = -1;
    private static int nPlatformNumber = -1;
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_JAVA_OS_VERSION_PROPERTY = "os.version";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_WINDOWS_XP = "windows xp";
    private static final String S_WINDOWS_2000 = "windows 2000";
    private static final String S_WINDOWS_SERVER_2003 = "windows server 2003";
    private static final String S_WINDOWS_VISTA_VERSION = "6.0";
    private static final String[] AS_NETSCAPE = new String[]{"netscape"};
    private static final String[] AS_MOZILLA = new String[]{"mozilla"};
    private static final String[] AS_FIREFOX = new String[]{"firefox"};
    private static final String[] AS_IEXPLORE = new String[]{"cmd.exe", "/c", "\"start iexplore\""};
    private static final String[] AS_NONE = new String[]{""};
    private static final String[] AS_REDHATLINUX = new String[]{"htmlview"};
    private static final String[] AS_SUSELINUX = new String[]{"exo-open", "--launch", "WebBrowser"};
    private static final String[] AS_SHELL_EXEC_WIN = new String[]{"cmd.exe", "/c"};
    private static final String[] AS_SHELL_EXEC_UNIX = new String[]{"sh", "-c"};
    private static final String[] AS_SHELL_EXEC_OS400 = new String[]{"sh", "-c"};
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_EMPTY = "";
    private static final String S_DOLLAR = "$";
    private static final String S_PERCENTAGE = "%";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_START = "{";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_STOP = "}";
    private static final String S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES = "^.*\\s.*$";
    private static final char C_QUOTE = '\"';
    private static final char C_SPACE = ' ';
    private static final String S_WINDOWS_FS_PATH_SEPARATOR = "\\";
    private static final String S_UNIX_FS_PATH_SEPARATOR = "/";
    private static final String S_OS400_FS_PATH_SEPARATOR = "/";
    private static final String[] AS_WINOSNAME_VERSION_MAPPING = new String[]{"Windows 2000;5.0", "Windows XP;5.1", "Windows 2003;5.2"};

    public static boolean isOS400Install() {
        if (PlatformConstants.isCurrentPlatformOS400()) {
            return true;
        }
        return NIFConstants.getProperty("com.ibm.was.install") != null && (NIFConstants.getProperty("com.ibm.was.install").equals("os400Native") || NIFConstants.getProperty("com.ibm.was.install").equals("os400Remote"));
    }

    public static boolean isOS400NativeInstall() {
        if (PlatformConstants.isCurrentPlatformOS400()) {
            return true;
        }
        return NIFConstants.getProperty("com.ibm.was.install") != null && NIFConstants.getProperty("com.ibm.was.install").equals("os400Native");
    }

    public static boolean isOS400RemoteInstall() {
        return NIFConstants.getProperty("com.ibm.was.install") != null && NIFConstants.getProperty("com.ibm.was.install").equals("os400Remote");
    }

    public static String[] getWebBrowserForThisPlatform() {
        String[] asBrowser = null;
        switch (PlatformConstants.getCurrentPlatform()) {
            case 1: 
            case 2: 
            case 3: {
                asBrowser = AS_NETSCAPE;
                break;
            }
            case 4: {
                asBrowser = AS_MOZILLA;
                break;
            }
            case 5: {
                asBrowser = AS_IEXPLORE;
                break;
            }
            case 6: {
                asBrowser = AS_NONE;
                break;
            }
            case 7: {
                asBrowser = AS_NONE;
                break;
            }
            default: {
                asBrowser = AS_NETSCAPE;
            }
        }
        return asBrowser;
    }

    public static boolean launchWebBrowserForThisPlatform(String url) {
        String[] browser;
        if (PlatformConstants.isCurrentPlatformLinux()) {
            browser = AS_REDHATLINUX;
            if (PlatformConstants.launchWebBrowserWithURL(browser, url)) {
                return true;
            }
            browser = AS_SUSELINUX;
            if (PlatformConstants.launchWebBrowserWithURL(browser, url)) {
                return true;
            }
        }
        return PlatformConstants.launchWebBrowserWithURL(browser = AS_FIREFOX, url);
    }

    public static boolean launchWebBrowserWithURL(String[] browser, String url) {
        String[] fullarg = new String[browser.length + 1];
        int i = 0;
        while (i < browser.length) {
            fullarg[i] = browser[i];
            ++i;
        }
        fullarg[fullarg.length - 1] = url;
        try {
            Runtime runtimeobj = Runtime.getRuntime();
            runtimeobj.exec(fullarg);
        }
        catch (IOException ioe2) {
            return false;
        }
        return true;
    }

    public static String[] getShellExecPrefixForCurrentPlatform() {
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            return AS_SHELL_EXEC_UNIX;
        }
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return AS_SHELL_EXEC_WIN;
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            return AS_SHELL_EXEC_OS400;
        }
        return AS_EMPTY;
    }

    public static boolean isCurrentPlatformUNIX() {
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 1 || nCurrentPlatform == 2 || nCurrentPlatform == 3 || nCurrentPlatform == 4 || nCurrentPlatform == 6;
    }

    public static boolean isCurrentPlatformLinux() {
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 4;
    }

    public static boolean isCurrentPlatformAIX() {
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 1;
    }

    public static boolean isCurrentPlatformHPUnix() {
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 2;
    }

    public static boolean isCurrentPlatformWindows() {
        return PlatformConstants.getCurrentPlatform() == 5;
    }

    public static boolean isCurrentPlatformWindowsVista() {
        String sOSVersion;
        return PlatformConstants.isCurrentPlatformWindows() && (sOSVersion = System.getProperty(S_JAVA_OS_VERSION_PROPERTY)).trim().startsWith(S_WINDOWS_VISTA_VERSION);
    }

    public static boolean isCurrentPlatformWindowsServer2003() {
        String sOSName;
        return PlatformConstants.getCurrentPlatform() == 5 && (sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase()).indexOf(S_WINDOWS_SERVER_2003) != -1;
    }

    public static boolean isCurrentPlatformWindows2000orXP() {
        if (PlatformConstants.getCurrentPlatform() == 5) {
            String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
            if (sOSName.indexOf(S_WINDOWS_XP) != -1) {
                return true;
            }
            return sOSName.indexOf(S_WINDOWS_2000) != -1;
        }
        return false;
    }

    public static boolean isCurrentPlatformOS400() {
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 7;
    }

    public static String convertExecArrayToPlatformSpecificExecCommand(String[] asExecArray) {
        String[] asExecArrayCopy = new String[asExecArray.length];
        ArrayUtils.cloneArray(asExecArrayCopy, asExecArray);
        PlatformConstants.quoteStringsWithSpacesInTheArray(asExecArrayCopy);
        return ArrayUtils.join(S_SPACE, asExecArrayCopy);
    }

    public static int getCurrentPlatform() {
        if (nPlatformNumber != -1) {
            return nPlatformNumber;
        }
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            nPlatformNumber = 1;
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            nPlatformNumber = 2;
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            nPlatformNumber = 3;
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            nPlatformNumber = 4;
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            nPlatformNumber = 5;
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
            nPlatformNumber = 6;
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            nPlatformNumber = 7;
            return 7;
        }
        nPlatformNumber = 0;
        return 0;
    }

    public static String getCurrentPlatformCode() {
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            return "aix";
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            return "hpux";
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            return "solaris";
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            return "linux";
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            return "windows";
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
            return "zos";
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            return "os400";
        }
        return "NA";
    }

    public static int getTargetPlatform() {
        int nTargetPlatform = PlatformConstants.getCurrentPlatform();
        if (PlatformConstants.isOS400RemoteInstall()) {
            nTargetPlatform = 8;
        }
        return nTargetPlatform;
    }

    public static String getTargetPlatformCode() {
        String sTargetPlatform = PlatformConstants.getCurrentPlatformCode();
        if (PlatformConstants.isOS400RemoteInstall()) {
            sTargetPlatform = "os400Remote";
        }
        return sTargetPlatform;
    }

    public static String getEnvironmentVariableValue(String sName) {
        return ProcessEnvironment.getEnvironmentVariableValue(sName);
    }

    public static String convertToShellVariable(String sName) {
        if (PlatformConstants.isCurrentPlatformUNIX() || PlatformConstants.isCurrentPlatformOS400()) {
            return "${" + sName + S_UNIX_SHELL_VARIABLE_BRACKET_STOP;
        }
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return S_PERCENTAGE + sName + S_PERCENTAGE;
        }
        return sName;
    }

    public static String convertToShellParam(String sParam) {
        if (sParam.matches(S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES) && !PlatformConstants.isQuoted(sParam)) {
            String sReturn = S_QUOTE + sParam + S_QUOTE;
            return sReturn;
        }
        return sParam;
    }

    public static String getCurrentOSFSPathSeparator() {
        if (PlatformConstants.isCurrentPlatformOS400()) {
            return "/";
        }
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            return "/";
        }
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return S_WINDOWS_FS_PATH_SEPARATOR;
        }
        return "/";
    }

    public static String getWindowsOSName(String sVersion) {
        String[] asWinOSNameVersionMapping;
        String[] stringArray = asWinOSNameVersionMapping = AS_WINOSNAME_VERSION_MAPPING;
        int n = asWinOSNameVersionMapping.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String sWinOSName = element.substring(0, element.indexOf(";"));
            String sVersionThis = element.substring(element.indexOf(";") + 1);
            if (sVersionThis.equals(sVersion)) {
                return sWinOSName;
            }
            ++n2;
        }
        return S_EMPTY;
    }

    private static void quoteStringsWithSpacesInTheArray(String[] asStringArrayToModify) {
        int i = 0;
        while (i < asStringArrayToModify.length) {
            asStringArrayToModify[i] = PlatformConstants.convertToShellParam(asStringArrayToModify[i]);
            ++i;
        }
    }

    private static boolean isQuoted(String sToCheck) {
        boolean fQuoted = false;
        int i = 0;
        while (i < sToCheck.length()) {
            if (sToCheck.charAt(i) == '\"') {
                boolean bl = fQuoted = !fQuoted;
            }
            if (sToCheck.charAt(i) == ' ' && !fQuoted) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

