/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPFileOperation;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemNotSupportedException;
import com.ibm.ws.pak.internal.utils.filesystems.ZIPFileSystem;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ZIPFileOperationController {
    private static InstallToolkitBridge m_itb = null;
    private static Hashtable m_htTargetFileToOperationsMaps = null;
    private static final String className = "ZIPFileOperationController";

    public static void initialize(InstallToolkitBridge itb) {
        m_itb = itb;
        m_htTargetFileToOperationsMaps = new Hashtable();
    }

    public static void reset() {
        m_itb = null;
        m_htTargetFileToOperationsMaps = null;
    }

    public static void add(URI uriTargetFile, String sEntryName, String sOperation, URI uriSourceFile, String sSourceEntryName) {
        Vector<ZIPFileOperation> vfileoperation = (Vector<ZIPFileOperation>)m_htTargetFileToOperationsMaps.get(uriTargetFile);
        if (vfileoperation == null) {
            vfileoperation = new Vector<ZIPFileOperation>();
        }
        vfileoperation.add(new ZIPFileOperation(uriTargetFile, sEntryName, sOperation, uriSourceFile, sSourceEntryName));
        m_htTargetFileToOperationsMaps.put(uriTargetFile, vfileoperation);
    }

    public static void performAllZIPOperations() throws IOException, ParserConfigurationException, SAXException, IllegalAccessException, InstantiationException, FileSystemNotSupportedException, ClassNotFoundException {
        Enumeration enuTargetFiles = m_htTargetFileToOperationsMaps.keys();
        while (enuTargetFiles.hasMoreElements()) {
            URI uriTargetFileThis = (URI)enuTargetFiles.nextElement();
            Vector vZIPFileOperations = (Vector)m_htTargetFileToOperationsMaps.get(uriTargetFileThis);
            ZIPFileSystem zipfsThis = (ZIPFileSystem)FileSystem.getFileSystem(uriTargetFileThis, m_itb);
            try {
                zipfsThis.performAllZIPOperationsForThisTargetFile(uriTargetFileThis, vZIPFileOperations);
            }
            catch (IOException e) {
                Logr.warn(className, "performAllZIPOperations", e.getMessage(), e);
                throw new NIFFileActionIOException(e.getMessage(), ZIPFileOperationController.getIOExceptionDescription(uriTargetFileThis.getPath()), uriTargetFileThis.getPath());
            }
        }
    }

    private static String getIOExceptionDescription(String sTarget) {
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_ZIPFILEOPERATION_DESCRIPTION, (Object)sTarget);
    }
}

