/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ReplaceSymLinkFileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Hashtable;

public class AddSymLinkFileActionPlugin
extends ReplaceSymLinkFileActionPlugin {
    private static final String S_FILE_ACTION_ID = "addsymlink";
    private static final String S_INVERSE_FILE_ACTION_ID = "removesymlink";
    private static final String S_INVALID_CALL_ERROR = "This function should never have been called on this class.";
    private static final String className = "AddSymLinkFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        FileSystemEntry fseTo = this.getCurrentFileSystemEntry(hashtableFileDetails);
        if (fseTo.exists()) {
            super.execute(hashtableFileDetails);
            return;
        }
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseTo);
            }
            return;
        }
        String sLinkTo = fseTo.getURI().getPath();
        String sLinkTarget = hashtableFileDetails.get("symbolic-link").toString();
        try {
            Logr.debug("AddSymLinkFileAction - sLinkTo :" + sLinkTo + " sLinkTarget: " + sLinkTarget);
            fseTo.linkTo(sLinkTarget);
        }
        catch (IOException e) {
            Logr.warn(className, "execute", e.getMessage(), e);
            throw new NIFFileActionIOException(e.getMessage(), this.getIOExceptionDescription(sLinkTo, sLinkTarget), sLinkTo);
        }
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) throws IOException {
        throw new IOException(S_INVALID_CALL_ERROR);
    }

    @Override
    protected Hashtable getInverseFileAction(Hashtable hashtableFileDetails) throws IOException {
        if (this.getCurrentFileSystemEntry(hashtableFileDetails).exists()) {
            return super.getInverseFileAction(hashtableFileDetails);
        }
        Hashtable<String, String> hashtableReturn = new Hashtable<String, String>(hashtableFileDetails);
        hashtableReturn.put("installoperation", S_INVERSE_FILE_ACTION_ID);
        return hashtableReturn;
    }

    private String getIOExceptionDescription(String sLinkFrom, String sLinkTo) {
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_ADDSYMLINKFILEACTION_IOEXCEPTIONDESCRIPTION, (Object)sLinkFrom, (Object)sLinkTo);
    }
}

