/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.events;

import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.events.ComponentActionFileEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import java.util.Hashtable;

public class ComponentActionEvent
extends NIFEvent {
    public static final int N_COMPONENT_ACTION_EVENT_TYPE = 2;
    public static final String S_COMPONENT_ACTION_EVENT_COMPONENT_FILE_ACTION = "COMPONENT_FILE_ACTION_EVENT";
    public static final String S_COMPONENT_ACTION_EVENT_COMPONENT_NAME = "COMPONENT_NAME";
    public static final String S_COMPONENT_ACTION_EVENT_COMPONENT_NUMBER = "COMPONENT_NUMBER";
    public static final String S_COMPONENT_ACTION_EVENT_TOTAL_COMPONENTS = "TOTAL_COMPONENTS";
    public static final String S_COMPONENT_ACTION_EVENT_BACKUP_FLAG = "BACKUP_FLAG";
    private final Hashtable m_hashtableEventProperties = new Hashtable();

    public ComponentActionEvent(String sComponentName, int nCurrentComponentNumber, int nTotalComponents, boolean fIsComponentBeingBackedUp, ComponentActionFileEvent cafeThisEvent) {
        this.m_hashtableEventProperties.put(S_COMPONENT_ACTION_EVENT_COMPONENT_NAME, sComponentName);
        this.m_hashtableEventProperties.put(S_COMPONENT_ACTION_EVENT_COMPONENT_NUMBER, new Integer(nCurrentComponentNumber));
        this.m_hashtableEventProperties.put(S_COMPONENT_ACTION_EVENT_TOTAL_COMPONENTS, new Integer(nTotalComponents));
        this.m_hashtableEventProperties.put(S_COMPONENT_ACTION_EVENT_BACKUP_FLAG, new Boolean(fIsComponentBeingBackedUp));
        if (cafeThisEvent != null) {
            this.m_hashtableEventProperties.put(S_COMPONENT_ACTION_EVENT_COMPONENT_FILE_ACTION, cafeThisEvent);
        }
    }

    @Override
    public int getEventType() {
        return 2;
    }

    @Override
    public Hashtable getEventProperties() {
        return this.m_hashtableEventProperties;
    }

    @Override
    public Object getEventProperty(Object oPropertyKey) {
        return this.m_hashtableEventProperties.get(oPropertyKey);
    }

    public String getComponentName() {
        return StringUtils.returnObjectToStringOrNullIfObjectIsNull(this.getEventProperty(S_COMPONENT_ACTION_EVENT_COMPONENT_NAME));
    }

    public int getCurrentComponentNumber() {
        Integer integerCurrentComponentNumber = (Integer)this.getEventProperty(S_COMPONENT_ACTION_EVENT_COMPONENT_NUMBER);
        if (integerCurrentComponentNumber != null) {
            return integerCurrentComponentNumber;
        }
        return -1;
    }

    public int getTotalComponents() {
        Integer integerTotalComponents = (Integer)this.getEventProperty(S_COMPONENT_ACTION_EVENT_TOTAL_COMPONENTS);
        if (integerTotalComponents != null) {
            return integerTotalComponents;
        }
        return -1;
    }

    public boolean isComponentBeingBackedUp() {
        Boolean booleanBackupFlag = (Boolean)this.getEventProperty(S_COMPONENT_ACTION_EVENT_BACKUP_FLAG);
        if (booleanBackupFlag != null) {
            return booleanBackupFlag;
        }
        return false;
    }

    public ComponentActionFileEvent getComponentActionFileEvent() {
        return (ComponentActionFileEvent)this.getEventProperty(S_COMPONENT_ACTION_EVENT_COMPONENT_FILE_ACTION);
    }
}

