/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.WebSphereOSArchUtils;
import com.ibm.ws.pak.internal.utils.componentactions.UpdateComponent;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;

public class UpdateComponentOnPlatform
extends UpdateComponent {
    protected final String S_PERIOD = "[.]";
    protected final String[] PLATFORMCONSTANTS = new String[]{"windows", "aix", "hpux", "linux", "solaris", "unix", "zos", "os400"};

    @Override
    public boolean isRequiredFeaturePresent() throws IOException {
        String component = this.getParamValue("component");
        if (this.isPlatformPresent(component)) {
            boolean isFeaturePresent = super.isRequiredFeaturePresent();
            if (!isFeaturePresent) {
                String sWarningMessage = PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_SKIPPINGCOMPONENTACTION_MESSAGE_KEY, (Object[])new String[]{this.getID(), this.getParamValue("component"), this.getParamValue("featureids")});
                Logr.debug(sWarningMessage);
            }
            return isFeaturePresent;
        }
        Logr.debug(String.valueOf(component) + " is not applicable to the current platform.");
        return false;
    }

    protected boolean isPlatformPresent(String component) throws IOException {
        boolean result = false;
        if (!this.isThisComponentNative(component)) {
            return true;
        }
        result = WebSphereOSArchUtils.getPlatform().matchOS(this.getComponentOS(component)) && WebSphereOSArchUtils.getPlatform().matchArch(this.getComponentArch(component));
        return result;
    }

    protected boolean isThisComponentNative(String component) {
        String[] array = component.split("[.]");
        if (array.length >= 3) {
            String sStringToCompare = array[array.length - 2];
            String[] stringArray = this.PLATFORMCONSTANTS;
            int n = this.PLATFORMCONSTANTS.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(sStringToCompare)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected String getComponentOS(String component) {
        String[] array = component.split("[.]");
        if (array.length >= 3) {
            return array[array.length - 2];
        }
        return "";
    }

    protected String getComponentArch(String component) {
        String[] array = component.split("[.]");
        if (array.length >= 3) {
            return array[array.length - 1];
        }
        return "";
    }
}

