/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.utils.componentactions.ComponentActionParams;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentFileActions;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentLocater;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentNotFoundException;
import com.ibm.ws.pak.internal.utils.componentactions.FilesListParser;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import java.io.IOException;

public class ComponentDeployAction {
    private ComponentActionParams m_caps = null;

    public ComponentDeployAction(ComponentActionParams caps) {
        this.m_caps = caps;
    }

    public void execute() throws IOException {
        ComponentFileActions cfaThisComponent = this.getFileActionsForAllFilesInThisComponent();
        cfaThisComponent.setPublishFileEventsFlag(this.m_caps.isPerFileUpdateEventNeeded());
        cfaThisComponent.execute(this.m_caps.isBackupMode());
        if (this.m_caps.isBackupMode()) {
            this.createInverseFilesListFileInTheComponentBackupRepository();
        }
    }

    private FileSystemEntry getSourceRepositoryForThisComponent() throws ComponentNotFoundException {
        return ComponentLocater.getRepositoryPathForThisComponent(this.m_caps.getComponentName(), this.m_caps.getSourceRepositoryPaths(), this.m_caps.getInstallToolkitBridge());
    }

    private void createInverseFilesListFileInTheComponentBackupRepository() throws IOException {
        try {
            FilesListParser flpThisComponent = new FilesListParser(this.getComponentActionParamsForFilesListParser());
            String sInverseFilesListFile = flpThisComponent.getInverseFilesListForThisComponent();
            FileSystemEntry fseInverseFilesList = flpThisComponent.getInverseFilesListFileForThisComponent();
            fseInverseFilesList.writeUTF8(sInverseFilesListFile, false);
        }
        catch (ComponentNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    private ComponentFileActions getFileActionsForAllFilesInThisComponent() throws IOException {
        try {
            FilesListParser flpThisComponent = new FilesListParser(this.getComponentActionParamsForFilesListParser());
            return flpThisComponent.getComponentFileActionsForThisComponent();
        }
        catch (ComponentNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    private ComponentActionParams getComponentActionParamsForFilesListParser() throws ComponentNotFoundException {
        ComponentActionParams capsForFileListParser = new ComponentActionParams(this.m_caps);
        capsForFileListParser.setSourceRepositoryPaths(new FileSystemEntry[]{this.getSourceRepositoryForThisComponent()});
        return capsForFileListParser;
    }
}

