/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtils {
    private static final Pattern PATTERN_VERSION_PARAM = Pattern.compile("^([\\<\\>=]+)(\\d+(?:\\.\\d+)*)$");
    private static final Pattern PATTERN_VERSION = Pattern.compile("^(\\d+)(?:\\.\\d+)*$");
    private static final int N_OPERATOR_GROUP = 1;
    private static final int N_VERSION_NUMBER_GROUP = 2;
    private static final String S_EQUALS = "=";
    private static final String S_GREATER_THAN = ">";
    private static final String S_LESS_THAN = "<";
    private static final String S_GREATER_THAN_OR_EQUAL_TO = ">=";
    private static final String S_LESS_THAN_OR_EQUAL_TO = "<=";
    private static final String S_TEXT_EQUALS = "eq";
    private static final String S_TEXT_GREATER_THAN = "gt";
    private static final String S_TEXT_LESS_THAN = "lt";
    private static final String S_TEXT_GREATER_THAN_OR_EQUAL_TO = "gte";
    private static final String S_TEXT_LESS_THAN_OR_EQUAL_TO = "lte";
    private static final String S_SEMICOLON = ";";
    private static final String S_DOT = ".";
    private static final String S_ZERO = "0";
    private static final String S_INVALID_VERSION_NUMBER = " is not a valid version number.";

    public static boolean isVersionAcceptableToTheseVersionParams(String sVersionFound, String sVersionParams) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(sVersionParams, S_SEMICOLON);
        while (st.hasMoreTokens()) {
            String sVersionParamThis = st.nextToken();
            if (VersionUtils.isThisVersionAcceptableToThisVersionParam(sVersionFound, sVersionParamThis)) continue;
            return false;
        }
        return true;
    }

    public static int compareVersions(String sVersionOne, String sVersionTwo) throws NumberFormatException {
        if (!PATTERN_VERSION.matcher(sVersionOne).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionOne) + S_INVALID_VERSION_NUMBER);
        }
        if (!PATTERN_VERSION.matcher(sVersionTwo).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionTwo) + S_INVALID_VERSION_NUMBER);
        }
        StringTokenizer stVersionOne = new StringTokenizer(sVersionOne, S_DOT);
        StringTokenizer stVersionTwo = new StringTokenizer(sVersionTwo, S_DOT);
        while (stVersionOne.hasMoreTokens() || stVersionTwo.hasMoreTokens()) {
            int nVersionTwoDigitThis;
            String sVersionOneDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionOne);
            String sVersionTwoDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionTwo);
            int nVersionOneDigitThis = Integer.parseInt(sVersionOneDigitThis);
            if (nVersionOneDigitThis == (nVersionTwoDigitThis = Integer.parseInt(sVersionTwoDigitThis))) continue;
            if (nVersionOneDigitThis > nVersionTwoDigitThis) {
                return 1;
            }
            if (nVersionOneDigitThis >= nVersionTwoDigitThis) continue;
            return -1;
        }
        return 0;
    }

    public static int compareVersions(String sVersionOne, String sVersionTwo, String versionPattern, String delim) throws NumberFormatException {
        if (!Pattern.compile(versionPattern).matcher(sVersionOne).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionOne) + S_INVALID_VERSION_NUMBER);
        }
        if (!Pattern.compile(versionPattern).matcher(sVersionTwo).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionTwo) + S_INVALID_VERSION_NUMBER);
        }
        StringTokenizer stVersionOne = new StringTokenizer(sVersionOne, delim);
        StringTokenizer stVersionTwo = new StringTokenizer(sVersionTwo, delim);
        while (stVersionOne.hasMoreTokens() || stVersionTwo.hasMoreTokens()) {
            int nVersionTwoDigitThis;
            String sVersionOneDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionOne);
            String sVersionTwoDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionTwo);
            int nVersionOneDigitThis = Integer.parseInt(sVersionOneDigitThis);
            if (nVersionOneDigitThis == (nVersionTwoDigitThis = Integer.parseInt(sVersionTwoDigitThis))) continue;
            if (nVersionOneDigitThis > nVersionTwoDigitThis) {
                return 1;
            }
            if (nVersionOneDigitThis >= nVersionTwoDigitThis) continue;
            return -1;
        }
        return 0;
    }

    public static int compareVersionsUpToDigit(String sVersionOne, String sVersionTwo, int nDigitPosition) {
        if (!PATTERN_VERSION.matcher(sVersionOne).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionOne) + S_INVALID_VERSION_NUMBER);
        }
        if (!PATTERN_VERSION.matcher(sVersionTwo).matches()) {
            throw new NumberFormatException(String.valueOf(sVersionTwo) + S_INVALID_VERSION_NUMBER);
        }
        StringTokenizer stVersionOne = new StringTokenizer(sVersionOne, S_DOT);
        StringTokenizer stVersionTwo = new StringTokenizer(sVersionTwo, S_DOT);
        int nNumDigitsVersionOne = stVersionOne.countTokens();
        int nNumDigitsVersionTwo = stVersionTwo.countTokens();
        if (nDigitPosition > nNumDigitsVersionOne || nDigitPosition > nNumDigitsVersionTwo) {
            nDigitPosition = Math.max(nNumDigitsVersionOne, nNumDigitsVersionTwo);
        }
        int i = 0;
        while (i < nDigitPosition) {
            int nVersionTwoDigitThis;
            String sVersionOneDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionOne);
            String sVersionTwoDigitThis = VersionUtils.getNextTokenOrZeroIfNoNextToken(stVersionTwo);
            int nVersionOneDigitThis = Integer.parseInt(sVersionOneDigitThis);
            if (nVersionOneDigitThis != (nVersionTwoDigitThis = Integer.parseInt(sVersionTwoDigitThis))) {
                if (nVersionOneDigitThis > nVersionTwoDigitThis) {
                    return 1;
                }
                if (nVersionOneDigitThis < nVersionTwoDigitThis) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }

    public static boolean isTheThirdDigitGreaterThanOrEqualToOne(String sVersion) {
        return VersionUtils.isTheNthDigitGreaterThanOrEqualToOne(sVersion, 3);
    }

    public static boolean isTheFourthDigitGreaterThanOrEqualToOne(String sVersion) {
        return VersionUtils.isTheNthDigitGreaterThanOrEqualToOne(sVersion, 4);
    }

    public static boolean isTheNthDigitGreaterThanOrEqualToOne(String sVersion, int nth) {
        StringTokenizer st = new StringTokenizer(sVersion, S_DOT);
        int counter = 1;
        while (counter < nth) {
            VersionUtils.getNextTokenOrZeroIfNoNextToken(st);
            ++counter;
        }
        String sDigitTarget = VersionUtils.getNextTokenOrZeroIfNoNextToken(st);
        int nTarget = Integer.parseInt(sDigitTarget);
        return nTarget >= 1;
    }

    private static boolean isThisVersionAcceptableToThisVersionParam(String sVersionFound, String sVersionParamThis) throws NumberFormatException {
        Matcher matcherVersion = PATTERN_VERSION_PARAM.matcher(sVersionParamThis);
        if (!matcherVersion.matches()) {
            return false;
        }
        String sOperator = matcherVersion.group(1);
        String sVersionIn = matcherVersion.group(2);
        int nComparisonResult = VersionUtils.compareVersions(sVersionFound, sVersionIn);
        if (sOperator.equals(S_EQUALS) && nComparisonResult == 0) {
            return true;
        }
        if (sOperator.equals(S_GREATER_THAN) && nComparisonResult > 0) {
            return true;
        }
        if (sOperator.equals(S_LESS_THAN) && nComparisonResult < 0) {
            return true;
        }
        if (sOperator.equals(S_GREATER_THAN_OR_EQUAL_TO) && (nComparisonResult > 0 || nComparisonResult == 0)) {
            return true;
        }
        return sOperator.equals(S_LESS_THAN_OR_EQUAL_TO) && (nComparisonResult < 0 || nComparisonResult == 0);
    }

    private static String getNextTokenOrZeroIfNoNextToken(StringTokenizer st) {
        try {
            if (st.hasMoreTokens()) {
                return st.nextToken();
            }
            return S_ZERO;
        }
        catch (NoSuchElementException e) {
            return S_ZERO;
        }
    }

    public static int getVersionParamsTokenCount(String sVersionParams) {
        StringTokenizer st = new StringTokenizer(sVersionParams, S_SEMICOLON);
        return st.countTokens();
    }

    public static String getVersionParamFromVersionParams(String sVersionParams, int iVersionParamIndex) {
        String sVersionParamThis = null;
        StringTokenizer st = new StringTokenizer(sVersionParams, S_SEMICOLON);
        int i = 1;
        while (i <= iVersionParamIndex) {
            sVersionParamThis = st.nextToken();
            ++i;
        }
        return sVersionParamThis;
    }

    public static String getVersionParamOperator(String sVersionParam) {
        Matcher matcherVersion = PATTERN_VERSION_PARAM.matcher(sVersionParam);
        if (!matcherVersion.matches()) {
            return null;
        }
        String sOperator = matcherVersion.group(1);
        return sOperator;
    }

    public static String getVersionParamVersion(String sVersionParam) {
        Matcher matcherVersion = PATTERN_VERSION_PARAM.matcher(sVersionParam);
        if (!matcherVersion.matches()) {
            return null;
        }
        String sVersionIn = matcherVersion.group(2);
        return sVersionIn;
    }

    public static String convertSymbolicOperatorToString(String sOperator) {
        if (sOperator.equals(S_EQUALS)) {
            return S_TEXT_EQUALS;
        }
        if (sOperator.equals(S_GREATER_THAN)) {
            return S_TEXT_GREATER_THAN;
        }
        if (sOperator.equals(S_LESS_THAN)) {
            return S_TEXT_LESS_THAN;
        }
        if (sOperator.equals(S_GREATER_THAN_OR_EQUAL_TO)) {
            return S_TEXT_GREATER_THAN_OR_EQUAL_TO;
        }
        if (sOperator.equals(S_LESS_THAN_OR_EQUAL_TO)) {
            return S_TEXT_LESS_THAN_OR_EQUAL_TO;
        }
        return S_TEXT_GREATER_THAN_OR_EQUAL_TO;
    }
}

