/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.install.NIFInstallPlugin;
import com.ibm.ws.pak.internal.install.NIFPackageApplicationPlugin;
import com.ibm.ws.pak.internal.install.SatelliteApplicationPlugin;
import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.events.NIFUninstallPackageEvent;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.InstallToolkitBridgeMacroResolver;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NIFInstallListOfPackagesPlugin
extends NIFInstallPlugin {
    private static String S_PARAM_SORTEDMAINTENANCEPACKAGEURIS = "sortedMaintenancePackageURIs";
    private static String S_PARAM_CONDITION = "condition";
    private static String S_PARAM_SELECTEDMAINTENANCEPACKAGESKEY = "selectedmaintenancepackageskey";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{S_PARAM_SORTEDMAINTENANCEPACKAGEURIS};
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{S_PARAM_CONDITION, S_PARAM_SELECTEDMAINTENANCEPACKAGESKEY};
    private static String S_EMPTY = "";
    private static final String S_DEFAULT_SELECTEDMAINTENANCEPACKAGESKEY = "wsglobalinstallconstantsProductBean.selectedMaintenancePackages";
    private static final String className = "NIFInstallListOfPackagesPlugin";

    @Override
    public void init() {
        Logr.methodEntry(className, "init");
        super.init();
        Logr.methodExit(className, "init");
    }

    @Override
    public int execute() throws NIFException {
        Logr.methodEntry(className, "execute");
        String[] asURIs = this.getSortedMaintenancePackageURIsAsArray();
        if (asURIs == null || asURIs.length == 0) {
            Logr.debug("URLs == null or URLs is empty.");
            return 0;
        }
        int nReturnCode = 0;
        if (!this.getCondition()) {
            Logr.debug("getCondition() =  false");
            return nReturnCode;
        }
        int i = 0;
        while (nReturnCode != 1 && i < asURIs.length) {
            int nReturnCodeThis = this.executeThisPackage(asURIs[i], i, asURIs.length);
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            ++i;
        }
        Logr.methodReturn(className, "execute", new Integer(nReturnCode).toString());
        return nReturnCode;
    }

    public boolean getCondition() {
        Logr.methodEntry(className, "getCondition");
        String sCondition = this.getParamValue(S_PARAM_CONDITION);
        if (sCondition == null || sCondition.trim().equals(S_EMPTY)) {
            Logr.debug("sCondition = null or empty.");
            Logr.methodReturn(className, "getCondition", "true");
            return true;
        }
        Logr.methodReturn(className, "getCondition", new Boolean(this.getParamValue(S_PARAM_CONDITION)).toString());
        return new Boolean(this.getParamValue(S_PARAM_CONDITION));
    }

    protected void performTasksBeforeApplyThisIfix(MaintenanceInfoPlugin mipInfoPlugin) {
        Logr.methodEntry(className, "performTasksBeforeApplyThisIfix");
    }

    protected void performTasksAfterApplyThisIfix(MaintenanceInfoPlugin mipInfoPlugin) {
        Logr.methodEntry(className, "performTasksAfterApplyThisIfix");
    }

    protected String getSortedMaintenancePackageURIs() {
        Logr.methodEntry(className, "getSortedMaintenancePackageURIs");
        String sURIs = this.getParamValue(S_PARAM_SORTEDMAINTENANCEPACKAGEURIS);
        String[] asURIs = StringUtils.convertStringToTokenArray(sURIs, ";");
        if (asURIs == null) {
            Logr.debug("URLs == null.");
            Logr.methodReturn(className, "getSortedMaintenancePackageURIs", "null");
            return null;
        }
        String sReturn = S_EMPTY;
        String[] stringArray = asURIs;
        int n = asURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String asURI = stringArray[n2];
            if (asURI != null && asURI.trim().length() > 0) {
                sReturn = String.valueOf(sReturn) + MacroResolver.resolveMacro(asURI, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
                sReturn = String.valueOf(sReturn) + ";";
            }
            ++n2;
        }
        if (sReturn.endsWith(";")) {
            sReturn = sReturn.substring(0, sReturn.length() - ";".length());
        }
        Logr.methodReturn(className, "getSortedMaintenancePackageURIs", sReturn);
        return sReturn;
    }

    protected String[] getSortedMaintenancePackageURIsAsArray() {
        Logr.methodEntry(className, "getSortedMaintenancePackageURIsAsArray");
        String sURIs = this.getSortedMaintenancePackageURIs();
        if (sURIs == null || sURIs.trim().length() == 0) {
            Logr.debug("URLs is null or empty.");
            return null;
        }
        Logr.methodExit(className, "getSortedMaintenancePackageURIsAsArray");
        return StringUtils.convertStringToTokenArray(sURIs, ";");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private int executeThisPackage(String sPackageURI, int nIndex, int nTotalNumberOfPackages) throws NIFException {
        Document document;
        URI uriThisPackage;
        block13: {
            Logr.methodEntry(className, "executeThisPackage");
            uriThisPackage = new URI(sPackageURI);
            document = this.getDocumentForThisURI(uriThisPackage);
            if (document != null) break block13;
            Logr.debug("Document is null.");
            Logr.methodReturn(className, "executeThisPackage", new Integer(0).toString());
            return 0;
        }
        try {
            MaintenanceInfoPlugin mipInfoPlugin = this.instantiateInfoPluginForThisNIFPackage(document);
            this.performTasksBeforeApplyThisIfix(mipInfoPlugin);
            NIFInstallPlugin nifip = NIFInstallPlugin.getInstallPluginFor(document, "install-package/apply-satellite", this.getInstallToolkitBridge());
            if (nifip == null) {
                nifip = NIFInstallPlugin.getInstallPluginFor(document, "install-package/apply-maintenance", this.getInstallToolkitBridge());
            }
            NIFPackageApplicationPlugin nifpap = (NIFPackageApplicationPlugin)nifip;
            String sPathThisPackage = new FileSystemEntry(uriThisPackage, this.getInstallToolkitBridge()).getAbsolutePathWithFlagment();
            String sOriginalCachedValue = InstallToolkitBridgeMacroResolver.getLocalCache(this.getSelectedPackagesKey());
            InstallToolkitBridgeMacroResolver.setLocalCache(this.getSelectedPackagesKey(), sPathThisPackage);
            this.publishNIFInstallPackageEvent(new FileSystemEntry(uriThisPackage, this.getInstallToolkitBridge()).getEntryName(), nIndex, nTotalNumberOfPackages, nifpap.isBackupPackage());
            int nReturnCode = 0;
            if (nifip instanceof SatelliteApplicationPlugin) {
                ((SatelliteApplicationPlugin)nifip).setRunInStandaloneMode(true);
            }
            if ((nReturnCode = nifip.execute()) != 1) {
                this.performTasksAfterApplyThisIfix(mipInfoPlugin);
            }
            InstallToolkitBridgeMacroResolver.cleanLocalCache(this.getSelectedPackagesKey());
            if (sOriginalCachedValue != null) {
                InstallToolkitBridgeMacroResolver.setLocalCache(this.getSelectedPackagesKey(), sOriginalCachedValue);
            }
            Logr.methodReturn(className, "executeThisPackage", new Integer(nReturnCode).toString());
            return nReturnCode;
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (IOException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (InstantiationException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (SAXException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "executeThisPackage", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
    }

    private String getSelectedPackagesKey() {
        Logr.methodEntry(className, "getSelectedPackagesKey");
        String sKey = this.getParamValue(S_PARAM_SELECTEDMAINTENANCEPACKAGESKEY);
        if (sKey == null || sKey.equals(S_EMPTY)) {
            sKey = S_DEFAULT_SELECTEDMAINTENANCEPACKAGESKEY;
        }
        Logr.methodReturn(className, "getSelectedPackagesKey", sKey);
        return sKey;
    }

    private Document getDocumentForThisURI(URI uriPath) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "getDocumentForThisURI");
        FileSystemEntry fseIfix = new FileSystemEntry(uriPath, "maintenance.xml", this.getInstallToolkitBridge());
        if (!fseIfix.exists()) {
            Logr.debug("File does not exist :" + fseIfix.getAbsolutePath());
            return null;
        }
        Logr.methodExit(className, "getDocumentForThisURI");
        return XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseIfix).getDocument();
    }

    private MaintenanceInfoPlugin instantiateInfoPluginForThisNIFPackage(Document documentNIFPackage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "instantiateInfoPluginForThisNIFPackage");
        return MaintenanceInfoPlugin.getMaintenanceInfoPlugin(documentNIFPackage, this.getInstallToolkitBridge());
    }

    private void publishNIFInstallPackageEvent(String sName, int nIndex, int nTotal, boolean fIsUninstall) {
        Logr.methodEntry(className, "publishNIFInstallPackageEvent");
        String sMessage = PakCoreMessages.PAK_CORE_INSATLLNIFPACKAGE_APPLY_MODE_INSTALL;
        if (fIsUninstall) {
            sMessage = PakCoreMessages.PAK_CORE_INSATLLNIFPACKAGE_APPLY_MODE_UNINSTALL;
        }
        NIFUninstallPackageEvent nifpbpe = new NIFUninstallPackageEvent(sMessage, (nIndex + 1) * 100 / nTotal);
        NIFEventMulticaster.instance().publishEvent(nifpbpe);
        Logr.methodExit(className, "publishNIFInstallPackageEvent");
    }
}

