/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.dialogs;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseCheckerFactory;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.policy.ui.Activator;
import com.ibm.cic.licensing.policy.ui.Messages;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FlexServerDialog
extends Dialog {
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private static final int TestConnectionId = 2;
    private Button testConnectionBtn;
    private Label iconLabel;
    private Label msgLabel;
    private Image messageImage;
    private Image warningImage;
    private final ProductInformation pi;
    private final String title;
    private final String[] itemValues;
    private Button singleServer;
    private Button redundantServer;
    private Composite parentComp;
    private Composite serverComp;
    private Text singleServerName;
    private Text singleServerPort;
    private Text primaryServerName;
    private Text primaryPortNumber;
    private Text secondaryServerName;
    private Text secondaryPortNumber;
    private Text tertiaryServerName;
    private Text tertiaryPortNumber;
    private boolean isSingleServer;

    public FlexServerDialog(Shell parentShell, String title, String[] initialValues, ProductInformation pi) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.itemValues = new String[3];
        if (initialValues == null) {
            Arrays.fill(this.itemValues, "");
        } else {
            int i = 0;
            while (i < initialValues.length) {
                this.itemValues[i] = initialValues[i];
                ++i;
            }
        }
        this.isSingleServer = this.itemValues[0].indexOf(",") == -1;
        this.pi = pi;
    }

    protected Control createDialogArea(Composite parent) {
        this.parentComp = (Composite)super.createDialogArea(parent);
        Font font = this.parentComp.getFont();
        Composite labelComp = new Composite(this.parentComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        labelComp.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 55;
        labelComp.setLayoutData((Object)gd);
        this.iconLabel = new Label(labelComp, 0);
        this.msgLabel = new Label(labelComp, 64);
        GridData data = new GridData(4, 4, true, true);
        this.msgLabel.setLayoutData((Object)data);
        this.msgLabel.setFont(parent.getFont());
        Composite buttonComp = new Composite(this.parentComp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1808));
        this.singleServer = new Button(buttonComp, 16);
        this.singleServer.setText(Messages.flexServerDlg_singleServerBtn);
        this.singleServer.setFont(font);
        if (this.isSingleServer) {
            this.singleServer.setSelection(true);
        }
        this.singleServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FlexServerDialog.this.singleServer.getSelection() && !FlexServerDialog.this.isSingleServer) {
                    Point windowSize = FlexServerDialog.this.getShell().getSize();
                    Point oldSize = FlexServerDialog.this.getShell().computeSize(-1, -1);
                    FlexServerDialog.this.isSingleServer = true;
                    FlexServerDialog.this.serverComp.dispose();
                    FlexServerDialog.this.serverComp = FlexServerDialog.this.createServerComposite(FlexServerDialog.this.parentComp);
                    FlexServerDialog.this.serverComp.getParent().layout();
                    Point newSize = FlexServerDialog.this.getShell().computeSize(-1, -1);
                    FlexServerDialog.this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
                    FlexServerDialog.this.validateInput();
                    FlexServerDialog.this.writeConfiguration();
                }
            }
        });
        this.redundantServer = new Button(buttonComp, 16);
        this.redundantServer.setText(Messages.flexServerDlg_redundantServerBtn);
        this.redundantServer.setFont(font);
        if (!this.isSingleServer) {
            this.redundantServer.setSelection(true);
        }
        this.redundantServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FlexServerDialog.this.redundantServer.getSelection() && FlexServerDialog.this.isSingleServer) {
                    Point windowSize = FlexServerDialog.this.getShell().getSize();
                    Point oldSize = FlexServerDialog.this.getShell().computeSize(-1, -1);
                    FlexServerDialog.this.isSingleServer = false;
                    FlexServerDialog.this.serverComp.dispose();
                    FlexServerDialog.this.serverComp = FlexServerDialog.this.createServerComposite(FlexServerDialog.this.parentComp);
                    FlexServerDialog.this.serverComp.getParent().layout();
                    Point newSize = FlexServerDialog.this.getShell().computeSize(-1, -1);
                    FlexServerDialog.this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
                    FlexServerDialog.this.validateInput();
                    FlexServerDialog.this.writeConfiguration();
                }
            }
        });
        this.serverComp = this.createServerComposite(this.parentComp);
        return this.parentComp;
    }

    private Composite createServerComposite(Composite parent) {
        Font font = parent.getFont();
        Group comp = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 450;
        comp.setLayoutData((Object)gd);
        String[] initServerNames = this.parseInitialValues(this.itemValues[0]);
        String[] initPortNumbers = this.parseInitialValues(this.itemValues[1]);
        if (this.isSingleServer) {
            Label serverLabel = new Label((Composite)comp, 0);
            serverLabel.setText(Messages.flexServerNameLabelText);
            serverLabel.setFont(font);
            this.singleServerName = new Text((Composite)comp, 2052);
            this.singleServerName.setFont(font);
            this.singleServerName.setText(initServerNames[0]);
            this.singleServerName.setLayoutData((Object)new GridData(768));
            this.singleServerName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label portLabel = new Label((Composite)comp, 0);
            portLabel.setText(Messages.flexServerPortLabelText);
            this.singleServerPort = new Text((Composite)comp, 2052);
            this.singleServerPort.setFont(font);
            this.singleServerPort.setText(initPortNumbers[0]);
            this.singleServerPort.setLayoutData((Object)new GridData(768));
        } else {
            Label explainLabel = new Label((Composite)comp, 0);
            explainLabel.setFont(font);
            explainLabel.setText(Messages.flexServerDlg_explainText);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            explainLabel.setLayoutData((Object)data);
            Label fillInLabel = new Label((Composite)comp, 0);
            data = new GridData(768);
            data.horizontalSpan = 2;
            fillInLabel.setLayoutData((Object)data);
            Label primaryServerLabel = new Label((Composite)comp, 0);
            primaryServerLabel.setText(Messages.flexServerDlg_primaryServer);
            primaryServerLabel.setFont(font);
            this.primaryServerName = new Text((Composite)comp, 2052);
            this.primaryServerName.setFont(font);
            this.primaryServerName.setText(initServerNames[0]);
            this.primaryServerName.setLayoutData((Object)new GridData(768));
            this.primaryServerName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label primaryPortLabel = new Label((Composite)comp, 0);
            primaryPortLabel.setText(Messages.flexServerPortLabelText);
            this.primaryPortNumber = new Text((Composite)comp, 2052);
            this.primaryPortNumber.setFont(font);
            this.primaryPortNumber.setText(initPortNumbers[0]);
            this.primaryPortNumber.setLayoutData((Object)new GridData(768));
            this.primaryPortNumber.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label secondaryServerLabel = new Label((Composite)comp, 0);
            secondaryServerLabel.setText(Messages.flexServerDlg_secondaryServer);
            secondaryServerLabel.setFont(font);
            this.secondaryServerName = new Text((Composite)comp, 2052);
            this.secondaryServerName.setFont(font);
            this.secondaryServerName.setText(initServerNames[1]);
            this.secondaryServerName.setLayoutData((Object)new GridData(768));
            this.secondaryServerName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label secondaryPortLabel = new Label((Composite)comp, 0);
            secondaryPortLabel.setText(Messages.flexServerDlg_secondaryServerPort);
            this.secondaryPortNumber = new Text((Composite)comp, 2052);
            this.secondaryPortNumber.setFont(font);
            this.secondaryPortNumber.setText(initPortNumbers[1]);
            this.secondaryPortNumber.setLayoutData((Object)new GridData(768));
            this.secondaryPortNumber.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label tertiaryServerLabel = new Label((Composite)comp, 0);
            tertiaryServerLabel.setText(Messages.flexServerDlg_tertiaryServer);
            tertiaryServerLabel.setFont(font);
            this.tertiaryServerName = new Text((Composite)comp, 2052);
            this.tertiaryServerName.setFont(font);
            this.tertiaryServerName.setText(initServerNames[2]);
            this.tertiaryServerName.setLayoutData((Object)new GridData(768));
            this.tertiaryServerName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
            Label tertiaryPortLabel = new Label((Composite)comp, 0);
            tertiaryPortLabel.setText(Messages.flexServerDlg_tertiaryServerPort);
            this.tertiaryPortNumber = new Text((Composite)comp, 2052);
            this.tertiaryPortNumber.setFont(font);
            this.tertiaryPortNumber.setText(initPortNumbers[2]);
            this.tertiaryPortNumber.setLayoutData((Object)new GridData(768));
            this.tertiaryPortNumber.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlexServerDialog.this.validateInput();
                }
            });
        }
        return comp;
    }

    private String[] parseInitialValues(String value) {
        String[] initValues = new String[]{"", "", ""};
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        int i = 0;
        while (i < initValues.length && tokenizer.hasMoreTokens()) {
            initValues[i] = tokenizer.nextToken();
            ++i;
        }
        return initValues;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.testConnectionBtn = this.createButton(parent, 2, Messages.flexServerTestConnection, false);
        this.testConnectionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDescriptor descriptor;
                ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker((String)"FLEX");
                String serverName = null;
                String portNum = null;
                if (FlexServerDialog.this.isSingleServer) {
                    serverName = FlexServerDialog.this.singleServerName.getText();
                    portNum = FlexServerDialog.this.singleServerPort.getText();
                } else {
                    serverName = FlexServerDialog.this.primaryServerName.getText();
                    serverName = String.valueOf(serverName) + ",";
                    serverName = String.valueOf(serverName) + FlexServerDialog.this.secondaryServerName.getText();
                    serverName = String.valueOf(serverName) + ",";
                    serverName = String.valueOf(serverName) + FlexServerDialog.this.tertiaryServerName.getText();
                    portNum = FlexServerDialog.this.primaryPortNumber.getText();
                    portNum = String.valueOf(portNum) + ",";
                    portNum = String.valueOf(portNum) + FlexServerDialog.this.secondaryPortNumber.getText();
                    portNum = String.valueOf(portNum) + ",";
                    portNum = String.valueOf(portNum) + FlexServerDialog.this.tertiaryPortNumber.getText();
                }
                IStatus licstatus = licenseChecker.testConnection(FlexServerDialog.this.pi, serverName, portNum);
                if (licstatus.getSeverity() == 1) {
                    if (FlexServerDialog.this.messageImage == null) {
                        descriptor = Activator.getImageDescriptor("icons/obj16/message_obj.gif");
                        FlexServerDialog.this.messageImage = descriptor.createImage();
                    }
                    FlexServerDialog.this.iconLabel.setImage(FlexServerDialog.this.messageImage);
                } else {
                    if (FlexServerDialog.this.warningImage == null) {
                        descriptor = Activator.getImageDescriptor("icons/obj16/warning_obj.gif");
                        FlexServerDialog.this.warningImage = descriptor.createImage();
                    }
                    FlexServerDialog.this.iconLabel.setImage(FlexServerDialog.this.warningImage);
                }
                FlexServerDialog.this.msgLabel.setText(licstatus.getMessage());
                Composite control = FlexServerDialog.this.msgLabel.getParent();
                if (control != null) {
                    control.layout();
                    control = control.getParent();
                    if (control != null) {
                        control.layout();
                    }
                }
            }
        });
        super.createButtonsForButtonBar(parent);
        this.validateInput();
    }

    protected boolean isValidInput() {
        if (this.isSingleServer) {
            return this.singleServerName != null && this.singleServerName.getText().trim().length() > 0;
        }
        return this.primaryServerName != null && this.primaryServerName.getText().trim().length() > 0 && this.secondaryServerName != null && this.secondaryServerName.getText().trim().length() > 0 && this.tertiaryServerName != null && this.tertiaryServerName.getText().trim().length() > 0 && this.primaryPortNumber != null && this.primaryPortNumber.getText().trim().length() > 0 && this.secondaryPortNumber != null && this.secondaryPortNumber.getText().trim().length() > 0 && this.tertiaryPortNumber != null && this.tertiaryPortNumber.getText().trim().length() > 0;
    }

    protected void validateInput() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.isValidInput());
        this.testConnectionBtn.setEnabled(this.isValidInput());
        this.iconLabel.setImage(null);
        this.msgLabel.setText("");
    }

    public String[] getItemValues() {
        return this.itemValues;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.isSingleServer) {
                this.itemValues[0] = this.singleServerName.getText().trim();
                this.itemValues[1] = this.singleServerPort.getText().trim();
                this.itemValues[2] = Messages.flexSingleServer;
            } else {
                this.itemValues[0] = this.primaryServerName.getText();
                this.itemValues[0] = String.valueOf(this.itemValues[0]) + ",";
                this.itemValues[0] = String.valueOf(this.itemValues[0]) + this.secondaryServerName.getText();
                this.itemValues[0] = String.valueOf(this.itemValues[0]) + ",";
                this.itemValues[0] = String.valueOf(this.itemValues[0]) + this.tertiaryServerName.getText();
                this.itemValues[1] = this.primaryPortNumber.getText();
                this.itemValues[1] = String.valueOf(this.itemValues[1]) + ",";
                this.itemValues[1] = String.valueOf(this.itemValues[1]) + this.secondaryPortNumber.getText();
                this.itemValues[1] = String.valueOf(this.itemValues[1]) + ",";
                this.itemValues[1] = String.valueOf(this.itemValues[1]) + this.tertiaryPortNumber.getText();
                this.itemValues[2] = Messages.flexRedundantServer;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        this.readConfiguration();
    }

    public boolean close() {
        this.writeConfiguration();
        if (this.messageImage != null) {
            this.messageImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        return super.close();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            if (this.isSingleServer) {
                x = s.getInt("width");
                y = s.getInt("height");
            } else {
                x = s.getInt("width_redundant");
                y = s.getInt("height_redundant");
            }
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        if (this.isSingleServer) {
            s.put("width", size.x);
            s.put("height", size.y);
        } else {
            s.put("width_redundant", size.x);
            s.put("height_redundant", size.y);
        }
    }
}

