/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.parts;

import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.StructuredViewerPart;
import com.ibm.cic.common.ui.views.CICUISection;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends CICUISection {
    protected StructuredViewerPart viewerPart;
    protected int buttonsOrientation = 512;

    public StructuredViewerSection(IFormContext context, Composite parent, int style, String[] buttonLabels, int buttonsOrientation) {
        this(context, parent, style, (style & 0x1000) == 0, buttonLabels, buttonsOrientation);
    }

    public StructuredViewerSection(IFormContext context, Composite parent, int style, String[] buttonLabels) {
        this(context, parent, style, (style & 0x1000) == 0, buttonLabels, 512);
    }

    public StructuredViewerSection(IFormContext context, Composite parent, int style, boolean titleBar, String[] buttonLabels, int buttonsOrientation) {
        super(context, parent, style, titleBar);
        this.buttonsOrientation = buttonsOrientation;
        this.viewerPart = this.createViewerPart(buttonLabels);
        this.viewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = context.getForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredViewerSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = span;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        return container;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void buttonSelected(int index) {
    }

    protected void doPaste() {
    }

    protected ISelection getViewerSelection() {
        return this.viewerPart.getViewer().getSelection();
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return false;
    }

    public void setFocus() {
        this.viewerPart.getControl().setFocus();
        this.viewerPart.getControl().setEnabled(false);
        this.viewerPart.getControl().setEnabled(true);
    }
}

