/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.core.notify.AgentListener;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIDisableCancelWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.ConditionalInstallPage;
import com.ibm.cic.agent.internal.ui.wizards.EclipseStyleLicensePage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateSummaryPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.CICImages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;

public class UpdateWizard
extends AgentUIDisableCancelWizard {
    private Map launchers;
    private Map launchersProfiles;
    private boolean isUpdateAll = false;
    private final AgentListener listener = new AgentListener();
    private Collection updateResultTreeRoot;

    public UpdateWizard() {
        super(null, com.ibm.cic.agent.internal.ui.licenses.Messages.UpdateWizard_title, CICImages.WIZ_CHECKUPDATE);
    }

    public UpdateWizard(String returnPageId) {
        super(returnPageId, com.ibm.cic.agent.internal.ui.licenses.Messages.UpdateWizard_title, CICImages.WIZ_CHECKUPDATE);
    }

    public void addPages() {
        EclipseStyleLicensePage licensePage;
        ConditionalInstallPage conditionalUpdatePage = new ConditionalInstallPage(this.toolkit, this);
        if (!conditionalUpdatePage.shouldSkip()) {
            conditionalUpdatePage.setHelpRef("com.ibm.cic.agent.ui.ConditionalInstallPage");
            this.addPage((IWizardPage)conditionalUpdatePage);
        }
        if (!(licensePage = new EclipseStyleLicensePage(this.toolkit, this)).shouldSkip()) {
            this.addPage((IWizardPage)licensePage);
            licensePage.setHelpRef("com.ibm.cic.agent.ui.EclipseStyleLicensePage");
        }
        if (!this.isUpdateAll) {
            FeatureSelectionPage featurePage = new FeatureSelectionPage(this.toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, Messages.InstallWizard_featuresDescription, this, false);
            featurePage.setHelpRef("com.ibm.cic.agent.ui.FeatureSelectionPage");
            this.addPage((IWizardPage)featurePage);
        }
        this.addExtensionPages("com.ibm.cic.agent.ui.MissingCustomPanelUpdateWizard");
        this.addSingleConfigurationPage(com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, "com.ibm.cic.agent.ui.MissingCustomPanelSingleConfigurationPage");
        this.addPage((IWizardPage)new UpdateSummaryPage(this.toolkit, this));
        if (!Agent.getInstance().isPortable()) {
            this.launchersProfiles = new TreeMap();
            this.launchers = this.getLaunchersForSelectedOffering();
        } else {
            this.launchers = Collections.EMPTY_MAP;
        }
        this.startAgentListener();
    }

    private Map getLaunchersForSelectedOffering() {
        HashMap<String, List<LauncherFactory.Launcher>> profileOfferings = new HashMap<String, List<LauncherFactory.Launcher>>();
        List jobs = this.getSelectedJobs();
        for (AbstractJob job : jobs) {
            IOffering offering = job.getOffering();
            if (offering == null) continue;
            LauncherFactory.Launcher[] offeringLaunchers = LauncherFactory.getInstance().findLaunchersFor(offering);
            if (offeringLaunchers.length > 0) {
                offeringLaunchers = this.parseLaunchersForUpdateMode(offeringLaunchers);
            }
            List<LauncherFactory.Launcher> list = Arrays.asList(offeringLaunchers);
            this.launchersProfiles.put(job.getProfile().getProfileId(), list);
            profileOfferings.put(String.valueOf(offering.getIdentity().getId()) + "," + job.getProfile().getProfileId(), list);
        }
        return profileOfferings;
    }

    private LauncherFactory.Launcher[] parseLaunchersForUpdateMode(LauncherFactory.Launcher[] offeringLaunchers) {
        ArrayList<LauncherFactory.Launcher> updateModeLauncherList = new ArrayList<LauncherFactory.Launcher>();
        LauncherFactory.Launcher[] launcherArray = offeringLaunchers;
        int n = offeringLaunchers.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherFactory.Launcher launcherObject = launcherArray[n2];
            if (launcherObject.getShowLauncherUpdateMode()) {
                updateModeLauncherList.add(launcherObject);
            }
            ++n2;
        }
        return updateModeLauncherList.toArray(new LauncherFactory.Launcher[updateModeLauncherList.size()]);
    }

    private void startAgentListener() {
        Agent agent = AgentUI.getDefault().getAgent();
        agent.getEventManager().addInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this.listener);
        agent.getEventManager().addBeginFetchOfferingOrFixListener((IAgentEventManager.BeginFetchListener)this.listener);
        agent.getEventManager().addFetchCompletedOfferingOrFixListener((IAgentEventManager.FetchCompletedListener)this.listener);
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        Object job = null;
        job = offering instanceof IOffering ? new UpdateOfferingJob(profile, (IOffering)offering) : new InstallJob(profile, offering);
        job.setSelected(false);
        return job;
    }

    protected AbstractJob createJob(IOffering updatedOffering, Profile profile, IOfferingOrFix offering) {
        AbstractJob job = this.createJob(profile, offering);
        if (job instanceof UpdateOfferingJob) {
            ((UpdateOfferingJob)job).setUpdatedOffering(updatedOffering);
        }
        return job;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus status) {
        UpdateCompletionPage updateCompletePage = new UpdateCompletionPage(this.toolkit, this, status);
        updateCompletePage.setLaunchers(this.launchers);
        updateCompletePage.setLaunchersProfiles(this.launchersProfiles);
        return updateCompletePage;
    }

    @Override
    protected String getRestartMessage() {
        return Messages.RestartProfileMsg;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.UPDATE;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        List selectedJobs = this.getSelectedJobs();
        IStatus status = agent.install((AgentJob[])selectedJobs.toArray(new AbstractJob[selectedJobs.size()]), this.getCollectedArtifacts(), (Agent.IDisableCancel)this, monitor);
        return status;
    }

    @Override
    public void setInput(Object[] items) {
        if (items instanceof Profile[]) {
            this.addProfiles((Profile[])items);
        } else if (items instanceof AbstractJob[]) {
            this.addJobs((AbstractJob[])items);
        }
    }

    private void addJobs(AbstractJob[] jobs) {
        List productProfiles = this.getProductProfileList();
        List agentProfile = this.getAgentProfileList();
        List wizardJobs = this.getJobs();
        productProfiles.clear();
        agentProfile.clear();
        wizardJobs.clear();
        AbstractJob[] abstractJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob job = abstractJobArray[n2];
            wizardJobs.add(job);
            Profile profile = job.getProfile();
            if (profile != null) {
                if (profile.getProfileKind().equals("self")) {
                    agentProfile.add(profile);
                } else if (!productProfiles.contains(profile)) {
                    productProfiles.add(profile);
                }
            }
            ++n2;
        }
    }

    private void addProfiles(Profile[] profiles) {
        List productProfiles = this.getProductProfileList();
        List agentProfile = this.getAgentProfileList();
        List wizardJobs = this.getJobs();
        productProfiles.clear();
        agentProfile.clear();
        wizardJobs.clear();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.getProfileKind().equals("self")) {
                agentProfile.add(profile);
            } else if (!productProfiles.contains(profile)) {
                productProfiles.add(profile);
            }
            ++n2;
        }
    }

    protected void setUpdateAll(boolean updateAll) {
        this.isUpdateAll = updateAll;
    }

    protected boolean isUpdateAll() {
        return this.isUpdateAll;
    }

    public boolean isHelpAvailable() {
        return true;
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.UpdateCanceledMsg;
        }
        return Messages.UpdateFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedMsgForUpdate;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.UpdateCanceledTitle;
        }
        return Messages.UpdateFailedTitle;
    }

    private void stopAgentListener() {
        Agent agent = AgentUI.getDefault().getAgent();
        if (agent != null) {
            agent.getEventManager().removeInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this.listener);
            agent.getEventManager().removeBeginFetchOfferingOrFixListener((IAgentEventManager.BeginFetchListener)this.listener);
            agent.getEventManager().removeFetchCompletedOfferingOrFixListener((IAgentEventManager.FetchCompletedListener)this.listener);
        }
    }

    @Override
    public void dispose() {
        this.stopAgentListener();
        super.dispose();
    }

    public Collection getUpdateResultTreeRoot() {
        return this.updateResultTreeRoot;
    }

    public void setUpdateResultTreeRoot(Collection updateResultTreeRoot) {
        this.updateResultTreeRoot = updateResultTreeRoot;
    }
}

