/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.custompanel.GeneratedSWTCustomPanel;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationCustomPanelNode;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationOfferingNode;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationPanelTreeViewer;
import com.ibm.cic.agent.internal.ui.utils.CustomPanelContentProvider;
import com.ibm.cic.agent.internal.ui.utils.CustomPanelLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.CustomPanelManager;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.SkippableContainerWizardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SingleConfigurationPage
extends AbstractAgentUIWizardPage {
    private ConfigurationPanelTreeViewer treeViewer;
    private Composite panelContainer;
    private StackLayout stackLayout;
    private final CustomPanelJobPair[] panelJobs;
    private ConfigurationCustomPanelNode currentPanel;
    private ConfigurationCustomPanelNode oldPanel;
    private Label panelTitle;
    private Label panelDescription;
    private static int lastTreeWidth = 210;
    private Object lastSelection = null;
    private boolean skipped = false;
    private boolean skipCurrentPanelValidation = false;
    private Set productProfileSet = new HashSet();
    private final AgentUILabelProvider agentLabelProvider;

    public SingleConfigurationPage(FormToolkit toolkit, String title, String description, AgentUIWizard wizard, CustomPanelJobPair[] panelJobs) {
        super(toolkit, title, description, wizard);
        this.panelJobs = panelJobs;
        this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentLabelProvider.connect((Object)this);
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(DisplayKeeper.INSTANCE.getDisplay().getSystemColor(25));
        Composite container = this.toolkit.createComposite(composite, 2048);
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 4;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.horizontalSpacing = 0;
        container.setLayout((Layout)containerLayout);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        container.setLayoutData((Object)data);
        Control treeControl = this.createTreeControl(container);
        this.createSash(container, treeControl);
        Label versep = new Label(container, 514);
        GridData verGd = new GridData(1040);
        versep.setLayoutData((Object)verGd);
        versep.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.createPageControl(container);
        if (this.panelJobs != null && this.panelJobs.length > 0) {
            CustomPanelJobPair[] customPanelJobPairArray = this.panelJobs;
            int n = this.panelJobs.length;
            int n2 = 0;
            while (n2 < n) {
                CustomPanelJobPair panelJob = customPanelJobPairArray[n2];
                CustomPanel panel = (CustomPanel)panelJob.getPanel();
                if (panel.getControl() == null) {
                    try {
                        panel.createControl(this.panelContainer);
                    }
                    catch (RuntimeStatusException e) {
                        AgentUI.reportStatus(e.getStatus(), true);
                    }
                    catch (Exception e) {
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                        AgentUI.reportStatus(status, true);
                    }
                }
                ++n2;
            }
        }
        CustomPanelManager.getInstance().setCustomPanelJobs(this.panelJobs);
        this.setControl((Control)composite);
    }

    private void setDefaultSelection() {
        List panelNodes = CustomPanelManager.getInstance().getPanelNodes();
        this.treeViewer.setSelection((ISelection)new StructuredSelection(panelNodes.get(0)));
    }

    protected Sash createSash(final Composite composite, final Control rightControl) {
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.setBackground(DisplayKeeper.INSTANCE.getDisplay().getSystemColor(25));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)rightControl.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 20) {
                    return;
                }
                data.widthHint = newWidthHint;
                SingleConfigurationPage.setLastTreeWidth(newWidthHint);
                composite.layout(true);
            }
        });
        return sash;
    }

    private Control createTreeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = SingleConfigurationPage.getLastTreeWidth();
        container.setLayoutData((Object)gd);
        this.treeViewer = new ConfigurationPanelTreeViewer(container, 4);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.addListeners(this.treeViewer);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CustomPanelLabelProvider(this.treeViewer));
        this.treeViewer.setContentProvider((IContentProvider)new CustomPanelContentProvider());
        return container;
    }

    private void addListeners(TreeViewer viewer) {
        final Tree cpNodeTree = viewer.getTree();
        Listener[] keyDownListeners = cpNodeTree.getListeners(1);
        if (keyDownListeners != null) {
            Listener[] listenerArray = keyDownListeners;
            int n = keyDownListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener keyDownListener = listenerArray[n2];
                cpNodeTree.removeListener(1, keyDownListener);
                ++n2;
            }
        }
        cpNodeTree.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 1) {
                    if (e.keyCode == 0x1000002 && e.stateMask == 0) {
                        TreeItem previousSelection = null;
                        TreeItem[] selections = cpNodeTree.getSelection();
                        if (selections != null && selections.length > 0) {
                            previousSelection = selections[0];
                        }
                        final TreeItem finalPreviousSelection = previousSelection;
                        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ConfigurationCustomPanelNode nextNode;
                                TreeItem[] selection = cpNodeTree.getSelection();
                                if (selection != null && selection.length > 0 && SingleConfigurationPage.this.currentPanel != null && finalPreviousSelection == selection[0] && (nextNode = CustomPanelManager.getInstance().getNextValidPanelNode(SingleConfigurationPage.this.currentPanel)) != null) {
                                    SingleConfigurationPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)nextNode));
                                }
                            }
                        });
                    } else if (e.keyCode == 0x1000001 && e.stateMask == 0) {
                        TreeItem previousSelection = null;
                        TreeItem[] selections = cpNodeTree.getSelection();
                        if (selections != null && selections.length > 0) {
                            previousSelection = selections[0];
                        }
                        final TreeItem finalPreviousSelection = previousSelection;
                        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ConfigurationCustomPanelNode previousNode;
                                TreeItem[] selection = cpNodeTree.getSelection();
                                if (selection != null && selection.length > 0 && SingleConfigurationPage.this.currentPanel != null && finalPreviousSelection == selection[0] && (previousNode = CustomPanelManager.getInstance().getPreviousValidPanelNode(SingleConfigurationPage.this.currentPanel)) != null) {
                                    SingleConfigurationPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)previousNode));
                                }
                            }
                        });
                    }
                }
            }
        });
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                StructuredSelection sel;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !(sel = (StructuredSelection)selection).isEmpty() && (selectedElement = sel.getFirstElement()) != null && !selectedElement.equals(SingleConfigurationPage.this.lastSelection)) {
                    CustomPanel currentCustomPanel;
                    if (SingleConfigurationPage.this.currentPanel != null && !SingleConfigurationPage.this.skipCurrentPanelValidation && (currentCustomPanel = SingleConfigurationPage.this.currentPanel.getPanel()) instanceof GeneratedSWTCustomPanel) {
                        GeneratedSWTCustomPanel generatedPanel = (GeneratedSWTCustomPanel)currentCustomPanel;
                        generatedPanel.validateCustomPanel(true, false);
                    }
                    SingleConfigurationPage.this.lastSelection = selectedElement;
                    if (selectedElement instanceof ConfigurationCustomPanelNode) {
                        SingleConfigurationPage.this.treeViewer.setLastSelection((ConfigurationCustomPanelNode)selectedElement);
                        ConfigurationCustomPanelNode node = (ConfigurationCustomPanelNode)selectedElement;
                        SingleConfigurationPage.this.showPanel(node);
                        node.setVisited(true);
                        SingleConfigurationPage.this.treeViewer.update(node, null);
                    }
                }
            }
        });
    }

    private boolean showPanel(ConfigurationCustomPanelNode node) {
        List panelNodes;
        Composite parentComp;
        if (node == null || node.getPanel() == null) {
            return false;
        }
        final CustomPanel panel = node.getPanel();
        ConfigurationOfferingNode parentNode = node.getParent();
        final AgentJob job = parentNode.getJob();
        panel.setContainer((SkippableContainerWizardPage)this);
        if (panel.getControl() == null) {
            final boolean[] failed = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    failed[0] = true;
                    IStatus status = e instanceof RuntimeStatusException ? ((RuntimeStatusException)e).getStatus() : SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)job, (ICustomPanel)panel, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }

                public void run() {
                    panel.createControl(SingleConfigurationPage.this.panelContainer);
                }
            });
            if (failed[0]) {
                return false;
            }
            Assert.isNotNull((Object)panel.getControl());
        }
        this.oldPanel = this.currentPanel;
        this.currentPanel = node;
        Point contentSize = node.getPanel().getControl().computeSize(-1, -1, true);
        if (this.oldPanel != null) {
            Rectangle rect = this.panelContainer.getClientArea();
            Point containerSize = new Point(rect.width, rect.height);
            this.currentPanel.getPanel().getControl().setSize(containerSize);
        }
        if ((parentComp = this.panelContainer.getParent()) instanceof ScrolledComposite) {
            ScrolledComposite scrolled = (ScrolledComposite)parentComp;
            scrolled.setMinSize(contentSize);
        }
        if ((panelNodes = CustomPanelManager.getInstance().getPanelNodes()) != null && !panelNodes.isEmpty()) {
            int i = 0;
            while (i < panelNodes.size()) {
                ConfigurationCustomPanelNode pNode = (ConfigurationCustomPanelNode)panelNodes.get(i);
                if (pNode != this.currentPanel) {
                    try {
                        pNode.getPanel().setVisible(false);
                    }
                    catch (Exception e) {
                        ConfigurationOfferingNode offNode = pNode.getParent();
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)this.currentPanel.getPanel(), (Throwable)e);
                        AgentUI.reportStatus(status, true);
                    }
                }
                ++i;
            }
        }
        try {
            this.currentPanel.getPanel().setVisible(true);
        }
        catch (Exception e) {
            ConfigurationOfferingNode offNode = this.currentPanel.getParent();
            IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)this.currentPanel.getPanel(), (Throwable)e);
            AgentUI.reportStatus(status, true);
        }
        this.stackLayout.topControl = this.currentPanel.getPanel().getControl();
        this.panelContainer.layout();
        Composite parent = this.panelContainer.getParent();
        if (parent != null) {
            parent.layout();
            parent = parent.getParent();
            if (parent != null) {
                parent.layout();
            }
        }
        this.update();
        return true;
    }

    protected void update() {
        if (this.oldPanel != null) {
            this.treeViewer.update(this.oldPanel, null);
        }
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.updateHelp();
    }

    private void updateHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.panelContainer.getShell(), this.getHelpRef());
        IWizardContainer c = this.getAgentWizard().getContainer();
        if (c instanceof AbstractCicWizardView) {
            AbstractCicWizardView acwv = (AbstractCicWizardView)c;
            acwv.fireCurrentPageChanged();
        }
    }

    private void updateTitle() {
        Profile profile;
        if (this.currentPanel == null) {
            return;
        }
        ConfigurationOfferingNode offeringNode = this.currentPanel.getParent();
        String title = offeringNode.toString();
        if (offeringNode.getJob() != null) {
            title = NLS.bind((String)Messages.SingleConfigurationPage_panelTitle, (Object)title);
        } else if (CustomPanelManager.getInstance().displayProfileNode() && (profile = offeringNode.getProfile()) != null) {
            String profileId = profile.getProfileId();
            title = NLS.bind((String)Messages.SingleConfigurationPage_commonConfigForProfile, (Object)profileId);
        }
        String nodeId = this.currentPanel.getNodeId();
        this.panelTitle.setText(title);
        this.panelDescription.setText(nodeId);
        Composite titleComp = this.panelTitle.getParent();
        if (titleComp != null) {
            titleComp.redraw();
            titleComp.layout();
            titleComp = titleComp.getParent();
            if (titleComp != null) {
                titleComp.layout();
            }
        }
    }

    private void updateMessage() {
        if (this.currentPanel == null) {
            return;
        }
        CustomPanel customPanel = this.currentPanel.getPanel();
        if (customPanel instanceof GeneratedSWTCustomPanel) {
            GeneratedSWTCustomPanel generatedCustomPanel = (GeneratedSWTCustomPanel)customPanel;
            IStatus errorStatus = generatedCustomPanel.getErrorStatus();
            IStatus msgStatus = generatedCustomPanel.getMessageStatus();
            this.setMessageWithStatus(msgStatus);
            this.setErrorMessageWithStatus(errorStatus);
            if (errorStatus == null && msgStatus == null) {
                this.setMessage(this.getDescription());
            }
        } else {
            String panelMessage = null;
            try {
                panelMessage = customPanel.getMessage();
            }
            catch (Exception e) {
                ConfigurationOfferingNode offNode = this.currentPanel.getParent();
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)customPanel, (Throwable)e);
                AgentUI.reportStatus(status, true);
                panelMessage = null;
            }
            int panelMessageType = 0;
            try {
                panelMessageType = customPanel.getMessageType();
            }
            catch (Exception e) {
                ConfigurationOfferingNode offNode = this.currentPanel.getParent();
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)customPanel, (Throwable)e);
                AgentUI.reportStatus(status, true);
                panelMessageType = 0;
            }
            if (panelMessage == null) {
                this.setMessage(this.getDescription());
            } else {
                this.setMessage(panelMessage, panelMessageType);
            }
            String errorMsg = null;
            try {
                errorMsg = customPanel.getErrorMessage();
            }
            catch (Exception e) {
                ConfigurationOfferingNode offNode = this.currentPanel.getParent();
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)customPanel, (Throwable)e);
                AgentUI.reportStatus(status, true);
                errorMsg = null;
            }
            this.setErrorMessage(errorMsg);
        }
    }

    private Control createPageControl(Composite parent) {
        Composite pageAreaComposite = this.toolkit.createComposite(parent, 0);
        GridData pageData = new GridData(1808);
        pageAreaComposite.setLayoutData((Object)pageData);
        GridLayout pageLayout = new GridLayout(1, true);
        pageLayout.marginHeight = 0;
        pageLayout.marginWidth = 0;
        pageLayout.verticalSpacing = 0;
        pageAreaComposite.setLayout((Layout)pageLayout);
        Composite titleComp = this.toolkit.createComposite(pageAreaComposite, 0);
        titleComp.setLayout((Layout)new GridLayout());
        titleComp.setLayoutData((Object)new GridData(768));
        final Font boldFont = CommonUIUtils.createBoldFont((Display)DisplayKeeper.INSTANCE.getDisplay(), (Font)titleComp.getFont());
        this.panelTitle = this.toolkit.createLabel(titleComp, "", 64);
        GridData data = new GridData(4, 1, true, false);
        this.panelTitle.setLayoutData((Object)data);
        this.panelTitle.setFont(boldFont);
        titleComp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (boldFont != null && !boldFont.isDisposed()) {
                    boldFont.dispose();
                }
            }
        });
        this.panelDescription = this.toolkit.createLabel(titleComp, "", 64);
        data = new GridData(4, 1, true, false);
        this.panelDescription.setLayoutData((Object)data);
        Label sepLabel = this.toolkit.createSeparator(pageAreaComposite, 258);
        sepLabel.setLayoutData((Object)new GridData(768));
        this.panelContainer = this.createPageContainer(pageAreaComposite);
        return pageAreaComposite;
    }

    protected Composite createPageContainer(Composite parent) {
        Composite outer = this.toolkit.createComposite(parent, 0);
        GridData outerData = new GridData(1808);
        outerData.horizontalIndent = 7;
        outer.setLayout((Layout)new GridLayout());
        outer.setLayoutData((Object)outerData);
        ScrolledComposite scrolled = new ScrolledComposite(outer, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridData scrolledData = new GridData(1808);
        scrolled.setLayoutData((Object)scrolledData);
        Composite result = this.toolkit.createComposite((Composite)scrolled, 0);
        GridData resultData = new GridData(1808);
        this.stackLayout = new StackLayout();
        result.setLayout((Layout)this.stackLayout);
        result.setLayoutData((Object)resultData);
        scrolled.setContent((Control)result);
        return result;
    }

    public boolean shouldSkip() {
        if (this.panelJobs == null || this.panelJobs.length == 0) {
            this.skipped = true;
            return this.skipped;
        }
        int i = 0;
        while (i < this.panelJobs.length) {
            try {
                if (!this.panelJobs[i].getPanel().shouldSkip()) {
                    this.skipped = false;
                    return this.skipped;
                }
            }
            catch (Exception e) {
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)this.panelJobs[i], (Throwable)e);
                AgentUI.reportStatus(status, true);
                this.skipped = false;
                return this.skipped;
            }
            ++i;
        }
        this.skipped = true;
        return this.skipped;
    }

    public IWizardPage getNextPage() {
        if (this.skipped) {
            return super.getNextPage();
        }
        if (this.currentPanel != null) {
            boolean goNext = true;
            CustomPanel currentCustomPanel = this.currentPanel.getPanel();
            if (currentCustomPanel instanceof GeneratedSWTCustomPanel) {
                GeneratedSWTCustomPanel generatedPanel = (GeneratedSWTCustomPanel)currentCustomPanel;
                goNext = generatedPanel.validateCustomPanel(false, true);
            }
            if (!goNext) {
                return this;
            }
            ConfigurationCustomPanelNode nextNode = CustomPanelManager.getInstance().getNextValidPanelNode(this.currentPanel);
            if (nextNode != null) {
                this.skipCurrentPanelValidation = true;
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)nextNode));
                this.skipCurrentPanelValidation = false;
                return this;
            }
        }
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        if (this.skipped) {
            return super.getPreviousPage();
        }
        if (this.currentPanel != null) {
            boolean goPrevious = true;
            CustomPanel currentCustomPanel = this.currentPanel.getPanel();
            if (currentCustomPanel instanceof GeneratedSWTCustomPanel) {
                GeneratedSWTCustomPanel generatedPanel = (GeneratedSWTCustomPanel)currentCustomPanel;
                goPrevious = generatedPanel.validateCustomPanel(true, true);
            }
            if (!goPrevious) {
                return this;
            }
            ConfigurationCustomPanelNode previousNode = CustomPanelManager.getInstance().getPreviousValidPanelNode(this.currentPanel);
            if (previousNode != null) {
                this.skipCurrentPanelValidation = true;
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)previousNode));
                this.skipCurrentPanelValidation = false;
                return this;
            }
        }
        return super.getPreviousPage();
    }

    public boolean canFlipToPreviousPage() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.isPanelComplete();
    }

    private boolean isPanelComplete() {
        if (this.skipped) {
            return true;
        }
        if (this.currentPanel != null) {
            block7: {
                block6: {
                    try {
                        if (this.currentPanel.getPanel().isPageComplete()) break block6;
                        return false;
                    }
                    catch (Exception e) {
                        ConfigurationOfferingNode offNode = this.currentPanel.getParent();
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)this.currentPanel.getPanel(), (Throwable)e);
                        AgentUI.reportStatus(status, true);
                        return false;
                    }
                }
                if (CustomPanelManager.getInstance().getNextValidPanelNode(this.currentPanel) == null) break block7;
                return true;
            }
            return this.isAllPanelComplete();
        }
        return true;
    }

    public boolean isPageComplete() {
        List nonSkippedPanels = this.getAllNonSkippedPanels();
        for (CustomPanelJobPair nonSkippedPanel : nonSkippedPanels) {
            CustomPanel panel = (CustomPanel)nonSkippedPanel.getPanel();
            try {
                if (panel.isPageComplete()) continue;
                return false;
            }
            catch (Exception e) {
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)nonSkippedPanel, (Throwable)e);
                AgentUI.reportStatus(status, true);
                return false;
            }
        }
        return true;
    }

    private List getAllNonSkippedPanels() {
        ArrayList<CustomPanelJobPair> return_result = new ArrayList<CustomPanelJobPair>();
        if (this.panelJobs != null && this.panelJobs.length > 0) {
            int i = 0;
            while (i < this.panelJobs.length) {
                try {
                    if (!this.panelJobs[i].getPanel().shouldSkip()) {
                        return_result.add(this.panelJobs[i]);
                    }
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)this.panelJobs[i], (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
                ++i;
            }
        }
        return return_result;
    }

    private boolean isAllPanelComplete() {
        List panelNodes = CustomPanelManager.getInstance().getPanelNodes();
        if (panelNodes != null && !panelNodes.isEmpty()) {
            int i = 0;
            while (i < panelNodes.size()) {
                ConfigurationCustomPanelNode node = (ConfigurationCustomPanelNode)panelNodes.get(i);
                try {
                    boolean isThisPanelComplete = node.getPanel().isPageComplete();
                    if (!isThisPanelComplete) {
                        return false;
                    }
                }
                catch (Exception e) {
                    ConfigurationOfferingNode offNode = node.getParent();
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)node.getPanel(), (Throwable)e);
                    AgentUI.reportStatus(status, true);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void initializeAllNonSkippedCustomPanels() {
        if (this.panelJobs == null || this.panelJobs.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.panelJobs.length) {
            CustomPanel panel = (CustomPanel)this.panelJobs[i].getPanel();
            if (panel != null && !CustomPanelManager.getInstance().isPanelSkipped(this.panelJobs[i])) {
                try {
                    panel.setInitialData();
                }
                catch (RuntimeStatusException e) {
                    AgentUI.reportStatus(e.getStatus(), true);
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)this.panelJobs[i], (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
            }
            ++i;
        }
    }

    private void initializeSkipStatusChangedPanels() {
        if (this.panelJobs == null || this.panelJobs.length == 0) {
            return;
        }
        CustomPanelJobPair[] customPanelJobPairArray = this.panelJobs;
        int n = this.panelJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean previousSkipped;
            CustomPanelJobPair panelJob = customPanelJobPairArray[n2];
            CustomPanel panel = (CustomPanel)panelJob.getPanel();
            boolean isSkippedNow = CustomPanelManager.getInstance().isPanelSkipped(panelJob);
            if (panel != null && !isSkippedNow && (previousSkipped = CustomPanelManager.getInstance().getPreviousSkipInfo(panelJob)).booleanValue()) {
                try {
                    panel.setInitialData();
                }
                catch (RuntimeStatusException e) {
                    AgentUI.reportStatus(e.getStatus(), true);
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
            }
            ++n2;
        }
    }

    private boolean profileChanged(List productProfileList) {
        boolean profileChanged = false;
        HashSet newProfiles = new HashSet(productProfileList);
        if (this.productProfileSet.size() == newProfiles.size()) {
            this.productProfileSet.removeAll(newProfiles);
            if (this.productProfileSet.size() != 0) {
                profileChanged = true;
            }
            this.productProfileSet = newProfiles;
        } else {
            this.productProfileSet = newProfiles;
            profileChanged = true;
        }
        return profileChanged;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean skipInfoChanged = false;
            skipInfoChanged = this.getAgentWizard().getWizardType().equals(WizardType.INSTALL) && !this.getAgentWizard().isMultipleProfileInstall() ? CustomPanelManager.getInstance().reEvaluatePanelSkipInfo((Profile)this.getProductProfileList().get(0)) : CustomPanelManager.getInstance().reEvaluatePanelSkipInfo();
            List productProfileList = this.getProductProfileList();
            if (this.profileChanged(productProfileList)) {
                AgentInput.getInstance().checkUserDataInProfile(productProfileList);
                this.initializeAllNonSkippedCustomPanels();
            } else {
                this.initializeSkipStatusChangedPanels();
            }
            if (skipInfoChanged) {
                CustomPanelManager.getInstance().generateTreeStructure();
                this.treeViewer.setInput(CustomPanelManager.getInstance().getTreeRoot());
                this.treeViewer.expandAll();
                this.lastSelection = null;
                this.currentPanel = null;
                this.setDefaultSelection();
            } else if (this.currentPanel != null) {
                this.lastSelection = null;
                StructuredSelection currentSelection = new StructuredSelection((Object)this.currentPanel);
                this.currentPanel = null;
                this.treeViewer.setSelection((ISelection)currentSelection);
            }
        }
        super.setVisible(visible);
    }

    public boolean hasInternalNavigation() {
        return true;
    }

    public static int getLastTreeWidth() {
        return lastTreeWidth;
    }

    public static void setLastTreeWidth(int lastTreeWidth) {
        SingleConfigurationPage.lastTreeWidth = lastTreeWidth;
    }

    public Control getCurrentPanelControl() {
        if (this.currentPanel != null) {
            return this.currentPanel.getPanel().getControl();
        }
        return null;
    }

    public void updateButtons() {
        super.updateButtons();
    }

    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
        if (this.panelJobs != null && this.panelJobs.length > 0) {
            CustomPanelJobPair[] customPanelJobPairArray = this.panelJobs;
            int n = this.panelJobs.length;
            int n2 = 0;
            while (n2 < n) {
                CustomPanelJobPair panelJob = customPanelJobPairArray[n2];
                CustomPanel panel = (CustomPanel)panelJob.getPanel();
                try {
                    if (!panel.isDisposed()) {
                        panel.dispose();
                    }
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
                ++n2;
            }
        }
        CustomPanelManager.getInstance().reset();
        super.dispose();
    }

    public String getHelpRef() {
        String helpRef;
        block4: {
            CustomPanel cp;
            helpRef = null;
            if (this.currentPanel != null && (cp = this.currentPanel.getPanel()) != null) {
                try {
                    helpRef = cp.getHelpRef();
                }
                catch (Exception e) {
                    helpRef = null;
                    ConfigurationOfferingNode offNode = this.currentPanel.getParent();
                    if (offNode == null) break block4;
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)offNode.getJob(), (ICustomPanel)cp, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
            }
        }
        if (helpRef == null) {
            helpRef = super.getHelpRef();
        }
        return helpRef;
    }
}

