/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.BaseJobContentProvider;
import com.ibm.cic.agent.internal.ui.utils.FixContainerNode;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.AvailableFixSection;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenFixesInRepPage;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ResponseFileGenFixesInRepSection
extends AvailableFixSection {
    private JobContentProvider contentProvider;
    private JobLabelProvider labelProvider;
    private FixContainerNode fixContainer;

    public ResponseFileGenFixesInRepSection(IFormContext context, Composite parent, ResponseFileGenFixesInRepPage wizardPage) {
        super(context, parent, wizardPage, new String[]{Messages.AvailableUpdateSection_selectRecommendedBtn}, true);
        this.roots = new HashMap();
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
    }

    @Override
    protected void buildVersionTree(List<AgentJob> offeringJobs, List fixJobs) {
        int i = 0;
        while (i < fixJobs.size()) {
            AbstractJob fixJob = (AbstractJob)fixJobs.get(i);
            IFix fix = fixJob.getFix();
            boolean hasAppliedOffering = false;
            for (AgentJob offeringJob : offeringJobs) {
                IOffering offering = offeringJob.getOffering();
                if (offering == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                hasAppliedOffering = true;
                VersionNode parent = (VersionNode)this.roots.get(offering);
                if (parent == null) {
                    parent = new VersionNode((AbstractJob)offeringJob, null, false);
                    this.roots.put(offering, parent);
                }
                FixNode fixNode = new FixNode(fixJob, parent, false);
                parent.getFixes().add(fixNode);
                if (!fixNode.isRecommended()) continue;
                this.recommendedNodes.add(fixNode);
            }
            if (!hasAppliedOffering) {
                if (this.fixContainer == null) {
                    this.fixContainer = new FixContainerNode();
                }
                FixNode fNode = new FixNode(fixJob, this.fixContainer, false);
                this.fixContainer.addChild(fNode);
                if (fNode.isRecommended()) {
                    this.recommendedNodes.add(fNode);
                }
            }
            ++i;
        }
    }

    @Override
    protected void clearAllSelection() {
        super.clearAllSelection();
        if (this.fixContainer != null) {
            CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
            this.elementChecked(viewer, this.fixContainer, false);
        }
    }

    @Override
    protected Object[] getTreeInput() {
        ArrayList inputList = new ArrayList(this.roots.values());
        if (this.fixContainer != null) {
            inputList.add(this.fixContainer);
        }
        return inputList.toArray();
    }

    @Override
    protected void resetTreeViewer(boolean checkDefaultSelectedJobs) {
        this.fixContainer = null;
        super.resetTreeViewer(checkDefaultSelectedJobs);
    }

    @Override
    protected boolean isNonRecommendedFixesAvailable() {
        boolean existing = super.isNonRecommendedFixesAvailable();
        if (existing) {
            return true;
        }
        if (this.fixContainer != null) {
            List<FixNode> children = this.fixContainer.getChildren();
            for (FixNode fixNode : children) {
                if (fixNode.isRecommended()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new JobContentProvider();
        }
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new JobLabelProvider(DisplayKeeper.INSTANCE.getDisplay());
        }
        return this.labelProvider;
    }

    @Override
    protected List<FixNode> getExtraFixNodes() {
        if (this.fixContainer != null) {
            return this.fixContainer.getChildren();
        }
        return new ArrayList<FixNode>(1);
    }

    private static class JobContentProvider
    extends BaseJobContentProvider {
        private JobContentProvider() {
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof FixContainerNode) {
                return ((FixContainerNode)parentElement).getChildren().toArray();
            }
            return super.getChildren(parentElement);
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof FixContainerNode) {
                return ((FixContainerNode)element).getChildren().size() > 0;
            }
            return super.hasChildren(element);
        }
    }

    private static class JobLabelProvider
    extends AvailableFixSection.FixTreeJobLabelProvider {
        public JobLabelProvider(Display display) {
            super(display);
        }

        @Override
        public String getText(Object element) {
            if (element instanceof FixContainerNode) {
                return Messages.ResponseFileGenerator_FixPage_ContainerNode;
            }
            return super.getText(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof FixContainerNode) {
                return this.agentLabelProvider.get(CICImages.DESC_CATEGORY_OBJ);
            }
            return super.getImage(element);
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            return null;
        }
    }
}

