/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.ResponseFileFromRepositories;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenFixesInRepPage;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenOfferingsInRepPage;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenRepositoryPage;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenWizard;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.ui.CICImages;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;

public class ResponseFileGenAvailablePkgWizard
extends ResponseFileGenWizard {
    private Collection<IRepository> repositories = new ArrayList<IRepository>(1);
    private final List<AbstractJob> selectedOfferingJobs = new ArrayList<AbstractJob>();
    private final List<AbstractJob> selectedFixJobs = new ArrayList<AbstractJob>();
    private List allOfferings = new ArrayList(1);
    private List allFixes = new ArrayList(1);
    private boolean fixChanged;

    public ResponseFileGenAvailablePkgWizard() {
        super(CICImages.WIZ_INSTALL);
    }

    @Override
    protected void addContentPages() {
        this.addPage((IWizardPage)new ResponseFileGenRepositoryPage(this.toolkit, Messages.importPermanentOffering_repositoryPage, Messages.ResponseFileGenerator_RepPage_Des, this));
        this.addPage((IWizardPage)new ResponseFileGenOfferingsInRepPage(this.toolkit, Messages.InstallSummaryPage_featureTableTitle, Messages.ResponseFileGenerator_PkgPage_Des, this));
        this.addPage((IWizardPage)new ResponseFileGenFixesInRepPage(this.toolkit, Messages.AvailableFixSection_fixCol, Messages.ResponseFileGenerator_FixPage_Des, this));
    }

    @Override
    protected void doGen(String outputFile) throws CoreException {
        IOfferingOrFix offeringOrFix;
        ResponseFileFromRepositories responseFileGen = new ResponseFileFromRepositories(this.repositories);
        for (AbstractJob job : this.selectedOfferingJobs) {
            offeringOrFix = job.getOfferingOrFix();
            responseFileGen.addPackage(offeringOrFix.getIdentity(), offeringOrFix.getVersion());
        }
        for (AbstractJob job : this.selectedFixJobs) {
            offeringOrFix = job.getOfferingOrFix();
            responseFileGen.addPackage(offeringOrFix.getIdentity(), offeringOrFix.getVersion());
        }
        responseFileGen.generate(new File(outputFile));
    }

    public boolean setSelectedRepositories(Collection<IRepository> reps) {
        boolean repChanged = !Arrays.deepEquals(this.repositories.toArray(), reps.toArray());
        this.repositories = reps;
        return repChanged;
    }

    void setOfferingSelections(List selection) {
        this.selectedOfferingJobs.clear();
        this.selectedOfferingJobs.addAll(selection);
    }

    List<AbstractJob> getSelectedOfferingJobs() {
        return this.selectedOfferingJobs;
    }

    void setFixSelections(List selection) {
        this.selectedFixJobs.clear();
        this.selectedFixJobs.addAll(selection);
    }

    List<AbstractJob> getSelectedFixJobs() {
        return this.selectedFixJobs;
    }

    protected AbstractJob createJob(IOfferingOrFix offeringOrFix) {
        InstallJob job = new InstallJob(offeringOrFix);
        job.setSelected(false);
        return job;
    }

    public void setAllOfferings(List offerings) {
        this.allOfferings = offerings;
    }

    public void setAllFixes(List fixes) {
        this.fixChanged = !Arrays.deepEquals(this.allFixes.toArray(), fixes.toArray());
        this.allFixes = fixes;
    }

    public List getAllOfferings() {
        return this.allOfferings;
    }

    public List getAllFixes() {
        return this.allFixes;
    }

    public boolean getFixChanged() {
        return this.fixChanged;
    }
}

