/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class PrimaryWizard
extends AbstractAgentUIWizard {
    private AbstractAgentUIPrimaryPage[] primaryPages;
    private final String finishButtonLabel;
    private IWizard constructedWizard;

    public PrimaryWizard(String defaultTitle, String finishButtonLabel) {
        this(defaultTitle, finishButtonLabel, CICImages.WIZ_INSTALL);
    }

    public PrimaryWizard(String defaultTitle, String finishButtonLabel, ImageDescriptor imageDes) {
        super(null, defaultTitle, imageDes);
        this.finishButtonLabel = finishButtonLabel;
        this.unloadAgentBundles();
    }

    public void setPrimaryPages(AbstractAgentUIPrimaryPage[] pages) {
        this.primaryPages = pages;
    }

    public IWizardPage[] getPrimaryPages() {
        return this.primaryPages;
    }

    public void addPages() {
        if (this.primaryPages != null) {
            AbstractAgentUIPrimaryPage[] abstractAgentUIPrimaryPageArray = this.primaryPages;
            int n = this.primaryPages.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAgentUIPrimaryPage primaryPage = abstractAgentUIPrimaryPageArray[n2];
                this.addPage((IWizardPage)primaryPage);
                ++n2;
            }
        }
    }

    public boolean performCancel() {
        boolean isPrimaryPageActive = false;
        AbstractAgentUIPrimaryPage[] abstractAgentUIPrimaryPageArray = this.primaryPages;
        int n = this.primaryPages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAgentUIPrimaryPage primaryPage = abstractAgentUIPrimaryPageArray[n2];
            if (primaryPage.getControl().isVisible()) {
                isPrimaryPageActive = true;
                break;
            }
            ++n2;
        }
        if (!isPrimaryPageActive) {
            return true;
        }
        IWizard wizard = this.constructedWizard;
        if (wizard == null) {
            Logger.getGlobalLogger().statusNotOK(Agent.getInstance().restoreOriginalIM());
            this.checkForProductRestart();
            this.unloadAgentBundles();
            return true;
        }
        return wizard.performCancel();
    }

    public boolean performFinish() {
        boolean isPrimaryPageActive = false;
        AbstractAgentUIPrimaryPage[] abstractAgentUIPrimaryPageArray = this.primaryPages;
        int n = this.primaryPages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAgentUIPrimaryPage primaryPage = abstractAgentUIPrimaryPageArray[n2];
            if (primaryPage.getControl().isVisible()) {
                isPrimaryPageActive = true;
                break;
            }
            ++n2;
        }
        if (!isPrimaryPageActive) {
            return true;
        }
        IWizard wizard = this.constructedWizard;
        if (wizard == null) {
            Logger.getGlobalLogger().statusNotOK(Agent.getInstance().restoreOriginalIM());
            this.checkForProductRestart();
            this.unloadAgentBundles();
            return true;
        }
        return wizard.performFinish();
    }

    protected void setConstructedWizard(IWizard wizard) {
        this.constructedWizard = wizard;
    }

    protected IWizard getConstructedWizard() {
        return this.constructedWizard;
    }

    @Override
    public IWizardPage getCompletionPage(IStatus completionStatus) {
        IWizard wizard = this.constructedWizard;
        if (wizard instanceof AbstractCicWizard) {
            return ((AbstractCicWizard)wizard).getCompletionPage(completionStatus);
        }
        return null;
    }

    public String getFinishLabel() {
        return this.finishButtonLabel;
    }

    public void setInput(Object[] inputElements) {
        this.primaryPages[0].setInput(inputElements);
    }

    public boolean canFinish() {
        IWizard wizard = this.constructedWizard;
        if (wizard == null) {
            return false;
        }
        return super.canFinish() && wizard.canFinish();
    }

    private void unloadAgentBundles() {
        IStatus status = Agent.getInstance().unloadAgentBundles((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            AgentUI.getDefault().getLog().log(status);
        }
    }

    private void checkForProductRestart() {
        if (this.primaryPages == null || this.primaryPages.length == 0) {
            return;
        }
        Object[] selections = this.primaryPages[0].getSelections();
        if (selections == null || selections.length == 0) {
            return;
        }
        Profile profile = null;
        if (selections instanceof AbstractJob[]) {
            AbstractJob job = (AbstractJob)selections[0];
            profile = job.getProfile();
        } else if (selections instanceof Profile[]) {
            profile = (Profile)selections[0];
        }
        if (profile == null) {
            return;
        }
        if (!CmdLine.CL.containsCommand("-restartPackage")) {
            return;
        }
        IOffering[] offerings = Agent.getInstance().getInstalledOfferings(profile);
        AgentUI.getDefault().prepareOfferings((IOfferingOrFix[])offerings);
        AgentUIUtils.checkForProductRestart(this.getShell(), profile);
    }
}

