/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.SummaryFeatureLabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.EditInstallSummaryPage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ModifySummaryPage
extends EditInstallSummaryPage {
    private Section featuresSection;
    private TreeViewer addFeatureViewer;
    private TreeViewer removeFeatureViewer;
    private final Map jobAddFeaturesMap = new HashMap();
    private final Map jobRemoveFeaturesMap = new HashMap();

    public ModifySummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.ModifySummaryPage");
    }

    @Override
    protected void createFeatureControl(Composite container) {
        IWizardPage[] pages;
        this.featuresSection = this.getToolkit().createSection(container, 512);
        this.featuresSection.setText(Messages.ConfirmationPage_optionalFeatures);
        Composite featuresComposite = this.getToolkit().createComposite((Composite)this.featuresSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        featuresComposite.setLayout((Layout)layout);
        this.featuresSection.setClient((Control)featuresComposite);
        this.featuresSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftComp = this.getToolkit().createComposite(featuresComposite);
        GridLayout leftCompLayout = new GridLayout();
        leftCompLayout.marginHeight = 0;
        leftComp.setLayout((Layout)leftCompLayout);
        leftComp.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 68356;
        this.addFeatureViewer = new TreeViewer(leftComp, style);
        GridData addFeatureData = new GridData(1808);
        addFeatureData.heightHint = this.addFeatureViewer.getTree().getItemHeight() * 3;
        this.addFeatureViewer.getTree().setLayoutData((Object)addFeatureData);
        this.addFeatureViewer.getTree().setLinesVisible(false);
        this.addFeatureViewer.getTree().setHeaderVisible(true);
        TreeColumn featureCol1 = new TreeColumn(this.addFeatureViewer.getTree(), 16384);
        featureCol1.setText(Messages.ModifySummaryPage_addFeatureCol);
        featureCol1.setWidth(200);
        this.addFeatureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((ModifySummaryPage)ModifySummaryPage.this).addFeatureViewer.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn col = ModifySummaryPage.this.addFeatureViewer.getTree().getColumn(0);
                col.setWidth(treeWidth - scrollBarWidth);
            }
        });
        Composite rightComp = this.getToolkit().createComposite(featuresComposite);
        GridLayout rightCompLayout = new GridLayout();
        rightCompLayout.marginHeight = 0;
        rightComp.setLayout((Layout)rightCompLayout);
        rightComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.removeFeatureViewer = new TreeViewer(rightComp, style);
        GridData removeFeatureData = new GridData(1808);
        removeFeatureData.heightHint = this.removeFeatureViewer.getTree().getItemHeight() * 3;
        this.removeFeatureViewer.getTree().setLayoutData((Object)removeFeatureData);
        this.removeFeatureViewer.getTree().setLinesVisible(false);
        this.removeFeatureViewer.getTree().setHeaderVisible(true);
        TreeColumn featureCol2 = new TreeColumn(this.removeFeatureViewer.getTree(), 16384);
        featureCol2.setText(Messages.ModifySummaryPage_removeFeatureCol);
        this.removeFeatureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((ModifySummaryPage)ModifySummaryPage.this).removeFeatureViewer.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn col = ModifySummaryPage.this.removeFeatureViewer.getTree().getColumn(0);
                col.setWidth(treeWidth - scrollBarWidth);
            }
        });
        IWizardPage featurePage = null;
        IWizardPage[] iWizardPageArray = pages = this.getWizard().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof FeatureSelectionPage) {
                featurePage = page;
                break;
            }
            ++n2;
        }
        if (featurePage == null) {
            return;
        }
        ITreeContentProvider contentProvider = ((FeatureSelectionPage)featurePage).getFeatureContentProvider();
        this.addFeatureViewer.setContentProvider((IContentProvider)contentProvider);
        this.addFeatureViewer.setLabelProvider((IBaseLabelProvider)new SummaryFeatureLabelProvider());
        this.addFeatureViewer.addFilter((ViewerFilter)new AddRemoveFeatureFilter(true));
        this.addFeatureViewer.setInput(null);
        this.removeFeatureViewer.setContentProvider((IContentProvider)contentProvider);
        this.removeFeatureViewer.setLabelProvider((IBaseLabelProvider)new SummaryFeatureLabelProvider());
        this.removeFeatureViewer.addFilter((ViewerFilter)new AddRemoveFeatureFilter(false));
        this.removeFeatureViewer.setInput(null);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showFeatures();
            this.reflowFor((Control)this.addFeatureViewer.getTree());
        }
        super.setVisible(visible);
    }

    private boolean containsFeature(IFeatureGroup group, Set features) {
        List childrenGroup;
        boolean result = false;
        List childrenFeature = group.getFeatures();
        if (childrenFeature != null) {
            int i = 0;
            while (i < childrenFeature.size()) {
                if (features.contains(childrenFeature.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        if ((childrenGroup = group.getGroups()) != null) {
            int i = 0;
            while (i < childrenGroup.size()) {
                if (this.containsFeature((IFeatureGroup)childrenGroup.get(i), features)) {
                    return true;
                }
                ++i;
            }
        }
        return result;
    }

    private Object[] getRootNodes(List jobs) {
        ArrayList<AbstractJob> rootNodes = new ArrayList<AbstractJob>(jobs.size());
        ITreeContentProvider featureContentProvider = (ITreeContentProvider)this.addFeatureViewer.getContentProvider();
        for (AbstractJob job : jobs) {
            Object[] children;
            ModifyJob modifyJob;
            IOfferingOrFix offeringOrFix;
            if (!(job instanceof ModifyJob) || !((offeringOrFix = (modifyJob = (ModifyJob)job).getOfferingOrFix()) instanceof IOffering) || (children = featureContentProvider.getChildren((Object)job)) == null || children.length <= 0) continue;
            rootNodes.add(job);
            ArrayList addedFeatures = new ArrayList();
            ArrayList removedFeatures = new ArrayList();
            modifyJob.determineFeaturesToAddRemove((IAgent)AgentUI.getDefault().getAgent(), addedFeatures, removedFeatures);
            this.jobAddFeaturesMap.put(job, new HashSet(addedFeatures));
            this.jobRemoveFeaturesMap.put(job, new HashSet(removedFeatures));
        }
        return rootNodes.toArray(new Object[rootNodes.size()]);
    }

    private void showFeatures() {
        TreeItem item;
        List jobs = SortUtil.sortByProfileNameAndVersion((List)this.getSelectedJobs(), (boolean)false);
        Object[] roots = this.getRootNodes(jobs);
        this.addFeatureViewer.setInput((Object)roots);
        this.addFeatureViewer.expandAll();
        this.removeFeatureViewer.setInput((Object)roots);
        this.removeFeatureViewer.expandAll();
        Tree addTree = this.addFeatureViewer.getTree();
        Tree removeTree = this.removeFeatureViewer.getTree();
        boolean hasChangedFeatures = addTree.getItemCount() > 0 || removeTree.getItemCount() > 0;
        this.featuresSection.setVisible(hasChangedFeatures);
        GridData gridData = (GridData)this.featuresSection.getLayoutData();
        gridData.exclude = !hasChangedFeatures;
        this.featuresSection.getParent().layout();
        if (!hasChangedFeatures) {
            return;
        }
        if (addTree.getItemCount() > 0) {
            item = addTree.getItem(0);
            addTree.setTopItem(item);
        }
        if (removeTree.getItemCount() > 0) {
            item = removeTree.getItem(0);
            removeTree.setTopItem(item);
        }
        this.addFeatureViewer.getTree().setEnabled(false);
        this.addFeatureViewer.getTree().setEnabled(true);
        this.removeFeatureViewer.getTree().setEnabled(false);
        this.removeFeatureViewer.getTree().setEnabled(true);
        if (addTree.getItemCount() > 0) {
            addTree.getColumn(0).pack();
        }
        if (removeTree.getItemCount() > 0) {
            removeTree.getColumn(0).pack();
        }
    }

    class AddRemoveFeatureFilter
    extends ViewerFilter {
        private final boolean add;

        public AddRemoveFeatureFilter(boolean add) {
            this.add = add;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AbstractJob) {
                Set featureSet = null;
                featureSet = this.add ? (Set)ModifySummaryPage.this.jobAddFeaturesMap.get(element) : (Set)ModifySummaryPage.this.jobRemoveFeaturesMap.get(element);
                return featureSet != null && !featureSet.isEmpty();
            }
            if (element instanceof FeatureSelectionPage.FeatureGroupNode) {
                FeatureSelectionPage.FeatureGroupNode groupNode = (FeatureSelectionPage.FeatureGroupNode)element;
                if (!groupNode.isVisible()) return false;
                Object parentNode = groupNode.getParent();
                while (parentNode != null && !(parentNode instanceof AbstractJob) && parentNode instanceof FeatureSelectionPage.FeatureGroupNode) {
                    parentNode = ((FeatureSelectionPage.FeatureGroupNode)parentNode).getParent();
                }
                if (parentNode == null || !(parentNode instanceof AbstractJob)) return true;
                Set featureSet = null;
                featureSet = this.add ? (Set)ModifySummaryPage.this.jobAddFeaturesMap.get(parentNode) : (Set)ModifySummaryPage.this.jobRemoveFeaturesMap.get(parentNode);
                if (featureSet != null && !featureSet.isEmpty()) return ModifySummaryPage.this.containsFeature(groupNode.getFeatureGroup(), featureSet);
                return false;
            }
            if (!(element instanceof FeatureSelectionPage.FeatureNode)) return true;
            FeatureSelectionPage.FeatureNode featureNode = (FeatureSelectionPage.FeatureNode)element;
            if (!featureNode.isVisible()) return false;
            Object parentNode = featureNode.getParent();
            while (parentNode != null && !(parentNode instanceof AbstractJob) && parentNode instanceof FeatureSelectionPage.FeatureGroupNode) {
                parentNode = ((FeatureSelectionPage.FeatureGroupNode)parentNode).getParent();
            }
            if (parentNode == null || !(parentNode instanceof AbstractJob)) return true;
            Set featureSet = null;
            featureSet = this.add ? (Set)ModifySummaryPage.this.jobAddFeaturesMap.get(parentNode) : (Set)ModifySummaryPage.this.jobRemoveFeaturesMap.get(parentNode);
            if (featureSet != null && !featureSet.isEmpty()) return featureSet.contains(featureNode.getFeature());
            return false;
        }
    }
}

