/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EditInstallSummaryPage
extends SummaryPage {
    private Text languageText;
    private Text eclipseIDE;
    private Text eclipseJVM;

    public EditInstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
    }

    public EditInstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard, String description) {
        super(toolkit, wizard, description);
    }

    @Override
    protected void createEnvSpaceSummaryControl(Composite container) {
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createEnvironmentControl(comp);
        this.createSpaceSummaryControl(comp);
    }

    protected void createEnvironmentControl(Composite container) {
        Section environmentSection = this.getToolkit().createSection(container, 512);
        environmentSection.setText(Messages.SummaryPage_environmentTitle);
        Composite environmentComposite = this.getToolkit().createComposite((Composite)environmentSection);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        environmentComposite.setLayout((Layout)layout);
        environmentComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        environmentSection.setClient((Control)environmentComposite);
        GridData gridData = new GridData(4, 4, true, true);
        environmentSection.setLayoutData((Object)gridData);
        int orignalBorderStyle = this.getToolkit().getBorderStyle();
        this.getToolkit().setBorderStyle(0);
        this.languageText = this.getToolkit().createText(environmentComposite, "", 74);
        GridData data = new GridData(4, 1, true, false);
        this.languageText.setLayoutData((Object)data);
        this.eclipseIDE = this.getToolkit().createText(environmentComposite, "", 74);
        this.eclipseIDE.setLayoutData((Object)new GridData(4, 1, true, false));
        this.eclipseJVM = this.getToolkit().createText(environmentComposite, "", 74);
        this.eclipseJVM.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getToolkit().setBorderStyle(orignalBorderStyle);
    }

    protected void showEnvironment() {
        List profiles = this.getProfiles();
        if (profiles.size() > 0) {
            Profile profile = null;
            profile = InstallAgentUtils.onlyAgentJob(this.getSelectedJobs()) ? (Profile)profiles.get(0) : this.getAgentWizard().getProductProfile();
            this.showEnvironmentForProfile(profile);
        }
    }

    protected void showEnvironmentForProfile(Profile profile) {
        String languages = (String)this.getProfileLocalLanguagesMap().get(profile);
        if (languages == null) {
            languages = profile.getData("cic.selector.nl");
        }
        if (languages != null) {
            TreeSet<String> languageSet = new TreeSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(languages, ",");
            while (tokenizer.hasMoreTokens()) {
                Locale locale;
                String localeName;
                String token = tokenizer.nextToken();
                String langLabel = (String)ProfileLanguageUtils.getLocaleCodeLabelMap().get(token);
                if (langLabel != null) {
                    languageSet.add(langLabel);
                    continue;
                }
                String unmappedLocaleCode = token.trim();
                if (unmappedLocaleCode.length() <= 0 || (localeName = (locale = new Locale(unmappedLocaleCode)).getDisplayLanguage()) == null || localeName.trim().length() <= 0) continue;
                languageSet.add(localeName);
            }
            StringBuffer displayableLangName = new StringBuffer();
            for (String label : languageSet) {
                if (displayableLangName.length() > 0) {
                    displayableLangName.append(", ");
                }
                displayableLangName.append(label);
            }
            this.languageText.setText(displayableLangName.toString());
        } else {
            this.languageText.setText("");
        }
        this.languageText.redraw();
        if (profile.isExistingEclipseProfile()) {
            String eclipseJVMLocation;
            String eclipseIDELocation = profile.getEclipseLocation();
            if (eclipseIDELocation != null && eclipseIDELocation.length() > 0) {
                String location = String.valueOf(Messages.SummaryPage_eclipseIDELabel) + " " + eclipseIDELocation;
                this.eclipseIDE.setText(location);
            }
            if ((eclipseJVMLocation = profile.getData("existing.jre.for.eclipse.ide.java.home")) != null && eclipseJVMLocation.length() > 0) {
                String jvm = String.valueOf(Messages.SummaryPage_eclipseJVMLabel) + " " + eclipseJVMLocation;
                this.eclipseJVM.setText(jvm);
            }
        } else {
            this.eclipseIDE.setText("");
            this.eclipseJVM.setText("");
        }
        this.eclipseIDE.redraw();
        this.eclipseJVM.redraw();
        this.reflowFor((Control)this.languageText);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showEnvironment();
        }
        super.setVisible(visible);
    }
}

