/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogDialog;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.services.UiServices;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class CompletionPage
extends AbstractAgentUIWizardPage {
    private final AgentUILabelProvider labelProvider;
    protected Label resultText;
    protected FormText viewLogText;
    protected String detailResultString;
    protected boolean detailResultTextFormating = false;
    protected FormText detailResultText;
    protected AgentUIWizard wizard;
    protected int result = 0;
    protected IStatus status = null;
    protected boolean createSpaceNoticeControl = false;
    protected boolean offeringsInstalled = false;

    public CompletionPage(FormToolkit toolkit, String pageTitle, String pageDes, AgentUIWizard wizard, IStatus status) {
        super(toolkit, pageTitle, pageDes, wizard);
        this.wizard = wizard;
        this.status = status;
        this.setResult(status);
        this.labelProvider = AgentUI.getDefault().getLabelProvider();
        this.labelProvider.connect((Object)this);
        this.setWizard(wizard);
    }

    private void setResult(IStatus status) {
        this.result = status.getSeverity() == 2 ? 3 : (status.getSeverity() == 4 ? 1 : (status.getSeverity() == 8 ? 2 : 0));
    }

    public void setResult(int result) {
        this.result = result;
    }

    public Label getResultText() {
        return this.resultText;
    }

    public String getDetailResultString() {
        return this.detailResultString;
    }

    public FormText getDetailResultText() {
        return this.detailResultText;
    }

    public boolean getDetailResultTextFormatingMode() {
        return this.detailResultTextFormating;
    }

    public void dispose() {
        AgentUI.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private boolean areOfferingsInstalled() {
        List jobs = this.getSelectedJobs();
        int i = 0;
        while (i < jobs.size()) {
            IOffering installedOffering;
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (!job.isInstall() && !job.isUpdate()) {
                return false;
            }
            Profile profile = job.getProfile();
            IOffering offering = job.getOffering();
            if (offering != null && (installedOffering = AgentUI.getDefault().getAgent().getInstalledOffering(profile, offering.getIdentity())) != null && installedOffering.getVersion().equals((Object)offering.getVersion())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void createControl(Composite parent) {
        this.offeringsInstalled = this.areOfferingsInstalled();
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.createResultControl(container);
        Composite sub_container = this.createDetailControl(container);
        this.createSpaceNoticeControl(sub_container);
        this.createRebootControl(sub_container);
        this.createConfigureLicenseControl(sub_container);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected void reflowFor(Control c) {
        AgentUIUtils.reflowForControl(c);
    }

    protected void createResultControl(Composite container) {
        Section section = this.getToolkit().createSection(container, 4096);
        Composite resultComp = this.getToolkit().createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        resultComp.setLayout((Layout)gridLayout);
        section.setClient((Control)resultComp);
        section.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        Label resultImage = this.getToolkit().createLabel(resultComp, "", 0);
        if (this.result == 0) {
            resultImage.setImage(this.labelProvider.get(CICImages.SUCCESS));
        } else if (this.result == 3) {
            resultImage.setImage(this.labelProvider.get(CICImages.WARNING));
        } else {
            resultImage.setImage(this.labelProvider.get(CICImages.FAIL));
        }
        this.resultText = this.getToolkit().createLabel(resultComp, "", 0);
        this.viewLogText = this.getToolkit().createFormText(resultComp, false);
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                File logFile = LogManager.getDefaultLogFile();
                ViewLogDialog dlg = new ViewLogDialog(window.getShell(), logFile);
                dlg.open();
            }
        };
        this.viewLogText.setHyperlinkSettings((HyperlinkSettings)this.getToolkit().getHyperlinkGroup());
        this.viewLogText.addHyperlinkListener((IHyperlinkListener)urlAction);
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p>");
        buf.append("<a href=\"\">" + Messages.CompletionPage_viewLog + "</a>");
        buf.append("</p></form>");
        this.viewLogText.setText(buf.toString(), true, false);
    }

    protected void createDetailResultTextControl(Composite container, int spanColumnNum) {
        if (this.status == null) {
            return;
        }
        boolean useFormTextTags = StatusUtil.hasAnchor((IStatus)this.status);
        this.detailResultString = CommonUIUtils.generateDetailResultText((int)this.status.getSeverity(), (IStatus)this.status, (boolean)useFormTextTags);
        if (this.detailResultString == null || this.detailResultString.equals("")) {
            return;
        }
        Composite resultComp = this.getToolkit().createComposite(container);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 0;
        resultComp.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = spanColumnNum;
        resultComp.setLayoutData((Object)gridData);
        SharedScrolledComposite detailScrolledForm = new SharedScrolledComposite(resultComp, 0xA00 | this.getToolkit().getOrientation()){};
        this.getToolkit().adapt((Composite)detailScrolledForm);
        detailScrolledForm.setExpandVertical(true);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.heightHint = 65;
        detailScrolledForm.setLayoutData((Object)gridData2);
        this.detailResultText = new FormText((Composite)detailScrolledForm, 64);
        this.getToolkit().adapt((Control)this.detailResultText, true, true);
        this.detailResultText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailResultText.setParagraphsSeparated(false);
        if (useFormTextTags) {
            try {
                this.detailResultText.setWhitespaceNormalized(true);
                this.detailResultTextFormating = true;
                this.detailResultText.setText("<form>" + this.detailResultString + "</form>", true, false);
            }
            catch (IllegalArgumentException e) {
                this.detailResultString = CommonUIUtils.generateDetailResultText((int)this.status.getSeverity(), (IStatus)this.status, (boolean)false);
                this.detailResultText.setWhitespaceNormalized(false);
                this.detailResultTextFormating = false;
                this.detailResultText.setText(this.detailResultString, false, true);
            }
        } else {
            this.detailResultText.setWhitespaceNormalized(false);
            this.detailResultTextFormating = false;
            this.detailResultText.setText(this.detailResultString, false, true);
        }
        this.detailResultText.setHyperlinkSettings((HyperlinkSettings)this.getToolkit().getHyperlinkGroup());
        this.detailResultText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = e.getHref().toString();
                if (!UiServices.getInstance().launchProgram(href)) {
                    UiServices.getInstance().findAndExecuteProgram(".xml", href);
                }
            }
        });
        detailScrolledForm.setContent((Control)this.detailResultText);
    }

    protected Composite createDetailControl(Composite container) {
        return container;
    }

    protected boolean needCreateSpaceNoticeControl() {
        if (!AgentUtil.onlyInstallAgent((List)this.getSelectedJobs()) && (this.result == 0 || this.result == 1 && this.offeringsInstalled)) {
            return !Agent.getInstance().isPortable() && CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.PRESERVE_DOWNLOADED_ARTIFACTS.key());
        }
        return false;
    }

    protected void createSpaceNoticeControl(Composite container) {
    }

    protected void createRebootControl(Composite container) {
    }

    protected void createConfigureLicenseControl(Composite container) {
    }

    public void performDone() {
    }

    @Override
    protected void setFocus() {
        this.setPageComplete(true);
    }

    public String getCompletionPageFinishLabel() {
        return null;
    }
}

