/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.BaseJobNodeLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.OnlyFixesNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdatePage;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeFilterSection;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.StructuredViewerPart;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class AvailableUpdateSection
extends CheckboxTreeFilterSection {
    private Button showRecommendedButton;
    private RecommendedFilter filter;
    private final List recommendedNodes = new ArrayList();
    private final List<OnlyFixesNode> onlyFixesNodes = new ArrayList<OnlyFixesNode>();
    private JobContentProvider contentProvider;
    private List currentProfiles = new ArrayList();
    private final Map<Profile, ProfileNode> profilesMap = new HashMap<Profile, ProfileNode>();
    private final AvailableUpdatePage updatePage;
    private Map repLocationMsgMap = new HashMap();
    private boolean hasUpdateOfferings = false;
    private boolean hasFixForInstalledOfferings = false;

    public AvailableUpdateSection(IFormContext context, Composite parent, AvailableUpdatePage wizardPage) {
        super(context, parent, 4096, new String[]{Messages.AvailableUpdateSection_selectRecommendedBtn}, 256);
        this.updatePage = wizardPage;
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
        this.getSection().setText(Messages.AvailableUpdateSection_title);
    }

    @Override
    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new CheckboxTreeFilterSection.TreeViewerWithFilterPartAdapter(this, buttonLabels, this.buttonsOrientation);
    }

    private void buildVersionTree(List inputElement) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask(Messages.AvailableUpdateSection_progressMsg, AvailableUpdateSection.this.currentProfiles.size());
                    for (Profile profile : AvailableUpdateSection.this.currentProfiles) {
                        ProfileNode profileNode = (ProfileNode)AvailableUpdateSection.this.profilesMap.get(profile);
                        if (profileNode == null) {
                            profileNode = AvailableUpdateSection.this.createProfileNode(profile, monitor);
                            AvailableUpdateSection.this.profilesMap.put(profile, profileNode);
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.recommendedNodes.clear();
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private void checkRecommended() {
        List previousSelectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        for (Object node : this.getLeafRecommendedNodes()) {
            VersionNode vnode;
            this.updateParents(this.getCheckboxTreeViewer(), node, true);
            if (node instanceof VersionNode && (vnode = (VersionNode)node).isUnavailable()) continue;
            this.getCheckboxTreeViewer().setChecked(node, true);
        }
        List currentSelectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        ArrayList addedUpdates = new ArrayList(currentSelectedJobs);
        ArrayList deselectedUpdates = new ArrayList(previousSelectedJobs);
        addedUpdates.removeAll(previousSelectedJobs);
        deselectedUpdates.removeAll(currentSelectedJobs);
        this.updatePage.validateSelectedUpdates(addedUpdates, deselectedUpdates);
        this.updatePage.updateButtons();
    }

    private List getLeafRecommendedNodes() {
        ArrayList leafRecommendedNodes = new ArrayList();
        int i = 0;
        while (i < this.recommendedNodes.size()) {
            VersionNode versionNode;
            List fixes;
            Object element = this.recommendedNodes.get(i);
            if (element instanceof FixNode || element instanceof OnlyFixesNode) {
                leafRecommendedNodes.add(element);
            } else if (element instanceof VersionNode && (fixes = (versionNode = (VersionNode)element).getFixes()).isEmpty()) {
                leafRecommendedNodes.add(versionNode);
            }
            ++i;
        }
        return leafRecommendedNodes;
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        this.contentProvider = new JobContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new BaseJobNodeLabelProvider(DisplayKeeper.INSTANCE.getDisplay()){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 3) {
                    boolean isUnavailable = false;
                    if (element instanceof VersionNode) {
                        VersionNode versionNode = (VersionNode)element;
                        isUnavailable = versionNode.isUnavailable();
                    } else if (element instanceof FixNode) {
                        FixNode fixNode = (FixNode)element;
                        isUnavailable = fixNode.isUnavailable();
                    }
                    if (isUnavailable) {
                        return Messages.AvailableOfferingSection_notEntitled;
                    }
                }
                return super.getColumnText(element, columnIndex);
            }

            @Override
            public Color getForeground(Object element, int columnIndex) {
                FixNode fixNode;
                VersionNode versionNode;
                Color result = super.getForeground(element, columnIndex);
                if ((columnIndex == 1 || columnIndex == 2 || columnIndex == 3) && (element instanceof VersionNode ? !(versionNode = (VersionNode)element).canBeInstalled() : element instanceof FixNode && !(fixNode = (FixNode)element).canBeInstalled())) {
                    return this.disabledColor;
                }
                return result;
            }
        });
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setSorter((ViewerSorter)new OfferingSorter());
        this.createColumns(viewer);
        viewer.setInput(null);
        this.filterBoxPart.setFilterContainerVisible(false);
    }

    protected void checkInputChanged() {
        this.checkInputChanged(false);
    }

    protected void checkInputChanged(boolean refresh) {
        List<Profile> newProfiles = Arrays.asList(this.updatePage.getProfiles());
        if (!newProfiles.equals(this.currentProfiles) || refresh) {
            this.currentProfiles = newProfiles;
            this.profilesMap.clear();
            PrimaryUpdateWizard wizard = this.updatePage.getPrimaryUpdateWizard();
            wizard.getJobs().clear();
            this.createRootNodes(this.currentProfiles);
            CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
            if (!this.hasUpdateOfferings && !this.hasFixForInstalledOfferings) {
                viewer.getTree().setEnabled(false);
                this.showRecommendedButton.setEnabled(false);
                this.getTreePart().setButtonEnabled(0, false);
            } else {
                viewer.getTree().setEnabled(true);
                this.showRecommendedButton.setEnabled(true);
                this.getTreePart().setButtonEnabled(0, true);
                if (this.hasUpdateOfferings) {
                    viewer.getTree().getColumn(0).setText(Messages.AvailableUpdateSection_updateCol);
                } else {
                    viewer.getTree().getColumn(0).setText(Messages.AvailableFixSection_fixCol);
                }
                viewer.setInput(newProfiles);
                viewer.expandAll();
                if (this.recommendedNodes.isEmpty()) {
                    this.getTreePart().setButtonVisible(0, false);
                    this.showRecommendedButton.setVisible(false);
                    this.showRecommendedButton.setSelection(false);
                } else {
                    if (this.filter == null) {
                        this.filter = new RecommendedFilter();
                    }
                    viewer.addFilter((ViewerFilter)this.filter);
                    viewer.addFilter((ViewerFilter)new PackageNodeFilter());
                }
                this.checkRecommended();
                final ScrollBar vScrollbar = viewer.getTree().getVerticalBar();
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AvailableUpdateSection.this.hasUpdateOfferings) {
                            AvailableUpdateSection.this.filterBoxPart.setFilterContainerVisible(false);
                        } else {
                            AvailableUpdateSection.this.filterBoxPart.setFilterContainerVisible(true);
                            if (vScrollbar != null) {
                                AvailableUpdateSection.this.filterBoxPart.resetFilterBoxState(vScrollbar.isVisible());
                            }
                        }
                    }
                });
            }
        } else {
            this.updatePage.validateSelectedUpdates(null, null);
            this.updatePage.updateButtons();
        }
    }

    public boolean checkUpdate(boolean refresh) {
        boolean hasUpdate;
        this.checkInputChanged(refresh);
        boolean bl = hasUpdate = this.hasUpdateOfferings || this.hasFixForInstalledOfferings;
        if (hasUpdate && refresh) {
            this.checkJobsToleranceForAgent();
        }
        return hasUpdate;
    }

    @Override
    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            if (versionNode.canBeInstalled()) {
                versionNode.getJob().setSelected(checked);
            } else if (checked) {
                return;
            }
        } else if (element instanceof FixNode) {
            FixNode fixNode = (FixNode)element;
            if (fixNode.canBeInstalled()) {
                fixNode.getJob().setSelected(checked);
            } else if (checked) {
                return;
            }
        }
        super.checkItem(viewer, element, checked, grayed);
    }

    @Override
    protected void updateParents(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element != null && element instanceof VersionNode && checked) {
            PackageNode parent = ((VersionNode)element).getParent();
            List versionNodes = parent.getVersionNodes();
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode node = (VersionNode)versionNodes.get(i);
                if (!node.equals(element)) {
                    this.checkAll(viewer, node, false);
                }
                ++i;
            }
        }
        if (element != null && element instanceof OnlyFixesNode) {
            OnlyFixesNode node = (OnlyFixesNode)element;
            node.setSelected(checked);
        }
        super.updateParents(viewer, element, checked);
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object selectedItem;
        StructuredSelection strutSelection;
        List previousSelectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element != null && element instanceof FixNode && !checked && ((FixNode)element).getParent() instanceof VersionNode) {
            CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
            this.elementChecked(viewer, element, event.getChecked());
        } else {
            if (this.checkGrayedItem(event)) {
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
                viewer.setChecked(event.getElement(), false);
                return;
            }
            if (this.checkNoInstallableChildrenNode(event)) {
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
                viewer.setChecked(event.getElement(), false);
                return;
            }
            if (checked) {
                AbstractJob job;
                if (element != null && element instanceof IAdaptable && (job = (AbstractJob)((IAdaptable)element).getAdapter(AbstractJob.class)) != null) {
                    boolean bl = checked = !StatusUtil.isErrorOrCancel((IStatus)AgentUIUtils.runPrecheckBundles((AgentJob)job));
                }
                if (checked) {
                    checked = this.checkJobsToleranceForAgentOnCheckStateChanged(event);
                }
                if (!checked) {
                    event = new CheckStateChangedEvent(event.getCheckable(), event.getElement(), checked);
                }
            }
            super.onCheckStateChange(event);
        }
        ArrayList currentSelectedJobs = new ArrayList(this.updatePage.getPrimaryUpdateWizard().getSelectedJobs());
        ArrayList addedUpdates = new ArrayList(currentSelectedJobs);
        ArrayList deselectedUpdates = new ArrayList(previousSelectedJobs);
        addedUpdates.removeAll(previousSelectedJobs);
        deselectedUpdates.removeAll(currentSelectedJobs);
        this.updatePage.validateSelectedUpdates(addedUpdates, deselectedUpdates);
        boolean resetSelection = true;
        ISelection currentSelection = this.getCheckboxTreeViewer().getSelection();
        if (currentSelection != null && currentSelection instanceof StructuredSelection && (strutSelection = (StructuredSelection)currentSelection).size() == 1 && (selectedItem = strutSelection.getFirstElement()).equals(event.getElement())) {
            resetSelection = false;
        }
        if (resetSelection) {
            this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(event.getElement()));
        }
        this.updatePage.updateButtons();
    }

    private boolean checkNoInstallableChildrenNode(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            Object element = event.getElement();
            if (element instanceof PackageNode) {
                return ((PackageNode)element).getChildren().isEmpty();
            }
            if (element instanceof ProfileNode) {
                List packageChildren = ((ProfileNode)element).getPackages();
                int i = 0;
                while (i < packageChildren.size()) {
                    PackageNode pkgNode = (PackageNode)packageChildren.get(i);
                    if (!pkgNode.getChildren().isEmpty()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkGrayedItem(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            Object element = event.getElement();
            if (element instanceof VersionNode) {
                VersionNode versionNode = (VersionNode)element;
                return !versionNode.canBeInstalled();
            }
            if (element instanceof FixNode) {
                FixNode fixNode = (FixNode)element;
                return !fixNode.canBeInstalled();
            }
        }
        return false;
    }

    @Override
    public void checkAll(CheckboxTreeViewer viewer, Object element, boolean checked) {
        Object[] children;
        this.checkItem(viewer, element, checked, false);
        if (element instanceof FixNode) {
            this.checkOrUncheckOtherFixNodes((FixNode)element, viewer, checked);
        }
        if (element instanceof OnlyFixesNode) {
            OnlyFixesNode onlyFixesNode = (OnlyFixesNode)element;
            onlyFixesNode.setSelected(checked);
        }
        Object[] objectArray = children = this.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2 = objectArray[n2];
            this.checkAll(viewer, element2, checked);
            ++n2;
        }
    }

    @Override
    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (!checked) {
            this.checkAll(viewer, element, checked);
            return;
        }
        if (element instanceof ProfileNode) {
            List packageNodes = ((ProfileNode)element).getPackages();
            int i = 0;
            while (i < packageNodes.size()) {
                PackageNode pkgNode = (PackageNode)packageNodes.get(i);
                if (!pkgNode.getChildren().isEmpty()) {
                    this.elementChecked(viewer, packageNodes.get(i), checked);
                }
                ++i;
            }
        }
        if (element instanceof PackageNode) {
            PackageNode pkgNode = (PackageNode)element;
            List versionNodes = pkgNode.getVersionNodes();
            if (versionNodes.size() == 0 || !this.containInstallableVersion(pkgNode)) {
                List<FixNode> fixNodes = pkgNode.getFixNodes();
                int i = 0;
                while (i < fixNodes.size()) {
                    FixNode fixNode = fixNodes.get(i);
                    if (fixNode.canBeInstalled() && fixNode.getToleranceStatus().isOK()) {
                        this.elementChecked(viewer, fixNode, checked);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode versionNode = (VersionNode)versionNodes.get(i);
                if (checked && versionNode.isRecommended() && versionNode.getToleranceStatus().isOK()) {
                    this.elementChecked(viewer, versionNode, checked);
                }
                ++i;
            }
        }
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            List fixNodes = versionNode.getFixes();
            int i = 0;
            while (i < fixNodes.size()) {
                FixNode fixNode = (FixNode)fixNodes.get(i);
                if (versionNode.isRecommended()) {
                    if (fixNode.isRecommended() && fixNode.getToleranceStatus().isOK()) {
                        this.elementChecked(viewer, fixNode, checked);
                    } else {
                        this.elementChecked(viewer, fixNode, false);
                    }
                } else {
                    this.elementChecked(viewer, fixNode, checked);
                }
                ++i;
            }
            PackageNode parentNode = versionNode.getParent();
            List versionNodes = parentNode.getVersionNodes();
            int i2 = 0;
            while (i2 < versionNodes.size()) {
                VersionNode node = (VersionNode)versionNodes.get(i2);
                if (!node.equals(versionNode)) {
                    this.elementChecked(viewer, node, false);
                }
                ++i2;
            }
            OnlyFixesNode onlyFixesNode = parentNode.getOnlyFixesNode();
            if (onlyFixesNode != null) {
                this.elementChecked(viewer, onlyFixesNode, false);
            }
        }
        if (element instanceof OnlyFixesNode) {
            OnlyFixesNode onlyFixesNode = (OnlyFixesNode)element;
            onlyFixesNode.setSelected(checked);
            PackageNode parentNode = onlyFixesNode.getParent();
            List versionNodes = parentNode.getVersionNodes();
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode node = (VersionNode)versionNodes.get(i);
                this.elementChecked(viewer, node, false);
                ++i;
            }
        }
        this.updateItem(viewer, element, checked);
        if (element instanceof FixNode) {
            this.checkOrUncheckOtherFixNodes((FixNode)element, viewer, checked);
        }
    }

    private void checkOrUncheckOtherFixNodes(FixNode thisFixNode, CheckboxTreeViewer viewer, boolean checked) {
        PackageNode pkgNode = (PackageNode)thisFixNode.getParent();
        if (pkgNode == null) {
            return;
        }
        ProfileNode profileNode = pkgNode.getParent();
        if (profileNode == null) {
            return;
        }
        List childrenPkgNodes = profileNode.getPackages();
        int i = 0;
        while (i < childrenPkgNodes.size()) {
            PackageNode packageNode = (PackageNode)childrenPkgNodes.get(i);
            if (!packageNode.equals(pkgNode)) {
                List<FixNode> childrenFixNodes = packageNode.getFixNodes();
                int j = 0;
                while (j < childrenFixNodes.size()) {
                    FixNode fixNode = childrenFixNodes.get(j);
                    if (fixNode.getJob().equals((Object)thisFixNode.getJob()) && viewer.getChecked((Object)fixNode) != checked) {
                        viewer.setChecked((Object)fixNode, checked);
                        viewer.setGrayed((Object)fixNode, false);
                        this.updateParents(viewer, fixNode.getParent(), checked);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private TreeColumn createColumn(Tree tree, String name, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setWidth(width);
        column.setResizable(true);
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        this.createColumn(tree, Messages.AvailableUpdateSection_updateCol, 400);
        this.createColumn(tree, Messages.AvailableUpdateSection_recommendedCol, 110);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnVendor, 120);
        this.createColumn(tree, Messages.AvailableOfferingSection_columnInstalled, 120);
    }

    @Override
    protected Control createFilterButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.showRecommendedButton = this.getContext().getForm().getToolkit().createButton(comp, Messages.AvailableFixSection_showRecommendedOnlyBtn, 0x800020);
        this.showRecommendedButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.showRecommendedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvailableUpdateSection.this.handleShowRecommendedPressed();
            }
        });
        this.showRecommendedButton.setSelection(true);
        this.showRecommendedButton.setEnabled(true);
        return comp;
    }

    void setShowAll() {
        this.showRecommendedButton.setSelection(false);
        this.handleShowRecommendedPressed();
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.doCheckRecommended();
        }
    }

    private void doCheckRecommended() {
        this.checkRecommended();
        this.checkJobsToleranceForAgent();
    }

    private void handleShowRecommendedPressed() {
        ScrollBar vScrollbar;
        if (this.showRecommendedButton.getSelection()) {
            if (this.filter == null) {
                this.filter = new RecommendedFilter();
            }
            this.getTreePart().getTreeViewer().addFilter((ViewerFilter)this.filter);
            this.updateCheckStatus();
        } else if (this.filter != null) {
            this.getTreePart().getTreeViewer().removeFilter((ViewerFilter)this.filter);
            this.getTreePart().getTreeViewer().expandAll();
        }
        if (this.filterBoxPart.isFilterContainerVisible() && (vScrollbar = this.getTreePart().getTreeViewer().getTree().getVerticalBar()) != null && vScrollbar.isVisible()) {
            this.filterBoxPart.showFilterBox();
        }
        this.updatePage.refreshDetailPage();
    }

    private void updateCheckStatus() {
        List leafRecommendedNodes = this.getLeafRecommendedNodes();
        int i = 0;
        while (i < leafRecommendedNodes.size()) {
            Object node = leafRecommendedNodes.get(i);
            boolean checked = this.getCheckboxTreeViewer().getChecked(node);
            this.updateParents(this.getCheckboxTreeViewer(), this.getParent(node), checked);
            ++i;
        }
        for (OnlyFixesNode node : this.onlyFixesNodes) {
            if (node.isRecommended() || !node.isSelected()) continue;
            node.setSelected(false);
        }
        this.updatePage.updateButtons();
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getCheckboxTreeViewer().getLabelProvider();
    }

    private Object[] getRootNodes(List profiles) {
        ArrayList<ProfileNode> profileNodes = new ArrayList<ProfileNode>();
        for (Object profile : profiles) {
            ProfileNode profileNode = this.profilesMap.get(profile);
            if (profileNode == null) continue;
            profileNodes.add(profileNode);
        }
        return profileNodes.toArray();
    }

    private void createRootNodes(List profiles) {
        this.buildVersionTree(profiles);
        AgentUIUtils.reportRepositoryConnectionMsg(CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), this.updatePage.getServiceReposStatus(), this.repLocationMsgMap);
    }

    private ProfileNode createProfileNode(Profile profile, IProgressMonitor monitor) {
        ProfileNode profileNode = new ProfileNode(profile);
        Agent agent = AgentUI.getDefault().getAgent();
        this.createPackageNodes(profileNode, agent, monitor);
        return profileNode;
    }

    private void createPackageNodes(ProfileNode profileNode, Agent agent, IProgressMonitor monitor) {
        IOffering installedOffering;
        int i;
        List packageNodes;
        Profile profile = profileNode.getProfile();
        IOffering[] installedOfferings = agent.getInstalledOfferings(profile);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(6 + installedOfferings.length));
        this.repLocationMsgMap = new HashMap();
        IStatus status = ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((boolean)true, (Map)this.repLocationMsgMap, (IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])installedOfferings, (IProgressMonitor)sm.newChild(1));
        this.updatePage.setServiceReposStatus(status);
        this.hasUpdateOfferings = false;
        this.hasFixForInstalledOfferings = false;
        Map recommended = agent.getRecommendedUpdates(profile, Statuses.ST.createMultiStatus(), (IProgressMonitor)sm.newChild(5));
        IOffering[] iOfferingArray = installedOfferings;
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installed = iOfferingArray[n2];
            PackageNode packageNode = profileNode.addPackage(installed);
            this.createVersionNodes(recommended, installed, packageNode, profile, agent, (IProgressMonitor)sm.newChild(1));
            ++n2;
        }
        if (this.hasUpdateOfferings) {
            packageNodes = profileNode.getPackages();
            i = 0;
            while (i < packageNodes.size()) {
                PackageNode pkgNode = (PackageNode)packageNodes.get(i);
                installedOffering = pkgNode.getOffering();
                this.createOnlyFixesNode(installedOffering, pkgNode, profile, agent, monitor);
                ++i;
            }
        }
        this.hasFixForInstalledOfferings = this.checkIfHasFixForInstalledOfferings(installedOfferings, profile, (IProgressMonitor)sm.newChild(1));
        if (!this.hasUpdateOfferings && this.hasFixForInstalledOfferings) {
            packageNodes = profileNode.getPackages();
            i = 0;
            while (i < packageNodes.size()) {
                PackageNode pkgNode = (PackageNode)packageNodes.get(i);
                installedOffering = pkgNode.getOffering();
                this.createFixNodes(installedOffering, pkgNode, profile, agent, monitor);
                ++i;
            }
        }
    }

    private void createVersionNodes(Map recommended, IOffering installedOffering, PackageNode packageNode, Profile profile, Agent agent, IProgressMonitor monitor) {
        PrimaryUpdateWizard wizard = this.updatePage.getPrimaryUpdateWizard();
        List wizardJobs = wizard.getJobs();
        IOffering[] updates = agent.findUpdates(true, profile, installedOffering, monitor);
        if (updates.length > 0) {
            this.hasUpdateOfferings = true;
        }
        IOffering[] iOfferingArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering updateOffering = iOfferingArray[n2];
            AbstractJob updateJob = wizard.createJob(installedOffering, profile, (IOfferingOrFix)updateOffering);
            wizardJobs.add(updateJob);
            VersionNode versionNode = packageNode.addVersion(updateJob);
            IOffering recommendedUpdate = (IOffering)recommended.get(updateOffering.getIdentity());
            if (recommendedUpdate != null && updateOffering.equals(recommendedUpdate)) {
                versionNode.setRecommended(true);
                this.recommendedNodes.add(versionNode);
            }
            ++n2;
        }
    }

    private void createOnlyFixesNode(IOffering installedOffering, PackageNode packageNode, Profile profile, Agent agent, IProgressMonitor monitor) {
        boolean hasFixes = false;
        boolean hasRecommendedFixes = false;
        for (IFix fix : agent.findFixes(true, installedOffering, monitor)) {
            if (AgentUIUtils.isFixInstalled(fix, profile)) continue;
            hasFixes = true;
            if (!agent.checkBetaRequirement((IOfferingOrFix)fix).isOK() || !FixProperty.isRecommended((IFix)fix)) continue;
            hasRecommendedFixes = true;
            break;
        }
        if (hasFixes) {
            OnlyFixesNode onlyFixesNode = packageNode.addOnlyFixesNode(hasRecommendedFixes);
            this.onlyFixesNodes.add(onlyFixesNode);
            if (onlyFixesNode.isRecommended()) {
                this.recommendedNodes.add(onlyFixesNode);
            }
        }
    }

    private boolean checkIfHasFixForInstalledOfferings(IOffering[] installedOfferings, Profile profile, IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        IOffering[] iOfferingArray = installedOfferings;
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installedOffering = iOfferingArray[n2];
            IFix[] installedFixes = agent.getInstalledFixes(profile, installedOffering);
            List fixes = agent.findFixesForProfile(true, installedOffering, monitor, (IProfile)profile);
            fixes.removeAll(Arrays.asList(installedFixes));
            if (this.updatePage.isUpdateAll) {
                for (IFix f : fixes) {
                    if (!FixProperty.isRecommended((IFix)f)) continue;
                    return true;
                }
            } else if (fixes.size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void createFixNodes(IOffering installedOffering, PackageNode parentNode, Profile profile, Agent agent, IProgressMonitor monitor) {
        PrimaryUpdateWizard wizard = this.updatePage.getPrimaryUpdateWizard();
        List wizardJobs = wizard.getJobs();
        for (IFix fix : agent.findFixesForProfile(true, installedOffering, monitor, (IProfile)profile)) {
            FixNode fixNode;
            if (AgentUIUtils.isFixInstalled(fix, profile)) continue;
            AbstractJob fixJob = this.fixJobIsInJobList(fix, profile, wizardJobs);
            if (fixJob == null) {
                fixJob = wizard.createJob(installedOffering, profile, (IOfferingOrFix)fix);
                wizardJobs.add(fixJob);
            }
            if (!(fixNode = parentNode.addFix(fixJob)).canBeInstalled() || !fixNode.isRecommended()) continue;
            this.recommendedNodes.add(fixNode);
        }
    }

    private AbstractJob fixJobIsInJobList(IFix fix, Profile profile, List jobList) {
        int i = 0;
        while (i < jobList.size()) {
            AbstractJob existingJob = (AbstractJob)jobList.get(i);
            if (existingJob.getOfferingOrFix().equals(fix) && existingJob.getProfile().equals(profile)) {
                return existingJob;
            }
            ++i;
        }
        return null;
    }

    private boolean containInstallableVersion(PackageNode pkgNode) {
        List versionNodes = pkgNode.getVersionNodes();
        if (versionNodes != null && versionNodes.size() > 0) {
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode verNode = (VersionNode)versionNodes.get(i);
                if (verNode.canBeInstalled()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void setCurrentProfile(List currentProfiles) {
        this.currentProfiles = currentProfiles;
    }

    protected void checkJobsToleranceForAgent() {
        List previousSelectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        if (!this.uncheckJobsThatDontTolerateAgent()) {
            return;
        }
        this.updatePage.setSelection(this.getSelectedJobs());
        List currentSelectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        ArrayList addedUpdates = new ArrayList(currentSelectedJobs);
        ArrayList deselectedUpdates = new ArrayList(previousSelectedJobs);
        addedUpdates.removeAll(previousSelectedJobs);
        deselectedUpdates.removeAll(currentSelectedJobs);
        this.updatePage.validateSelectedUpdates(addedUpdates, deselectedUpdates);
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AvailableUpdateSection.this.updatePage.getPrimaryUpdateWizard().checkForAgentUpdate();
            }
        });
    }

    protected AbstractJob[] getSelectedJobs() {
        List selectedJobs = this.updatePage.getPrimaryUpdateWizard().getSelectedJobs();
        return selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
    }

    private boolean uncheckJobsThatDontTolerateAgent() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        boolean uncheckedJob = false;
        List rootNodes = this.getRootNodesInOrder();
        for (PackageNode nextPackage : rootNodes) {
            for (VersionNode versionNode : nextPackage.getVersionNodes()) {
                List fixNodes = versionNode.getFixes();
                if (fixNodes != null && !fixNodes.isEmpty()) {
                    int j = 0;
                    while (j < fixNodes.size()) {
                        FixNode fixNode = (FixNode)fixNodes.get(j);
                        if (fixNode.isSelected() && (fixNode.getJob() != null && StatusUtil.isErrorOrCancel((IStatus)AgentUIUtils.runPrecheckBundles((AgentJob)fixNode.getJob())) || !fixNode.getToleranceStatus().isOK())) {
                            if (!uncheckedJob) {
                                viewer.setSelection((ISelection)new StructuredSelection((Object)fixNode));
                                uncheckedJob = true;
                            }
                            this.elementChecked(viewer, fixNode, false);
                            this.updateParents(viewer, fixNode.getParent(), false);
                        }
                        ++j;
                    }
                }
                if (!versionNode.isSelected() || !StatusUtil.isErrorOrCancel((IStatus)AgentUIUtils.runPrecheckBundles((AgentJob)versionNode.getJob())) && versionNode.getToleranceStatus().isOK()) continue;
                if (!uncheckedJob) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)versionNode));
                    uncheckedJob = true;
                }
                this.elementChecked(viewer, versionNode, false);
                this.updateParents(viewer, versionNode.getParent(), false);
            }
            for (FixNode element : nextPackage.getFixNodes()) {
                FixNode fixNode = element;
                if (!fixNode.isSelected() || !StatusUtil.isErrorOrCancel((IStatus)AgentUIUtils.runPrecheckBundles((AgentJob)fixNode.getJob())) && fixNode.getToleranceStatus().isOK()) continue;
                if (!uncheckedJob) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)fixNode));
                    uncheckedJob = true;
                }
                this.elementChecked(viewer, fixNode, false);
                this.updateParents(viewer, fixNode.getParent(), false);
            }
        }
        return uncheckedJob;
    }

    private List getRootNodesInOrder() {
        Object[] expandedElements;
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        ArrayList<Object> rootNodes = new ArrayList<Object>();
        Object[] objectArray = expandedElements = viewer.getExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof PackageNode) {
                rootNodes.add(object);
            }
            ++n2;
        }
        return rootNodes;
    }

    private boolean checkJobsToleranceForAgentOnCheckStateChanged(CheckStateChangedEvent event) {
        VersionNode parentNode;
        Object parentObject;
        FixNode fixNode;
        IStatus status = Status.OK_STATUS;
        Object element = event.getElement();
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            status = versionNode.getToleranceStatus();
        } else if (element instanceof PackageNode) {
            PackageNode packageNode = (PackageNode)element;
            VersionNode recommendedVersion = packageNode.getRecommendedVersion();
            if (recommendedVersion == null || !recommendedVersion.canBeInstalled()) {
                List installableFixes = packageNode.getInstallableFixNodes();
                boolean allFixesNotTolerant = true;
                CicMultiStatus fixToleranceStatus = Statuses.ST.createMultiStatus();
                int i = 0;
                while (i < installableFixes.size()) {
                    FixNode fixNode2 = (FixNode)installableFixes.get(i);
                    IStatus fixStatus = fixNode2.getToleranceStatus();
                    if (!fixStatus.isOK()) {
                        fixToleranceStatus.add(fixStatus);
                    } else {
                        allFixesNotTolerant = false;
                    }
                    ++i;
                }
                if (!fixToleranceStatus.isOK() && allFixesNotTolerant) {
                    status = fixToleranceStatus;
                }
            } else {
                status = recommendedVersion.getToleranceStatus();
            }
        } else if (element instanceof FixNode && (status = (fixNode = (FixNode)element).getToleranceStatus()).isOK() && (parentObject = fixNode.getParent()) != null && parentObject instanceof VersionNode && (parentNode = (VersionNode)parentObject).canBeInstalled()) {
            status = parentNode.getToleranceStatus();
        }
        if (!status.isOK()) {
            this.updatePage.offeringDetailPage.getObjectDescription(element);
            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AvailableUpdateSection.this.updatePage.getPrimaryUpdateWizard().checkForAgentUpdate();
                }
            });
            return false;
        }
        return true;
    }

    protected boolean hasUpdateOfferings() {
        return this.hasUpdateOfferings;
    }

    protected boolean hasFixesForInstalledOfferings() {
        return this.hasFixForInstalledOfferings;
    }

    public boolean hasInstallableNodeSelected() {
        Object[] elements;
        Object[] objectArray = elements = this.getCheckboxTreeViewer().getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof VersionNode || element instanceof FixNode || element instanceof OnlyFixesNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List getUpdateOnlyFixesOfferings() {
        ArrayList<IOffering> updateOnlyFixesOfferings = new ArrayList<IOffering>(this.onlyFixesNodes.size());
        for (OnlyFixesNode node : this.onlyFixesNodes) {
            if (!node.isSelected()) continue;
            updateOnlyFixesOfferings.add(node.getOffering());
        }
        return updateOnlyFixesOfferings;
    }

    public boolean isShowAllChecked() {
        return !this.showRecommendedButton.getSelection();
    }

    class JobContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        JobContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProfileNode) {
                return ((ProfileNode)parentElement).getPackages().toArray();
            }
            if (parentElement instanceof PackageNode) {
                return ((PackageNode)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return AvailableUpdateSection.this.getRootNodes((List)inputElement);
        }

        public Object getParent(Object element) {
            if (element instanceof PackageNode) {
                return ((PackageNode)element).getParent();
            }
            if (element instanceof VersionNode) {
                return ((VersionNode)element).getParent();
            }
            if (element instanceof FixNode) {
                return ((FixNode)element).getParent();
            }
            if (element instanceof OnlyFixesNode) {
                return ((OnlyFixesNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class OfferingSorter
    extends ViewerSorter {
        private OfferingSorter() {
        }

        public int category(Object element) {
            if (element instanceof PackageNode) {
                return 1;
            }
            if (element instanceof OnlyFixesNode) {
                return 2;
            }
            if (element instanceof VersionNode) {
                return 3;
            }
            if (element instanceof FixNode) {
                return 4;
            }
            return super.category(element);
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements);
        }
    }

    private static class PackageNodeFilter
    extends ViewerFilter {
        private PackageNodeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            List children;
            return !(element instanceof PackageNode) || (children = ((PackageNode)element).getChildren()).size() != 0;
        }
    }

    private static class RecommendedFilter
    extends ViewerFilter {
        private RecommendedFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof VersionNode) {
                VersionNode node = (VersionNode)element;
                if (node.isRecommended()) {
                    return true;
                }
                if (node.getJob().isSelected()) {
                    node.getJob().setSelected(false);
                }
                List fixNodes = node.getFixes();
                int i = 0;
                while (i < fixNodes.size()) {
                    FixNode fixNode = (FixNode)fixNodes.get(i);
                    if (fixNode.getJob().isSelected()) {
                        fixNode.getJob().setSelected(false);
                    }
                    ++i;
                }
                return false;
            }
            if (element instanceof FixNode) {
                FixNode node = (FixNode)element;
                if (node.isRecommended()) {
                    return true;
                }
                if (node.getJob().isSelected()) {
                    node.getJob().setSelected(false);
                }
                return false;
            }
            if (element instanceof OnlyFixesNode) {
                OnlyFixesNode node = (OnlyFixesNode)element;
                return node.isRecommended();
            }
            return true;
        }
    }
}

