/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdatePage;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.agent.internal.ui.wizards.UpdateProfileSelectionPage;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class AvailableUpdatePageWrapper
extends AvailableUpdatePage {
    private StackLayout stackLayout;
    private Composite hyperLinkComp;
    private Control availableOfferingControl;
    private final AgentUILabelProvider agentUILabelProvider;
    private final List hypeLinkControls = new ArrayList();
    private boolean selectionChanged = false;
    private final PrimaryUpdateWizard primaryUpdateWizard;

    public AvailableUpdatePageWrapper(PrimaryUpdateWizard wizard) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.UpdateWizard_updatesTitle, Messages.UpdateWizard_updatesDescription, wizard);
        this.agentUILabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentUILabelProvider.connect(this);
        this.primaryUpdateWizard = wizard;
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    private void createHyperLinkControls() {
        for (Control control : this.hypeLinkControls) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        this.hypeLinkControls.clear();
        IStatus serviceReposStatus = this.getServiceReposStatus();
        IStatus reposStatus = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(false, null);
        IRepositoryGroup repGroup = AgentUI.getDefault().getAgent().getRepositoryGroup();
        Collection repList = repGroup.getRepositories();
        StringBuffer repString = new StringBuffer();
        boolean hasNotEntitledRepos = false;
        for (IRepository rep : repList) {
            repString.append("-- ");
            repString.append(rep.getLocationStr());
            repString.append("\n");
            if (hasNotEntitledRepos || !UnavailableUtils.isUnavailable((IRepository)rep)) continue;
            hasNotEntitledRepos = true;
        }
        boolean hasError = reposStatus != null && !reposStatus.isOK() || !serviceReposStatus.isOK();
        boolean isServiceReposSet = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES.key());
        boolean isServiceRepEditable = CicPreferenceManager.getInstance().isEditable(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES);
        if (!(!isServiceReposSet && isServiceRepEditable || hasError)) {
            Label label1 = new Label(this.hyperLinkComp, 64);
            label1.setText(Messages.NoUpdateAvailablePage_noUpdate);
            label1.setLayoutData((Object)new GridData(4, 1, true, false));
            this.hypeLinkControls.add(label1);
            if (repList.size() > 0) {
                Label label2 = new Label(this.hyperLinkComp, 64);
                label2.setText("\n" + Messages.NoUpdateAvailablePage_searchedRep + "\n\n" + repString.toString());
                label2.setLayoutData((Object)new GridData(4, 1, true, false));
                this.hypeLinkControls.add(label2);
            }
        } else {
            Link repLink;
            Label iconLabel1;
            Label label1 = new Label(this.hyperLinkComp, 64);
            label1.setText(Messages.NoUpdateAvailablePage_label1);
            label1.setLayoutData((Object)new GridData(4, 1, true, false));
            this.hypeLinkControls.add(label1);
            this.hypeLinkControls.add(new Label(this.hyperLinkComp, 0));
            Label label2 = new Label(this.hyperLinkComp, 0);
            label2.setText(Messages.NoOfferingAvailablePage_label2);
            label2.setLayoutData((Object)new GridData(4, 1, true, false));
            this.hypeLinkControls.add(label2);
            Composite linkComp = new Composite(this.hyperLinkComp, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            linkComp.setLayout((Layout)gridLayout);
            linkComp.setLayoutData((Object)new GridData(4, 1, true, false));
            this.hypeLinkControls.add(linkComp);
            if (!isServiceReposSet && isServiceRepEditable) {
                iconLabel1 = new Label(linkComp, 0);
                iconLabel1.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
                repLink = new Link(linkComp, 64);
                repLink.setText(Messages.NoUpdateAvailablePage_checkServiceRep);
                repLink.setLayoutData((Object)new GridData(768));
                repLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableUpdatePageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                        dlg.open();
                        AvailableUpdatePageWrapper.this.refresh();
                    }
                });
            } else {
                iconLabel1 = new Label(linkComp, 0);
                iconLabel1.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
                repLink = new Link(linkComp, 64);
                repLink.setText(Messages.NoUpdateAvailablePage_repLink);
                repLink.setLayoutData((Object)new GridData(768));
                repLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableUpdatePageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                        dlg.open();
                        AvailableUpdatePageWrapper.this.refresh();
                    }
                });
                Label iconLabel3 = new Label(linkComp, 0);
                iconLabel3.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
                Link proxyLink = new Link(linkComp, 64);
                proxyLink.setText(Messages.NoOfferingAvailablePage_proxyLink);
                proxyLink.setLayoutData((Object)new GridData(768));
                proxyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AvailableUpdatePageWrapper.this.hyperLinkComp.getShell(), (String)"com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage", "com.ibm.cic.agent.ui.InternetPreferencePage", "com.ibm.cic.common.ui.internal.preferences.HttpProxyPreferencePage", "com.ibm.cic.common.ui.internal.preferences.FtpProxyPreferencePage"}, null);
                        dlg.open();
                        AvailableUpdatePageWrapper.this.refresh();
                    }
                });
                Label iconLabel4 = new Label(linkComp, 0);
                iconLabel4.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
                Label label3 = new Label(linkComp, 64);
                label3.setText(Messages.NoUpdateAvailablePage_fireWallLabel);
                label3.setLayoutData((Object)new GridData(4, 1, true, false));
            }
            if (hasNotEntitledRepos) {
                iconLabel1 = new Label(linkComp, 0);
                iconLabel1.setImage(this.agentUILabelProvider.get(CICImages.DESC_CATEGORY_OBJ));
                Label label3 = new Label(linkComp, 64);
                label3.setText(Messages.NoUpdateAvailablePage_notEntitled);
                label3.setLayoutData((Object)new GridData(4, 1, true, false));
            }
            this.hypeLinkControls.add(new Label(this.hyperLinkComp, 0));
            Link refreshLink = new Link(this.hyperLinkComp, 64);
            refreshLink.setText(Messages.NoOfferingAvailablePage_refreshLink);
            refreshLink.setLayoutData((Object)new GridData(768));
            refreshLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AvailableUpdatePageWrapper.this.refresh();
                }
            });
            this.hypeLinkControls.add(refreshLink);
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        comp.setLayout((Layout)this.stackLayout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        comp.setLayoutData((Object)data);
        super.createControl(comp);
        this.availableOfferingControl = this.getControl();
        this.hyperLinkComp = new Composite(comp, 2048);
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        layout.marginWidth = 20;
        this.hyperLinkComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        this.hyperLinkComp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            boolean refresh = this.selectionChanged;
            this.selectionChanged = false;
            if (this.hasUpdate(refresh)) {
                boolean hasUpdateOffering;
                this.stackLayout.topControl = this.availableOfferingControl;
                Composite parent = this.availableOfferingControl.getParent();
                if (parent != null) {
                    parent.layout();
                }
                boolean bl = hasUpdateOffering = !AgentUIUtils.allFixJobs(this.getPrimaryUpdateWizard().getJobs());
                if (hasUpdateOffering) {
                    if (this.hasFixesForInstalledOfferings()) {
                        this.setDescription(Messages.UpdateWizard_updatesDescriptionWithAvaliableFixes);
                    } else {
                        this.setDescription(Messages.UpdateWizard_updatesDescription);
                    }
                } else {
                    this.setDescription(Messages.AvailableFixPage_description);
                }
                super.getTreeSection().setFocus();
                AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.AvailableUpdatePage");
            } else {
                this.createHyperLinkControls();
                this.hyperLinkComp.layout();
                this.stackLayout.topControl = this.hyperLinkComp;
                Composite parent = this.hyperLinkComp.getParent();
                if (parent != null) {
                    parent.layout();
                }
                this.setDescription("");
                this.updateErrorMessage();
                AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.NoUpdateAvailablePage");
            }
        }
        this.getControl().setVisible(visible);
    }

    private void refresh() {
        try {
            final IStatus[] status = new IStatus[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 3);
                        SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                        status[0] = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, (IProgressMonitor)partMonitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.isUpdateAll) {
            CicMultiStatus[] checkAdminStatus = new CicMultiStatus[]{Statuses.ST.createMultiStatus()};
            Map[] repLocationMsgMap = new Map[]{new HashMap()};
            UpdateProfileSelectionPage updateProfileSelectionPage = (UpdateProfileSelectionPage)this.getPreviousPage();
            this.primaryUpdateWizard.getJobs().clear();
            updateProfileSelectionPage.searchForUpdatesOrFixes(checkAdminStatus, repLocationMsgMap);
            List selectedJobs = this.primaryUpdateWizard.getSelectedJobs();
            boolean noUpdates = selectedJobs.isEmpty();
            if (noUpdates && checkAdminStatus[0].isOK()) {
                this.stackLayout.topControl = this.hyperLinkComp;
                this.createHyperLinkControls();
                this.hyperLinkComp.layout();
                this.hyperLinkComp.getParent().layout();
                this.updateErrorMessage();
                AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.NoUpdateAvailablePage");
            } else {
                AbstractCicWizardView container = (AbstractCicWizardView)this.getWizard().getContainer();
                container.showPage((IWizardPage)updateProfileSelectionPage);
                container.nextPressed();
            }
        } else if (this.hasUpdate(true)) {
            boolean hasUpdateOffering;
            this.stackLayout.topControl = this.availableOfferingControl;
            this.availableOfferingControl.getParent().layout();
            boolean bl = hasUpdateOffering = !AgentUIUtils.allFixJobs(this.getPrimaryUpdateWizard().getJobs());
            if (hasUpdateOffering) {
                if (this.hasFixesForInstalledOfferings()) {
                    this.setDescription(Messages.UpdateWizard_updatesDescriptionWithAvaliableFixes);
                } else {
                    this.setDescription(Messages.UpdateWizard_updatesDescription);
                }
            } else {
                this.setDescription(Messages.AvailableFixPage_description);
            }
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.AvailableUpdatePage");
        } else {
            this.stackLayout.topControl = this.hyperLinkComp;
            this.createHyperLinkControls();
            this.hyperLinkComp.layout();
            this.hyperLinkComp.getParent().layout();
            this.updateErrorMessage();
            AgentUIUtils.updateHelpRefInsidePage(this, "com.ibm.cic.agent.ui.NoUpdateAvailablePage");
        }
    }

    @Override
    public void dispose() {
        this.agentUILabelProvider.disconnect(this);
        super.dispose();
    }

    private void updateErrorMessage() {
        IStatus serviceReposStatus;
        IStatus reposStatus = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(false, null);
        StringBuffer errorMsg = new StringBuffer();
        if (!reposStatus.isOK()) {
            errorMsg.append(reposStatus.getMessage());
        }
        if (!(serviceReposStatus = this.getServiceReposStatus()).isOK()) {
            errorMsg.append(serviceReposStatus.getMessage());
        }
        if (errorMsg.length() != 0) {
            String msg = String.valueOf(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected) + "\n" + errorMsg.toString();
            this.setErrorMessage(msg);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected void setSelectionChanged(boolean selectionChanged) {
        this.selectionChanged = selectionChanged;
    }
}

